/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T4C8TTILob;
import oracle.jdbc.driver.T4CConnection;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;
import oracle.sql.NCLOB;

final class T4C8TTIClob
extends T4C8TTILob {
    int[] nBytes = new int[1];
    byte[] myBufferForReuse = null;
    boolean varChar = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Sat_Aug_14_12:18:34_PDT_2010";
    public static final boolean TRACE = false;

    T4C8TTIClob(T4CConnection t4CConnection) {
        super(t4CConnection);
    }

    long read(byte[] byArray, long l2, long l3, boolean bl, char[] cArray, int n2) throws SQLException, IOException {
        long l4 = 0L;
        byte[] byArray2 = null;
        this.initializeLobdef();
        if ((byArray[6] & 0x80) == 128) {
            this.varWidthChar = true;
        }
        int n3 = 0;
        n3 = this.varWidthChar ? (int)l3 * 2 : (int)l3 * 3;
        byArray2 = this.myBufferForReuse == null || n3 > this.myBufferForReuse.length ? new byte[n3] : this.myBufferForReuse;
        if ((byArray[7] & 0x40) > 0) {
            this.littleEndianClob = true;
        }
        this.lobops = 2L;
        this.sourceLobLocator = byArray;
        this.sourceOffset = l2;
        this.lobamt = l3;
        this.sendLobamt = true;
        this.outBuffer = byArray2;
        this.doRPC();
        long l5 = this.lobamt;
        long l6 = 0L;
        if (this.varWidthChar) {
            if (this.connection.versionNumber < 10101) {
                DBConversion cfr_ignored_0 = this.meg.conv;
                DBConversion.ucs2BytesToJavaChars(this.outBuffer, (int)this.lobBytesRead, cArray);
            } else if (this.littleEndianClob) {
                CharacterSet.convertAL16UTF16LEBytesToJavaChars(this.outBuffer, 0, cArray, n2, (int)this.lobBytesRead, true);
            } else {
                CharacterSet.convertAL16UTF16BytesToJavaChars(this.outBuffer, 0, cArray, n2, (int)this.lobBytesRead, true);
            }
        } else if (!bl) {
            this.nBytes[0] = (int)this.lobBytesRead;
            this.meg.conv.CHARBytesToJavaChars(this.outBuffer, 0, cArray, n2, this.nBytes, cArray.length);
        } else {
            this.nBytes[0] = (int)this.lobBytesRead;
            this.meg.conv.NCHARBytesToJavaChars(this.outBuffer, 0, cArray, n2, this.nBytes, cArray.length);
        }
        return l5;
    }

    long write(byte[] byArray, long l2, boolean bl, char[] cArray, long l3, long l4) throws SQLException, IOException {
        this.varChar = (byArray[6] & 0x80) == 128;
        if ((byArray[7] & 0x40) == 64) {
            this.littleEndianClob = true;
        }
        long l5 = 0L;
        byte[] byArray2 = null;
        if (this.varChar) {
            byArray2 = new byte[(int)l4 * 2];
            if (this.connection.versionNumber < 10101) {
                DBConversion cfr_ignored_0 = this.meg.conv;
                DBConversion.javaCharsToUcs2Bytes(cArray, (int)l3, byArray2, 0, (int)l4);
            } else if (this.littleEndianClob) {
                CharacterSet.convertJavaCharsToAL16UTF16LEBytes(cArray, (int)l3, byArray2, 0, (int)l4);
            } else {
                CharacterSet.convertJavaCharsToAL16UTF16Bytes(cArray, (int)l3, byArray2, 0, (int)l4);
            }
        } else {
            byArray2 = new byte[(int)l4 * 3];
            l5 = !bl ? (long)this.meg.conv.javaCharsToCHARBytes(cArray, (int)l3, byArray2, 0, (int)l4) : (long)this.meg.conv.javaCharsToNCHARBytes(cArray, (int)l3, byArray2, 0, (int)l4);
        }
        this.initializeLobdef();
        this.lobops = 64L;
        this.sourceLobLocator = byArray;
        this.sourceOffset = l2;
        this.lobamt = l4;
        this.sendLobamt = true;
        this.inBuffer = byArray2;
        this.inBufferOffset = 0L;
        this.inBufferNumBytes = this.varChar ? (this.connection.versionNumber < 10101 ? l4 : l4 * 2L) : l5;
        this.doRPC();
        long l6 = this.lobamt;
        return l6;
    }

    @Override
    Datum createTemporaryLob(Connection connection, boolean bl, int n2) throws SQLException, IOException {
        return this.createTemporaryLob(connection, bl, n2, (short)1);
    }

    Datum createTemporaryLob(Connection connection, boolean bl, int n2, short s2) throws SQLException, IOException {
        if (n2 == 12) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 158);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        CLOB cLOB = null;
        this.initializeLobdef();
        this.lobops = 272L;
        this.sourceLobLocator = new byte[86];
        this.sourceLobLocator[1] = 84;
        this.lobamt = 10L;
        this.sendLobamt = true;
        this.sourceOffset = s2 == 1 ? 1L : 2L;
        this.destinationOffset = 112L;
        this.destinationLength = n2;
        this.nullO2U = true;
        short s3 = this.characterSet = s2 == 2 ? this.meg.conv.getNCharSetId() : this.meg.conv.getServerCharSetId();
        if (this.connection.versionNumber >= 9000) {
            this.lobscn = new int[1];
            this.lobscn[0] = bl ? 1 : 0;
            this.lobscnl = 1;
        }
        this.doRPC();
        if (this.sourceLobLocator != null) {
            cLOB = s2 == 1 ? new CLOB((OracleConnection)connection, this.sourceLobLocator) : new NCLOB((OracleConnection)connection, this.sourceLobLocator);
        }
        return cLOB;
    }

    @Override
    boolean open(byte[] byArray, int n2) throws SQLException, IOException {
        boolean bl = false;
        int n3 = 2;
        if (n2 == 0) {
            n3 = 1;
        }
        bl = this._open(byArray, n3, 32768);
        return bl;
    }

    @Override
    boolean close(byte[] byArray) throws SQLException, IOException {
        boolean bl = false;
        bl = this._close(byArray, 65536);
        return bl;
    }

    @Override
    boolean isOpen(byte[] byArray) throws SQLException, IOException {
        boolean bl = false;
        bl = this._isOpen(byArray, 69632);
        return bl;
    }
}

