/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.jdbc.DrvBlob;
import com.ingres.gcf.jdbc.DrvConn;
import com.ingres.gcf.jdbc.JdbcBlob;
import com.ingres.gcf.util.SqlEx;
import com.ingres.gcf.util.SqlLoc;
import com.ingres.gcf.util.SqlLongByte;
import com.ingres.gcf.util.SqlStream;
import com.ingres.gcf.util.SqlVarByte;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.SQLException;

class SqlBLoc
extends SqlLoc {
    private DrvConn conn = null;

    public SqlBLoc(DrvConn drvConn) throws SqlEx {
        this.conn = drvConn;
    }

    public void set(SqlBLoc sqlBLoc) {
        if (sqlBLoc == null || sqlBLoc.isNull()) {
            this.setNull();
        } else {
            this.conn = sqlBLoc.conn;
            this.set((SqlLoc)sqlBLoc);
        }
    }

    public void setBlob(Blob blob) throws SqlEx {
        if (blob == null) {
            this.setNull();
        } else if (blob instanceof DrvBlob) {
            this.set(((DrvBlob)blob).getLocator());
        } else {
            throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
        }
    }

    public Blob getBlob() throws SqlEx {
        return new JdbcBlob(new DrvBlob(this.conn, this.value), this.conn.cnf_lob_segSize, this.conn.trace);
    }

    public String getString() throws SqlEx {
        byte[] byArray = SqlLongByte.strm2array(this.getBinaryStream());
        return SqlVarByte.bin2str(byArray, 0, byArray.length);
    }

    public String getString(int n) throws SqlEx {
        byte[] byArray = SqlLongByte.strm2array(this.getBinaryStream(), n);
        return SqlVarByte.bin2str(byArray, 0, byArray.length);
    }

    public byte[] getBytes() throws SqlEx {
        return SqlLongByte.strm2array(this.getBinaryStream());
    }

    public byte[] getBytes(int n) throws SqlEx {
        return SqlLongByte.strm2array(this.getBinaryStream(), n);
    }

    public InputStream getBinaryStream() throws SqlEx {
        InputStream inputStream;
        DrvBlob drvBlob = new DrvBlob(this.conn, this.value);
        try {
            inputStream = drvBlob.getBinaryStream();
        }
        catch (SQLException sQLException) {
            if (sQLException instanceof SqlEx) {
                throw (SqlEx)sQLException;
            }
            throw new SqlEx(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode());
        }
        return inputStream;
    }

    public InputStream getAsciiStream() throws SqlEx {
        return SqlStream.getAsciiIS(this.getCharacterStream());
    }

    public InputStream getUnicodeStream() throws SqlEx {
        return SqlStream.getUnicodeIS(this.getCharacterStream());
    }

    public Reader getCharacterStream() throws SqlEx {
        return SqlLongByte.byteIS2hexRdr(this.getBinaryStream());
    }

    public Object getObject() throws SqlEx {
        return this.getBlob();
    }
}

