/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.CharBuffer;
import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.SqlEx;
import com.ingres.gcf.util.SqlStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class BufferedClob
implements Clob,
GcfErr {
    private CharBuffer buff = null;

    public BufferedClob() {
        this.buff = new CharBuffer();
    }

    public BufferedClob(int n) {
        this.buff = new CharBuffer(n);
    }

    public BufferedClob(Reader reader) {
        this.buff = new CharBuffer(reader);
    }

    public BufferedClob(int n, Reader reader) {
        this.buff = new CharBuffer(n, reader);
    }

    public BufferedClob(CharBuffer charBuffer) {
        this.buff = charBuffer;
    }

    public long length() throws SQLException {
        return this.buff.length();
    }

    public String getSubString(long l, int n) throws SQLException {
        if (l < 1L || n < 0) {
            throw SqlEx.get(ERR_GC4010_PARAM_VALUE);
        }
        long l2 = this.buff.length();
        l = Math.min(l - 1L, l2);
        n = (int)Math.max(0L, Math.min(l2 - l, (long)n));
        char[] cArray = new char[n];
        if (n > 0 && (int)this.buff.read(l, cArray, 0, n) != n) {
            throw SqlEx.get(ERR_GC4010_PARAM_VALUE);
        }
        return new String(cArray);
    }

    public Reader getCharacterStream() throws SQLException {
        return this.buff.getRdr();
    }

    public InputStream getAsciiStream() throws SQLException {
        return SqlStream.getAsciiIS(this.buff.getRdr());
    }

    public long position(String string, long l) throws SQLException {
        if (string == null || l < 1L) {
            throw SqlEx.get(ERR_GC4010_PARAM_VALUE);
        }
        return (l = this.buff.find(string, l - 1L)) >= 0L ? l + 1L : -1L;
    }

    public long position(Clob clob, long l) throws SQLException {
        long l2;
        if (clob == null || (l2 = clob.length()) > Integer.MAX_VALUE) {
            throw SqlEx.get(ERR_GC4010_PARAM_VALUE);
        }
        return this.position(clob.getSubString(1L, (int)l2), l);
    }

    public int setString(long l, String string) throws SQLException {
        if (string == null) {
            throw SqlEx.get(ERR_GC4010_PARAM_VALUE);
        }
        return this.setString(l, string, 0, string.length());
    }

    public int setString(long l, String string, int n, int n2) throws SQLException {
        if (string == null || n2 < 0 || l < 1L || l > this.buff.length() + 1L || n < 0 || n >= string.length()) {
            throw SqlEx.get(ERR_GC4010_PARAM_VALUE);
        }
        return (int)this.buff.write(l - 1L, string, n, n2);
    }

    public Writer setCharacterStream(long l) throws SQLException {
        Writer writer = this.buff.getWtr(l - 1L);
        if (writer == null) {
            throw SqlEx.get(ERR_GC4010_PARAM_VALUE);
        }
        return writer;
    }

    public OutputStream setAsciiStream(long l) throws SQLException {
        Writer writer = this.buff.getWtr(l - 1L);
        if (writer == null) {
            throw SqlEx.get(ERR_GC4010_PARAM_VALUE);
        }
        return SqlStream.getAsciiOS(writer);
    }

    public void truncate(long l) throws SQLException {
        if (l < 0L) {
            throw SqlEx.get(ERR_GC4010_PARAM_VALUE);
        }
        this.buff.truncate(l);
    }
}

