/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.GcfErr;
import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlEx;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public abstract class SqlStream
extends SqlData
implements GcfErr {
    private Object stream = null;
    private boolean active = false;
    private StreamListener listener = null;
    private static final byte[] bbuff = new byte[8192];
    private static final char[] cbuff = new char[4096];

    protected abstract Reader cnvtIS2Rdr(InputStream var1) throws SqlEx;

    protected SqlStream() {
        super(true);
    }

    protected SqlStream(StreamListener streamListener) {
        this();
        this.listener = streamListener;
    }

    public synchronized void setNull() {
        super.setNull();
        this.stream = null;
        this.active = false;
    }

    public String toString() {
        return "SqlStream: " + (this.stream == null ? "NULL" : this.stream.toString());
    }

    public synchronized void closeStream() {
        this.active = true;
        if (this.stream == null) {
            return;
        }
        try {
            if (this.stream instanceof InputStream) {
                ((InputStream)this.stream).close();
            } else if (this.stream instanceof Reader) {
                ((Reader)this.stream).close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected synchronized void setStream(Object object) throws SqlEx {
        if (object == null) {
            this.setNull();
        } else {
            if (!(object instanceof InputStream) && !(object instanceof Reader)) {
                throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
            }
            this.setNotNull();
            this.active = false;
            this.stream = object;
            if (object instanceof StreamSource) {
                ((StreamSource)object).addStreamListener(this.listener, this);
            }
        }
    }

    protected Object getStream() throws SqlEx {
        this.checkAccess();
        return this.stream;
    }

    protected InputStream getBinary() throws SqlEx {
        this.checkAccess();
        if (this.stream == null) {
            return null;
        }
        if (this.stream instanceof InputStream) {
            return (InputStream)this.stream;
        }
        throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
    }

    protected InputStream getAscii() throws SqlEx {
        this.checkAccess();
        if (this.stream == null) {
            return null;
        }
        if (this.stream instanceof InputStream) {
            return SqlStream.getAsciiIS(this.cnvtIS2Rdr((InputStream)this.stream));
        }
        if (this.stream instanceof Reader) {
            return SqlStream.getAsciiIS((Reader)this.stream);
        }
        throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
    }

    protected InputStream getUnicode() throws SqlEx {
        this.checkAccess();
        if (this.stream == null) {
            return null;
        }
        if (this.stream instanceof InputStream) {
            return SqlStream.getUnicodeIS(this.cnvtIS2Rdr((InputStream)this.stream));
        }
        if (this.stream instanceof Reader) {
            return SqlStream.getUnicodeIS((Reader)this.stream);
        }
        throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
    }

    protected Reader getCharacter() throws SqlEx {
        this.checkAccess();
        if (this.stream == null) {
            return null;
        }
        if (this.stream instanceof InputStream) {
            return this.cnvtIS2Rdr((InputStream)this.stream);
        }
        if (this.stream instanceof Reader) {
            return (Reader)this.stream;
        }
        throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
    }

    private synchronized void checkAccess() throws SqlEx {
        if (this.active) {
            throw SqlEx.get(ERR_GC401C_BLOB_DONE);
        }
        this.active = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyIs2Os(InputStream inputStream, OutputStream outputStream) throws SqlEx {
        try {
            byte[] byArray = bbuff;
            synchronized (bbuff) {
                int n = inputStream.read(bbuff);
                while (n >= 0) {
                    outputStream.write(bbuff, 0, n);
                    n = inputStream.read(bbuff);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                inputStream.close();
                outputStream.flush();
            }
        }
        catch (Exception exception) {
            try {
                inputStream.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            try {
                outputStream.flush();
            }
            catch (Exception exception3) {
                // empty catch block
            }
            throw SqlEx.get(ERR_GC4007_BLOB_IO, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyRdr2Wtr(Reader reader, Writer writer) throws SqlEx {
        try {
            char[] cArray = cbuff;
            synchronized (cbuff) {
                int n = reader.read(cbuff);
                while (n >= 0) {
                    writer.write(cbuff, 0, n);
                    n = reader.read(cbuff);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                reader.close();
                writer.flush();
            }
        }
        catch (Exception exception) {
            try {
                reader.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            try {
                writer.flush();
            }
            catch (Exception exception3) {
                // empty catch block
            }
            throw SqlEx.get(ERR_GC4007_BLOB_IO, exception);
        }
    }

    public static InputStream getAsciiIS(Reader reader) {
        return new Rdr2IS(reader, "US-ASCII");
    }

    public static OutputStream getAsciiOS(Writer writer) {
        return new Wtr2OS(writer, "US-ASCII");
    }

    public static InputStream getUnicodeIS(Reader reader) {
        return new Rdr2IS(reader, "UTF-8");
    }

    private static class Wtr2OS
    extends OutputStream {
        private boolean closed = false;
        private Writer wtr = null;
        private CharsetDecoder decoder = null;
        private ByteBuffer inBuff = ByteBuffer.allocate(8192);
        private CharBuffer outBuff = CharBuffer.allocate(8192);
        private byte[] ba = new byte[1];

        public Wtr2OS(Writer writer, String string) {
            this.wtr = writer;
            this.decoder = Charset.forName(string).newDecoder();
            this.decoder.onMalformedInput(CodingErrorAction.REPLACE);
            this.decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            this.inBuff.clear();
            this.outBuff.clear();
        }

        public void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                this.flushInput(true);
                while (this.decoder.flush(this.outBuff) == CoderResult.OVERFLOW) {
                    this.flushOutput(false);
                }
                this.flushOutput(true);
                this.wtr.close();
            }
        }

        public void flush() throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            this.flushInput(false);
            this.flushOutput(false);
        }

        public void write(int n) throws IOException {
            this.ba[0] = (byte)(n & 0xFF);
            this.write(this.ba, 0, 1);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n2 < 0 || byArray.length - n < n2) {
                throw new IndexOutOfBoundsException();
            }
            while (n2 > 0) {
                if (!this.inBuff.hasRemaining()) {
                    this.flushInput(false);
                }
                int n3 = Math.min(n2, this.inBuff.remaining());
                this.inBuff.put(byArray, n, n3);
                n += n3;
                n2 -= n3;
            }
        }

        private void flushInput(boolean bl) throws IOException {
            this.inBuff.flip();
            do {
                if (this.outBuff.hasRemaining()) continue;
                this.flushOutput(false);
            } while (this.decoder.decode(this.inBuff, this.outBuff, bl) == CoderResult.OVERFLOW);
            this.inBuff.clear();
        }

        private void flushOutput(boolean bl) throws IOException {
            this.outBuff.flip();
            if (this.outBuff.hasRemaining()) {
                this.wtr.write(this.outBuff.array(), this.outBuff.position(), this.outBuff.remaining());
            }
            if (bl) {
                this.wtr.flush();
            }
            this.outBuff.clear();
        }
    }

    private static class Rdr2IS
    extends InputStream {
        private static final int EOI_RDR = 1;
        private static final int EOI_ENC = 2;
        private static final int EOI_OUT = 4;
        private static final int CLOSED = 8;
        private static final int EOI = 7;
        private int eoi_flags = 0;
        private Reader rdr = null;
        private CharsetEncoder encoder = null;
        private CharBuffer inBuff = CharBuffer.allocate(8192);
        private ByteBuffer outBuff = ByteBuffer.allocate(8192);
        private byte[] ba = new byte[1];

        public Rdr2IS(Reader reader, String string) {
            this.rdr = reader;
            this.encoder = Charset.forName(string).newEncoder();
            this.encoder.onMalformedInput(CodingErrorAction.REPLACE);
            this.encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            this.inBuff.flip();
            this.outBuff.flip();
        }

        public void close() throws IOException {
            if ((this.eoi_flags & 8) == 0) {
                this.eoi_flags = 15;
                this.rdr.close();
            }
        }

        public int read() throws IOException {
            return this.read(this.ba, 0, 1) == -1 ? -1 : this.ba[0] & 0xFF;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if ((this.eoi_flags & 8) != 0) {
                throw new IOException("Stream closed");
            }
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n2 < 0 || byArray.length - n < n2) {
                throw new IndexOutOfBoundsException();
            }
            int n3 = n + n2;
            int n4 = n;
            if ((this.eoi_flags & 4) == 0) {
                while (n < n3) {
                    if (!this.outBuff.hasRemaining() && !this.fillOutput()) {
                        this.eoi_flags |= 4;
                        break;
                    }
                    n2 = Math.min(n3 - n, this.outBuff.remaining());
                    this.outBuff.get(byArray, n, n2);
                    n += n2;
                }
            }
            return n2 > 0 && n == n4 ? -1 : n - n4;
        }

        public long skip(long l) throws IOException {
            if ((this.eoi_flags & 8) != 0) {
                throw new IOException("Stream closed");
            }
            long l2 = l;
            if ((this.eoi_flags & 4) == 0) {
                while (l > 0L) {
                    if (!this.outBuff.hasRemaining() && !this.fillOutput()) {
                        this.eoi_flags |= 4;
                        break;
                    }
                    long l3 = Math.min(l, (long)this.outBuff.remaining());
                    this.outBuff.position(this.outBuff.position() + (int)l3);
                    l -= l3;
                }
            }
            return l2 - l;
        }

        private boolean fillOutput() throws IOException {
            this.outBuff.clear();
            if ((this.eoi_flags & 2) == 0) {
                do {
                    if (this.inBuff.hasRemaining() || this.fillInput()) continue;
                    if (this.outBuff.position() != 0 || this.encoder.encode(this.inBuff, this.outBuff, true) != CoderResult.UNDERFLOW || this.encoder.flush(this.outBuff) != CoderResult.UNDERFLOW) break;
                    this.eoi_flags |= 2;
                    break;
                } while (this.encoder.encode(this.inBuff, this.outBuff, false) == CoderResult.UNDERFLOW);
            }
            this.outBuff.flip();
            return this.outBuff.hasRemaining();
        }

        private boolean fillInput() throws IOException {
            boolean bl = false;
            this.inBuff.clear();
            if ((this.eoi_flags & 1) == 0) {
                int n = this.rdr.read(this.inBuff.array());
                if (n < 0) {
                    this.eoi_flags |= 1;
                } else {
                    this.inBuff.position(this.inBuff.position() + n);
                    bl = true;
                }
            }
            this.inBuff.flip();
            return bl;
        }
    }

    public static interface StreamSource {
        public void addStreamListener(StreamListener var1, SqlStream var2);
    }

    public static interface StreamListener {
        public void streamClosed(SqlStream var1);
    }
}

