package com.jaspersoft.jasperserver.dto.authority;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * @author: Zakhar.Tomchenco
 */

@XmlRootElement(name = "roles")
public class RolesListWrapper {
    private List<ClientRole> roleList;

    public RolesListWrapper(){}

    public RolesListWrapper(List<ClientRole> roles){
        roleList = new ArrayList<ClientRole>(roles.size());
        for (ClientRole r : roles){
            roleList.add(r);
        }
    }

    @XmlElement(name = "role")
    public List<ClientRole> getRoleList() {
        return roleList;
    }

    public void setRoleList(List<ClientRole> roleList) {
        this.roleList = roleList;
    }
}
