package com.jaspersoft.jasperserver.dto.authority;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

/**
 * @author: Zakhar.Tomchenco
 */
@XmlRootElement(name = "attributes")
public class UserAttributesListWrapper {
    private List<ClientUserAttribute> profileAttributes;

    public UserAttributesListWrapper(){}

    public UserAttributesListWrapper(List<ClientUserAttribute> attributes){
        profileAttributes = new ArrayList<ClientUserAttribute>(attributes.size());
        for (ClientUserAttribute r : attributes){
            profileAttributes.add((ClientUserAttribute)r);
        }
    }

    @XmlElement(name = "attribute")
    public List<ClientUserAttribute> getProfileAttributes() {
        return profileAttributes;
    }

    public void setProfileAttributes(List<ClientUserAttribute> profileAttributes) {
        this.profileAttributes = profileAttributes;
    }
}
