/*
* Copyright (C) 2005 - 2009 Jaspersoft Corporation. All rights  reserved.
* http://www.jaspersoft.com.
*
* Unless you have purchased  a commercial license agreement from Jaspersoft,
* the following license terms  apply:
*
* This program is free software: you can redistribute it and/or  modify
* it under the terms of the GNU Affero General Public License  as
* published by the Free Software Foundation, either version 3 of  the
* License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU Affero  General Public License for more details.
*
* You should have received a copy of the GNU Affero General Public  License
* along with this program.&nbsp; If not, see <http://www.gnu.org/licenses/>.
*/
package com.jaspersoft.jasperserver.dto.resources;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * <p></p>
 *
 * @author Yaroslav.Kovalchyk
 * @version $Id: ClientReportUnit.java 29531 2013-03-12 09:50:30Z ykovalchyk $
 */
@XmlRootElement(name = "reportUnit")
public class ClientReportUnit extends ClientDataSourceHolder {
    private ClientReferenceableQuery query;
    private ClientReferenceableFile jrxml;
    private List<ClientReferenceableInputControl> inputControls;
    private Map<String, ClientReferenceableFile> files;
    private String inputControlRenderingView;
    private String reportRenderingView;
    private boolean alwaysPromptControls;
    private ControlsLayoutType controlsLayout = ControlsLayoutType.popupScreen;
    private Long dataSnapshotId;

    public enum ControlsLayoutType{
        popupScreen, separatePage, topOfPage, inPage
    }

    @XmlElements({
            @XmlElement(name = "queryReference", type = ClientReference.class),
            @XmlElement(name = "localQuery", type = ClientQuery.class)
    })
    public ClientReferenceableQuery getQuery() {
        return query;
    }

    public void setQuery(ClientReferenceableQuery query) {
        this.query = query;
    }

    @XmlElements({
            @XmlElement(name = "jrxmlReference", type = ClientReference.class),
            @XmlElement(name = "localJrxml", type = ClientFile.class)
    })
    public ClientReferenceableFile getJrxml() {
        return jrxml;
    }

    public void setJrxml(ClientReferenceableFile jrxml) {
        this.jrxml = jrxml;
    }

    @XmlElementWrapper(name = "inputControls")
    @XmlElements({
            @XmlElement(name = "inputControlReference", type = ClientReference.class),
            @XmlElement(name = "localInputControl", type = ClientInputControl.class)
    })
    public List<ClientReferenceableInputControl> getInputControls() {
        return inputControls;
    }

    public void setInputControls(List<ClientReferenceableInputControl> inputControls) {
        this.inputControls = inputControls;
    }
    @XmlElementWrapper(name = "files")
    @XmlElement(name = "file")
    public List<ClientReportUnitResource> getFilesAsList() {
        List<ClientReportUnitResource> result = null;
        if(files != null && !files.isEmpty()){
            result = new ArrayList<ClientReportUnitResource>(files.size());
            for(String name : files.keySet()){
                result.add(new ClientReportUnitResource(name, files.get(name)));
            }
        }
        return result;
    }

    public void setFiles(Map<String, ClientReferenceableFile> files) {
        this.files = files;
    }

    @XmlTransient
    public Map<String, ClientReferenceableFile> getFiles() {
        return files;
    }

    public String getInputControlRenderingView() {
        return inputControlRenderingView;
    }

    public void setInputControlRenderingView(String inputControlRenderingView) {
        this.inputControlRenderingView = inputControlRenderingView;
    }

    public String getReportRenderingView() {
        return reportRenderingView;
    }

    public void setReportRenderingView(String reportRenderingView) {
        this.reportRenderingView = reportRenderingView;
    }

    public boolean isAlwaysPromptControls() {
        return alwaysPromptControls;
    }

    public void setAlwaysPromptControls(boolean alwaysPromptControls) {
        this.alwaysPromptControls = alwaysPromptControls;
    }

    public ControlsLayoutType getControlsLayout() {
        return controlsLayout;
    }

    public void setControlsLayout(ControlsLayoutType controlsLayout) {
        this.controlsLayout = controlsLayout;
    }

    public Long getDataSnapshotId() {
        return dataSnapshotId;
    }

    public void setDataSnapshotId(Long dataSnapshotId) {
        this.dataSnapshotId = dataSnapshotId;
    }
}
