/*
 * Copyright (C) 2005 - 2012 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.export.modules.repository.beans;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.AwsReportDataSource;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceExportHandler;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceImportHandler;

/**
 * @author vsabadosh
 */
public class AwsDataSourceBean extends JdbcDataSourceBean {

    private String accessKey;
    private String secretKey;
    private String roleARN;
    private String region;
    private String dbName;
    private String dbInstanceIdentifier;
    private String dbService;

    protected void additionalCopyFrom(Resource res, ResourceExportHandler referenceHandler) {
        super.additionalCopyFrom(res, referenceHandler);

        AwsReportDataSource ds = (AwsReportDataSource) res;
        setAccessKey(ds.getAWSAccessKey());
        setSecretKey(ds.getAWSSecretKey());
        setRoleARN(ds.getRoleARN());
        setRegion(ds.getAWSRegion());
        setDbName(ds.getDbName());
        setDbService(ds.getDbService());
        setDbInstanceIdentifier(ds.getDbInstanceIdentifier());
    }

    protected void additionalCopyTo(Resource res, ResourceImportHandler importHandler) {
        super.additionalCopyTo(res, importHandler);

        AwsReportDataSource ds = (AwsReportDataSource) res;
        ds.setAWSAccessKey(getAccessKey());
        ds.setAWSSecretKey(getSecretKey());
        ds.setRoleARN(getRoleARN());
        ds.setAWSRegion(getRegion());
        ds.setDbName(getDbName());
        ds.setDbService(getDbService());
        ds.setDbInstanceIdentifier(getDbInstanceIdentifier());
    }


    public String getAccessKey() {
        return accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getRoleARN() {
        return roleARN;
    }

    public void setRoleARN(String roleARN) {
        this.roleARN = roleARN;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getDbName() {
        return dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getDbInstanceIdentifier() {
        return dbInstanceIdentifier;
    }

    public void setDbInstanceIdentifier(String dbInstanceIdentifier) {
        this.dbInstanceIdentifier = dbInstanceIdentifier;
    }

    public String getDbService() {
        return dbService;
    }

    public void setDbService(String dbService) {
        this.dbService = dbService;
    }
}
