/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.export.modules.repository.beans;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.XMLAConnection;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceExportHandler;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceImportHandler;

/**
 * @author tkavanagh
 * @version $Id: XmlaConnectionBean.java 19925 2010-12-11 15:06:41Z tmatyashovsky $
 */


public class XmlaConnectionBean extends ResourceBean {

	private String uri;
	private String dataSource;
	private String catalog;
	private String username;
	private String password;
	
	protected void additionalCopyFrom(Resource res, ResourceExportHandler exportHandler) {
		XMLAConnection xmla = (XMLAConnection) res;
		setUri(xmla.getURI());
		setDataSource(xmla.getDataSource());
		setCatalog(xmla.getCatalog());
		setUsername(xmla.getUsername());
		setPassword(xmla.getPassword());
	}

	protected void additionalCopyTo(Resource res, ResourceImportHandler importHandler) {
		XMLAConnection xmla = (XMLAConnection) res;
		xmla.setURI(getUri());
		xmla.setDataSource(getDataSource());
		xmla.setCatalog(getCatalog());
		xmla.setUsername(getUsername());
		xmla.setPassword(getPassword());
	}

	public String getCatalog() {
		return catalog;
	}
	
	public void setCatalog(String catalog) {
		this.catalog = catalog;
	}
	
	public String getDataSource() {
		return dataSource;
	}
	
	public void setDataSource(String dataSource) {
		this.dataSource = dataSource;
	}
	
	public String getUri() {
		return uri;
	}
	
	public void setUri(String uri) {
		this.uri = uri;
	}
	
	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}
}
