/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.jaspersoft.jasperserver.remote.exporters;

import com.jaspersoft.jasperserver.api.engine.jasperreports.util.HtmlExportUtil;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Argument;
import com.jaspersoft.jasperserver.war.util.JRHtmlExportUtils;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;

/*  2012-09-13  thorick: restored 24858 to fix build   */
/*  2012-09-13  thorick: backout 24858 to fix build
import com.jaspersoft.jasperserver.war.util.JRHtmlExportUtils;
*/
/*  2012-09-13  thorick: backout 24858 to fix build
import net.sf.jasperreports.engine.JasperReportsContext;
*/
/*  2012-09-13  thorick: backout 24858 to fix build
import org.springframework.beans.factory.annotation.Autowired;
*/
/*  2012-09-13  thorick: backout 24858 to fix build
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
*/
/*  2012-09-13  thorick: backout 24858 to fix build
import java.util.List;
*/

/**
 * @author sanda zaharia (shertage@users.sourceforge.net)
 * @@version $Id: HtmlWSExporter.java 19933 2010-12-11 15:27:37Z tmatyashovsky $
 */
@Service("remoteHtmlExporter")
@Scope("prototype")
public class HtmlExporter extends AbstractExporter {
    public static final String CONTEXT_PATH_PARAM_NAME = "contextPath";

    @Resource
    private List<String> htmlReportHeaderIncludes;

    @Override
    public JRExporter createExporter() throws Exception {
        return HtmlExportUtil.getHtmlExporter(getJasperReportsContext());
    }

    @Override
    public void configureExporter(JRExporter exporter, HashMap exportParameters) throws Exception {
        StringBuilder htmlHeader = new StringBuilder();
        final String contextPath = (String) (exportParameters.get(CONTEXT_PATH_PARAM_NAME) != null ?
                exportParameters.get(CONTEXT_PATH_PARAM_NAME) : "");
        for (String currentInclude : htmlReportHeaderIncludes) {
            htmlHeader.append(currentInclude.replaceAll("\\{contextPath\\}", contextPath));
        }
        exporter.setParameter(JRHtmlExporterParameter.HTML_HEADER, htmlHeader.toString());
        // JR requires HttpServletRequest instance to get contextPath from it.
        // Seems it's the only field queried from the request object.
        // We need to do the trick with proxy to send contextPath to JR without having real request object.
        // We can't just inject HttpServletRequest, because in case of asynchronous export this class is invoked
        // from a different thread without valid request bound to it.
        HttpServletRequest proxy = (HttpServletRequest)Proxy.newProxyInstance(this.getClass().getClassLoader(),
                new Class<?>[]{HttpServletRequest.class}, new InvocationHandler() {
            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object result = null;
                if("getContextPath".equals(method.getName())){
                    result = contextPath;
                }
                return result;
            }
        });
        exporter.setParameter(JRHtmlExportUtils.PARAMETER_HTTP_REQUEST, proxy);
        if (exportParameters.get(JRExporterParameter.IGNORE_PAGE_MARGINS) != null)
            exporter.setParameter(JRExporterParameter.IGNORE_PAGE_MARGINS, exportParameters.get(JRExporterParameter.IGNORE_PAGE_MARGINS));

        if (exportParameters.get(Argument.RUN_OUTPUT_IMAGES_URI) != null) {
            exporter.setParameter(JRHtmlExporterParameter.IMAGES_URI, "" + exportParameters.get(Argument.RUN_OUTPUT_IMAGES_URI));
        } else {
            exporter.setParameter(JRHtmlExporterParameter.IMAGES_URI, "images/");
        }
        exporter.setParameter(JRHtmlExporterParameter.IS_USING_IMAGES_TO_ALIGN, Boolean.TRUE);

        // collecting the images into a map
        exporter.setParameter(JRHtmlExporterParameter.IMAGES_MAP, new LinkedHashMap());

    }

    @Override
    public String getContentType() {
        return "text/html";
    }
}
