/*
* Copyright (C) 2005 - 2009 Jaspersoft Corporation. All rights  reserved.
* http://www.jaspersoft.com.
*
* Unless you have purchased  a commercial license agreement from Jaspersoft,
* the following license terms  apply:
*
* This program is free software: you can redistribute it and/or  modify
* it under the terms of the GNU Affero General Public License  as
* published by the Free Software Foundation, either version 3 of  the
* License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU Affero  General Public License for more details.
*
* You should have received a copy of the GNU Affero General Public  License
* along with this program.&nbsp; If not, see <http://www.gnu.org/licenses/>.
*/
package com.jaspersoft.jasperserver.remote.resources;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;

/**
 * <p></p>
 *
 * @author Yaroslav.Kovalchyk
 * @version $Id: GenericParametersReflectionHelper.java 29335 2013-03-07 09:15:12Z ykovalchyk $
 */
public class GenericParametersReflectionHelper {
    public static String extractClientType(Class<?> clientObjectClass) {
        String clientResourceType = null;
        final XmlRootElement xmlRootElement = clientObjectClass.getAnnotation(XmlRootElement.class);
        if (xmlRootElement != null && !"##default".equals(xmlRootElement.name())) {
            clientResourceType = xmlRootElement.name();
        } else {
            final XmlType xmlType = clientObjectClass.getAnnotation(XmlType.class);
            if (xmlType != null && !"##default".equals(xmlType.name())) {
                clientResourceType = xmlType.name();
            }
        }
        if (clientResourceType == null) {
            final String classSimpleName = clientObjectClass.getSimpleName();
            clientResourceType = classSimpleName.replaceFirst("^.", classSimpleName.substring(0, 1).toLowerCase());
        }
        return clientResourceType;
    }

    public static Class<?> getGenericTypeArgument(Class<?> classToParse, Class<?> genericClassToFind, Integer argumentIndex) {
        Class<?> result = null;
        ParameterizedType parameterizedType = null;
        Class<?> currentClass = classToParse;
        Map<String, Class<?>> currentParameterValues = new HashMap<String, Class<?>>();
        Type[] previousTypeArguments = null;
        while (parameterizedType == null) {
            final TypeVariable<? extends Class<?>>[] typeParameters = currentClass.getTypeParameters();
            if (typeParameters != null && typeParameters.length > 0) {
                for (int i = 0; i < typeParameters.length; i++) {
                    TypeVariable<? extends Class<?>> currentVariable = typeParameters[i];
                    if (previousTypeArguments != null && previousTypeArguments.length > i) {
                        // fill current type parameters with arguments from subclass declaration
                        Type argumentType = previousTypeArguments[i];
                        if (argumentType instanceof Class<?>) {
                            currentParameterValues.put(currentVariable.getName(), (Class<?>) argumentType);
                            continue;
                        } else if (argumentType instanceof TypeVariable<?> && currentParameterValues.containsKey(((TypeVariable<?>) argumentType).getName())) {
                            currentParameterValues.put(currentVariable.getName(), currentParameterValues.remove(((TypeVariable<?>) argumentType).getName()));
                            continue;
                        }
                    }
                    Class<?> variableClass = null;
                    final Type[] bounds = currentVariable.getBounds();
                    if (bounds != null && bounds.length > 0 && bounds[0] instanceof Class<?>) {
                        variableClass = (Class<?>) bounds[0];
                    }
                    currentParameterValues.put(currentVariable.getName(), variableClass);
                }
            }
            parameterizedType = findParametrizedType(currentClass, genericClassToFind);
            if (parameterizedType == null) {
                // current class doesn't extend/implement searched class directly. Should parse superclass
                final Type genericSuperclassType = currentClass.getGenericSuperclass();
                if(genericSuperclassType instanceof Class<?>){
                    throw new IllegalArgumentException(classToParse.getName() + " is raw subclass of " + genericClassToFind.getName());
                }
                final ParameterizedType genericSuperclass = (ParameterizedType) genericSuperclassType;
                previousTypeArguments = genericSuperclass.getActualTypeArguments();
                currentClass = (Class<?>) genericSuperclass.getRawType();
            }
        }
        final Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        if (actualTypeArguments[argumentIndex] instanceof Class<?>) {
            result = (Class<?>) actualTypeArguments[argumentIndex];
        } else if (actualTypeArguments[argumentIndex] instanceof TypeVariable) {
            result = currentParameterValues.get(((TypeVariable<?>) actualTypeArguments[argumentIndex]).getName());
        }
        if (result == null) {
            throw new IllegalArgumentException("Class " + classToParse.getName() + " has unsupported inheritance structure");
        }
        return result;
    }

    protected static ParameterizedType findParametrizedType(Class<?> classToParse, Class<?> genericClassToFind) {
        ParameterizedType type = null;
        if (genericClassToFind.isInterface()) {
            final Type[] genericInterfaces = classToParse.getGenericInterfaces();
            if (genericInterfaces != null && genericInterfaces.length > 0) {
                for (Type genericInterface : genericInterfaces) {
                    if (genericInterface == genericClassToFind) {
                        throw new IllegalArgumentException(classToParse.getName() + " is raw implementation of " + genericClassToFind.getName());
                    }
                    if (genericInterface instanceof ParameterizedType && ((ParameterizedType) genericInterface).getRawType() == genericClassToFind) {
                        type = (ParameterizedType) genericInterface;
                        break;
                    }
                }
            }
        } else {
            final Type genericSuperclass = classToParse.getGenericSuperclass();
            if (genericSuperclass == genericClassToFind) {
                throw new IllegalArgumentException(classToParse.getName() + " is raw subclass of " + genericClassToFind.getName());
            }
            if (genericSuperclass instanceof ParameterizedType &&
                    ((ParameterizedType) genericSuperclass).getRawType() == genericClassToFind) {
                type = (ParameterizedType) genericSuperclass;
            }
        }
        return type;
    }

}
