/*
* Copyright (C) 2005 - 2009 Jaspersoft Corporation. All rights  reserved.
* http://www.jaspersoft.com.
*
* Unless you have purchased  a commercial license agreement from Jaspersoft,
* the following license terms  apply:
*
* This program is free software: you can redistribute it and/or  modify
* it under the terms of the GNU Affero General Public License  as
* published by the Free Software Foundation, either version 3 of  the
* License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU Affero  General Public License for more details.
*
* You should have received a copy of the GNU Affero General Public  License
* along with this program.&nbsp; If not, see <http://www.gnu.org/licenses/>.
*/
package com.jaspersoft.jasperserver.remote.resources.converters;

import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.AwsReportDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientAwsDataSource;
import com.jaspersoft.jasperserver.remote.exception.IllegalParameterValueException;
import org.springframework.stereotype.Service;

/**
 * <p></p>
 *
 * @author Yaroslav.Kovalchyk
 * @version $Id: AwsDataSourceResourceConverter.java 29335 2013-03-07 09:15:12Z ykovalchyk $
 */
@Service
public class AwsDataSourceResourceConverter extends JdbcDataSourceResourceConverter<AwsReportDataSource, ClientAwsDataSource> {
    @Override
    protected AwsReportDataSource resourceSpecificFieldsToServer(ClientAwsDataSource clientObject, AwsReportDataSource resultToUpdate) throws IllegalParameterValueException {
        final AwsReportDataSource awsReportDataSource = super.resourceSpecificFieldsToServer(clientObject, resultToUpdate);
        awsReportDataSource.setRoleARN(clientObject.getRoleArn());
        awsReportDataSource.setAWSAccessKey(clientObject.getAccessKey());
        awsReportDataSource.setAWSRegion(clientObject.getRegion());
        awsReportDataSource.setAWSSecretKey(clientObject.getSecretKey());
        awsReportDataSource.setDbInstanceIdentifier(clientObject.getDbInstanceIdentifier());
        awsReportDataSource.setDbName(clientObject.getDbName());
        awsReportDataSource.setDbService(clientObject.getDbService());
        return awsReportDataSource;
    }

    @Override
    protected ClientAwsDataSource resourceSpecificFieldsToClient(ClientAwsDataSource client, AwsReportDataSource serverObject) {
        final ClientAwsDataSource clientAwsDataSource = super.resourceSpecificFieldsToClient(client, serverObject);
        clientAwsDataSource.setRoleArn(serverObject.getRoleARN());
        clientAwsDataSource.setAccessKey(serverObject.getAWSAccessKey());
        clientAwsDataSource.setRegion(serverObject.getAWSRegion());
        clientAwsDataSource.setSecretKey(serverObject.getAWSSecretKey());
        clientAwsDataSource.setDbInstanceIdentifier(serverObject.getDbInstanceIdentifier());
        clientAwsDataSource.setDbName(serverObject.getDbName());
        clientAwsDataSource.setDbService(serverObject.getDbService());
        return clientAwsDataSource;
    }
}
