/*
* Copyright (C) 2005 - 2009 Jaspersoft Corporation. All rights  reserved.
* http://www.jaspersoft.com.
*
* Unless you have purchased  a commercial license agreement from Jaspersoft,
* the following license terms  apply:
*
* This program is free software: you can redistribute it and/or  modify
* it under the terms of the GNU Affero General Public License  as
* published by the Free Software Foundation, either version 3 of  the
* License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU Affero  General Public License for more details.
*
* You should have received a copy of the GNU Affero General Public  License
* along with this program.&nbsp; If not, see <http://www.gnu.org/licenses/>.
*/
package com.jaspersoft.jasperserver.remote.resources.converters;

import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.CustomReportDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientCustomDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientProperty;
import com.jaspersoft.jasperserver.remote.exception.IllegalParameterValueException;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * <p></p>
 *
 * @author Yaroslav.Kovalchyk
 * @version $Id: CustomDataSourceResourceConverter.java 29335 2013-03-07 09:15:12Z ykovalchyk $
 */
@Service
public class CustomDataSourceResourceConverter extends ResourceConverterImpl<CustomReportDataSource, ClientCustomDataSource> {
    @Override
    protected CustomReportDataSource resourceSpecificFieldsToServer(ClientCustomDataSource clientObject, CustomReportDataSource resultToUpdate) throws IllegalParameterValueException {
        resultToUpdate.setDataSourceName(clientObject.getDataSourceName());
        resultToUpdate.setServiceClass(clientObject.getServiceClass());
        Map<String, String> properties = null;
        if(clientObject.getProperties() != null && !clientObject.getProperties().isEmpty()){
            properties = new HashMap<String, String>(clientObject.getProperties().size());
            for(ClientProperty property : clientObject.getProperties()){
                properties.put(property.getKey(), property.getValue());
            }
        }
        resultToUpdate.setPropertyMap(properties);
        return resultToUpdate;
    }

    @Override
    protected ClientCustomDataSource resourceSpecificFieldsToClient(ClientCustomDataSource client, CustomReportDataSource serverObject) {
        client.setDataSourceName(serverObject.getDataSourceName());
        client.setServiceClass(serverObject.getServiceClass());
        List<ClientProperty> properties = null;
        final Map propertyMap = serverObject.getPropertyMap();
        if(propertyMap != null && !propertyMap.isEmpty()){
            properties = new ArrayList<ClientProperty>(propertyMap.size());
            final Set<String> set = propertyMap.keySet();
            for(String key : set){
                properties.add(new ClientProperty(key, (String)propertyMap.get(key)));
            }
        }
        client.setProperties(properties);
        return client;
    }
}
