/*
* Copyright (C) 2005 - 2009 Jaspersoft Corporation. All rights  reserved.
* http://www.jaspersoft.com.
*
* Unless you have purchased  a commercial license agreement from Jaspersoft,
* the following license terms  apply:
*
* This program is free software: you can redistribute it and/or  modify
* it under the terms of the GNU Affero General Public License  as
* published by the Free Software Foundation, either version 3 of  the
* License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU Affero  General Public License for more details.
*
* You should have received a copy of the GNU Affero General Public  License
* along with this program.&nbsp; If not, see <http://www.gnu.org/licenses/>.
*/
package com.jaspersoft.jasperserver.remote.resources.converters;

import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.VirtualReportDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientSubDataSourceReference;
import com.jaspersoft.jasperserver.dto.resources.ClientVirtualDataSource;
import com.jaspersoft.jasperserver.remote.exception.IllegalParameterValueException;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p></p>
 *
 * @author Yaroslav.Kovalchyk
 * @version $Id: VirtualDataSourceResourceConverter.java 29335 2013-03-07 09:15:12Z ykovalchyk $
 */
@Service
public class VirtualDataSourceResourceConverter extends ResourceConverterImpl<VirtualReportDataSource, ClientVirtualDataSource> {
    @Override
    protected VirtualReportDataSource resourceSpecificFieldsToServer(ClientVirtualDataSource clientObject, VirtualReportDataSource resultToUpdate) throws IllegalParameterValueException {
        final List<ClientSubDataSourceReference> subDataSources = clientObject.getSubDataSources();
        Map<String,ResourceReference> dataSourceUriMap = null;
        if(subDataSources != null && !subDataSources.isEmpty()){
            dataSourceUriMap = new HashMap<String, ResourceReference>(subDataSources.size());
            for(ClientSubDataSourceReference currentReference : subDataSources){
                dataSourceUriMap.put(currentReference.getId(), new ResourceReference(currentReference.getUri()));
            }
        }
        resultToUpdate.setDataSourceUriMap(dataSourceUriMap);
        return resultToUpdate;
    }

    @Override
    protected ClientVirtualDataSource resourceSpecificFieldsToClient(ClientVirtualDataSource client, VirtualReportDataSource serverObject) {
        final Map<String,ResourceReference> dataSourceUriMap = serverObject.getDataSourceUriMap();
        List<ClientSubDataSourceReference> subDataSources = null;
        if(dataSourceUriMap != null && !dataSourceUriMap.isEmpty()){
            subDataSources = new ArrayList<ClientSubDataSourceReference>(dataSourceUriMap.size());
            for(String currentId : dataSourceUriMap.keySet()){
                final ClientSubDataSourceReference currentReference = new ClientSubDataSourceReference();
                currentReference.setId(currentId);
                currentReference.setUri(dataSourceUriMap.get(currentId).getReferenceURI());
                subDataSources.add(currentReference);
            }
        }
        client.setSubDataSources(subDataSources);
        return client;
    }
}
