if (!JRS.Mooks) {
    JRS.Mooks = (function () {
        return {
            jsonStructure:[
                {
                    type:"bool",
                    uri:"/reports/coffeeBar",
                    id:"coffeeBar",
                    label:"Coffee Bar",
                    mandatory:"true",
                    readOnly: "true",
                    validators:[]
                },

                {
                    type:"singleValue",
                    uri:"/reports/name",
                    id:"name",
                    label:"Name",
                    mandatory:"true",
                    readOnly: "true",
                    validators:[]
                },

                {
                    type:"singleValueDate",
                    uri:"/reports/birthDate",
                    id:"birthDate",
                    label:"Birth Date",
                    mandatory:"true",
                    readOnly: "true",
                    validators:[]
                },

                {
                    type:"singleSelect",
                    uri:"/reports/country",
                    id:"country",
                    label:"Country",
                    mandatory:"true",
                    readOnly: "true",
                    validators:[]
                },

                {
                    type:"multiSelect",
                    uri:"/reports/state",
                    id:"state",
                    label:"State",
                    mandatory:"true",
                    readOnly: "true",
                    validators:[]
                },

                {
                    type:"multiSelect",
                    uri:"/reports/state2",
                    id:"state2",
                    label:"State 2",
                    mandatory:"true",
                    readOnly: "true",
                    validators:[]
                },

                {
                    type:"singleSelectRadio",
                    uri:"/reports/countryRadio",
                    id:"countryRadio",
                    label:"Country",
                    mandatory:"true",
                    readOnly: "true",
                    validators:[]
                },

                {
                    type:"multiSelectCheckbox",
                    uri:"/reports/stateCheckbox",
                    id:"stateCheckbox",
                    label:"State",
                    mandatory:"true",
                    readOnly: "true",
                    validators:[]
                }
            ],

            jsonData: {
                action:"init",
                controls:{
                    "coffeeBar":"true",
                    "name":"Steve",
                    "birthDate":"1987-10-15",
                    "country":[
                        {value:"Canada", label:"Canada"},
                        {value:"Mexico", label:"Mexico", selected:"true"},
                        {value:"USA", label:"USA"}
                    ],
                    "state":[
                        {value:"DF", label:"Mexico | CA"},
                        {value:"Guerrero", label:"Mexico | Guerrero", selected:"true"},
                        {value:"Jalisco", label:"Mexico | Jalisco"},
                        {value:"Sinaloa", label:"Mexico | Sinaloa", selected:"true"},
                        {value:"Veracruz", label:"Mexico | Veracruz"}
                    ],
                    "state2":[
                        {value:"DF", label:"Mexico | CA"},
                        {value:"Guerrero", label:"Mexico | Guerrero", selected:"true"},
                        {value:"Jalisco", label:"Mexico | Jalisco"},
                        {value:"Sinaloa", label:"Mexico | Sinaloa", selected:"true"},
                        {value:"Veracruz", label:"Mexico | Veracruz"}
                    ],
                    "countryRadio":[
                        {value:"Canada", label:"Canada"},
                        {value:"Mexico", label:"Mexico"},
                        {value:"USA", label:"USA", selected:"true"}
                    ],
                    "stateCheckbox":[
                        {value:"DF", label:"Mexico | CA"},
                        {value:"Guerrero", label:"Mexico | Guerrero", selected:"true"},
                        {value:"Jalisco", label:"Mexico | Jalisco"},
                        {value:"Sinaloa", label:"Mexico | Sinaloa", selected:"true"},
                        {value:"Veracruz", label:"Mexico | Veracruz"}
                    ]
                }
            },

            controlsStates:[
                {
                    uri:"/reports/coffeeBar",
                    value:"true"
                },
                {
                    uri:"/reports/country",
                    value:"",
                    options:[{
                                label:"Canada",
                                value:"Canada",
                                selected:"false"
                            },
                            {
                                label:"Mexico",
                                value:"Mexico",
                                selected:"false"
                            },
                            {
                                label:"USA",
                                value:"USA",
                                selected:"true"
                            }
                    ]
                }

            ],

            controlsData: {
                controls: {
                    "coffeeBar":"true",
                    "country":[
                        {value:"Canada", label:"Canada"},
                        {value:"Mexico", label:"Mexico"},
                        {value:"USA", label:"USA", selected:true}
                    ]
                }
            },

            selectedData: {
                "coffeeBar":["true"],
                "name":["Steve"],
                "birthDate":["1987-10-15"],
                "country":["Mexico"],
                "state":["Guerrero", "Sinaloa"],
                "state2":["Guerrero", "Sinaloa"],
                "countryRadio":["USA"],
                "stateCheckbox":["Guerrero", "Sinaloa"]
            },
            selectedDataUriString: "coffeeBar=true&name=Steve&birthDate=1987-10-15&country=Mexico&state=Guerrero&state=Sinaloa&state2=Guerrero&state2=Sinaloa&countryRadio=USA&stateCheckbox=Guerrero&stateCheckbox=Sinaloa",

            dataTransfer:{
                structure:{
                    success:{
                        status:200,
                        responseText:'{"inputControl":[{"defaultValues":{"defaultValue":"USA"},"id":"Country_multi_select","label":"Country multi select","mandatory":"true","readOnly":"false","type":"MULTI_SELECT_QUERY","uri":"repo:/reports/samples/Cascading_multi_select_report_files/Country_multi_select","visible":"true"},{"defaultValues":{"defaultValue":["CA","WA"]},"id":"Cascading_state_multi_select","label":"Cascading state multi select control","mandatory":"true","readOnly":"false","type":"MULTI_SELECT_QUERY","uri":"repo:/reports/samples/Cascading_multi_select_report_files/Cascading_state_multi_select","visible":"true"},{"defaultValues":{"defaultValue":"Alcorn-Miller Transportation Holdings"},"id":"Cascading_name_single_select","label":"Cascading name single select","mandatory":"true","readOnly":"false","type":"SINGLE_SELECT_QUERY","uri":"repo:/reports/samples/Cascading_multi_select_report_files/Cascading_name_single_select","visible":"true"}]}'
                    },
                    expected:{
                        formatedStructure:[
                            {
                                "defaultValues":undefined,
                                "id":"Country_multi_select",
                                "label":"Country multi select",
                                "mandatory":"true",
                                "readOnly":false,
                                "type":"multiSelect",
                                "uri":"repo:/reports/samples/Cascading_multi_select_report_files/Country_multi_select",
                                "visible":"true"
                            },
                            {
                                "defaultValues":undefined,
                                "id":"Cascading_state_multi_select",
                                "label":"Cascading state multi select control",
                                "mandatory":"true",
                                "readOnly":false,
                                "type":"multiSelect",
                                "uri":"repo:/reports/samples/Cascading_multi_select_report_files/Cascading_state_multi_select",
                                "visible":"true"
                            },
                            {
                                "defaultValues":undefined,
                                "id":"Cascading_name_single_select",
                                "label":"Cascading name single select",
                                "mandatory":"true",
                                "readOnly":false,
                                "type":"singleSelect",
                                "uri":"repo:/reports/samples/Cascading_multi_select_report_files/Cascading_name_single_select",
                                "visible":"true"
                            }
                        ],
                        requestUrl:"rest_v2/reports/reports/samples/Cascading_multi_select_report/inputControls"
                    }

                },
                initialValues:{
                    success:{
                        status:200,
                        responseText:'{"inputControlState":[{"uri":"/reports/samples/Cascading_multi_select_report_files/Country_multi_select","value":"","options":{"option":[{"label":"Canada","selected":"false","value":"Canada"},{"label":"Mexico","selected":"false","value":"Mexico"},{"label":"USA","selected":"true","value":"USA"}]}},{"uri":"/reports/samples/Cascading_multi_select_report_files/Cascading_state_multi_select","value":"","options":{"option":[{"label":"USA | CA","selected":"true","value":"CA"},{"label":"USA | OR","selected":"false","value":"OR"},{"label":"USA | WA","selected":"true","value":"WA"}]}},{"uri":"/reports/samples/Cascading_multi_select_report_files/Cascading_name_single_select","value":"","options":{"option":[{"label":"Ace-Trujillo Communications Corp","selected":"false","value":"Ace-Trujillo Communications Corp"},{"label":"Adams-Steen Transportation Holdings","selected":"false","value":"Adams-Steen Transportation Holdings"},{"label":"Adina-Bohling Transportation Holdings","selected":"false","value":"Adina-Bohling Transportation Holdings"},{"label":"Agcaoili-Sabella Construction Partners","selected":"false","value":"Agcaoili-Sabella Construction Partners"},{"label":"Alcorn-Miller Transportation Holdings","selected":"true","value":"Alcorn-Miller Transportation Holdings"},{"label":"Alexander-Mendoza Machinery Group","selected":"false","value":"Alexander-Mendoza Machinery Group"},{"label":"Allenbach-Smith Communications Holdings","selected":"false","value":"Allenbach-Smith Communications Holdings"},{"label":"Allen-Worth Transportation, Inc","selected":"false","value":"Allen-Worth Transportation, Inc"},{"label":"Allison-Vargas Construction Company","selected":"false","value":"Allison-Vargas Construction Company"},{"label":"Alpha-Murraiin Communications, Inc","selected":"false","value":"Alpha-Murraiin Communications, Inc"},{"label":"Alpuerto-Marshall Engineering, Inc","selected":"false","value":"Alpuerto-Marshall Engineering, Inc"},{"label":"Amole-Hill Engineering Partners","selected":"false","value":"Amole-Hill Engineering Partners"},{"label":"Anderson-Allen Construction, Ltd","selected":"false","value":"Anderson-Allen Construction, Ltd"},{"label":"Anderson-Everson Transportation Holdings","selected":"false","value":"Anderson-Everson Transportation Holdings"},{"label":"Anderson-Gomez Machinery Partners","selected":"false","value":"Anderson-Gomez Machinery Partners"},{"label":"Ansaldo-Caijem Telecommunications, Ltd","selected":"false","value":"Ansaldo-Caijem Telecommunications, Ltd"},{"label":"Antrim-Friedland Communications Associates","selected":"false","value":"Antrim-Friedland Communications Associates"},{"label":"Arakawa-Steuber Engineering Associates","selected":"false","value":"Arakawa-Steuber Engineering Associates"},{"label":"Ardell-Nakauchi Electronics, Inc","selected":"false","value":"Ardell-Nakauchi Electronics, Inc"},{"label":"Arnold-Cooper Transportation Holdings","selected":"false","value":"Arnold-Cooper Transportation Holdings"},{"label":"Auintana-Flanigan Machinery Corp","selected":"false","value":"Auintana-Flanigan Machinery Corp"},{"label":"A & U Jaramillo Telecommunications, Inc","selected":"false","value":"A & U Jaramillo Telecommunications, Inc"},{"label":"A & U Stalker Telecommunications, Inc","selected":"false","value":"A & U Stalker Telecommunications, Inc"},{"label":"Avalos-Jacobsen Electronics, Ltd","selected":"false","value":"Avalos-Jacobsen Electronics, Ltd"},{"label":"Azzolino-Archuleta Machinery Partners","selected":"false","value":"Azzolino-Archuleta Machinery Partners"},{"label":"Baker-Castillo Electronics Holdings","selected":"false","value":"Baker-Castillo Electronics Holdings"},{"label":"Baker-Finke Construction Group","selected":"false","value":"Baker-Finke Construction Group"},{"label":"Banks-Carlisle Machinery, Inc","selected":"false","value":"Banks-Carlisle Machinery, Inc"},{"label":"Barley-Alvaro Transportation Holdings","selected":"false","value":"Barley-Alvaro Transportation Holdings"},{"label":"Barnes-Camille Telecommunications, Inc","selected":"false","value":"Barnes-Camille Telecommunications, Inc"},{"label":"Barry-Chang Electronics, Ltd","selected":"false","value":"Barry-Chang Electronics, Ltd"},{"label":"Bartness-Cobb Electronics Corp","selected":"false","value":"Bartness-Cobb Electronics Corp"},{"label":"Bauer-Collins Transportation Group","selected":"false","value":"Bauer-Collins Transportation Group"},{"label":"B & D Cantoni Machinery Partners","selected":"false","value":"B & D Cantoni Machinery Partners"},{"label":"B & D Potter Machinery Partners","selected":"false","value":"B & D Potter Machinery Partners"},{"label":"B & D Reitzel Machinery Partners","selected":"false","value":"B & D Reitzel Machinery Partners"},{"label":"B & D Smith Machinery Partners","selected":"false","value":"B & D Smith Machinery Partners"},{"label":"B & D Spivey Machinery Partners","selected":"false","value":"B & D Spivey Machinery Partners"},{"label":"B & D Visser Machinery Partners","selected":"false","value":"B & D Visser Machinery Partners"},{"label":"B & D Wold Machinery Partners","selected":"false","value":"B & D Wold Machinery Partners"},{"label":"B & D Wolter Machinery Partners","selected":"false","value":"B & D Wolter Machinery Partners"},{"label":"Beck-Abel Electronics Company","selected":"false","value":"Beck-Abel Electronics Company"},{"label":"Belli-Porter Telecommunications, Ltd","selected":"false","value":"Belli-Porter Telecommunications, Ltd"},{"label":"Bennetts-Woodard Electronics Company","selected":"false","value":"Bennetts-Woodard Electronics Company"},{"label":"Benson-Rusch Construction Associates","selected":"false","value":"Benson-Rusch Construction Associates"},{"label":"Bentley-Ritacco Construction, Ltd","selected":"false","value":"Bentley-Ritacco Construction, Ltd"},{"label":"Berch-Taylor Engineering, Ltd","selected":"false","value":"Berch-Taylor Engineering, Ltd"},{"label":"Bergin-Steel Engineering Company","selected":"false","value":"Bergin-Steel Engineering Company"},{"label":"Bernard-Macaluso Telecommunications, Ltd","selected":"false","value":"Bernard-Macaluso Telecommunications, Ltd"},{"label":"Bevan-Monarco Construction Company","selected":"false","value":"Bevan-Monarco Construction Company"},{"label":"Bidelman-Gee Engineering Associates","selected":"false","value":"Bidelman-Gee Engineering Associates"},{"label":"Blackburn-Abston Communications Holdings","selected":"false","value":"Blackburn-Abston Communications Holdings"},{"label":"Black-Vansant Construction Company","selected":"false","value":"Black-Vansant Construction Company"},{"label":"Blasingame-Blackwell Construction Associates","selected":"false","value":"Blasingame-Blackwell Construction Associates"},{"label":"Blauvelt-Wardley Transportation, Inc","selected":"false","value":"Blauvelt-Wardley Transportation, Inc"},{"label":"Bobbitt-Boston Engineering Associates","selected":"false","value":"Bobbitt-Boston Engineering Associates"},{"label":"Bockenkamp-Kesterson Transportation Holdings","selected":"false","value":"Bockenkamp-Kesterson Transportation Holdings"},{"label":"Bomar-Renfro Engineering Partners","selected":"false","value":"Bomar-Renfro Engineering Partners"},{"label":"Borges-Wyro Telecommunications, Ltd","selected":"false","value":"Borges-Wyro Telecommunications, Ltd"},{"label":"Bouton-Gras Construction, Ltd","selected":"false","value":"Bouton-Gras Construction, Ltd"},{"label":"Bowen-Pochert Engineering Associates","selected":"false","value":"Bowen-Pochert Engineering Associates"},{"label":"Bowman-Coleman Construction Group","selected":"false","value":"Bowman-Coleman Construction Group"},{"label":"Bowman-Germanson Communications Holdings","selected":"false","value":"Bowman-Germanson Communications Holdings"},{"label":"Bozeman-Kassab Machinery Group","selected":"false","value":"Bozeman-Kassab Machinery Group"},{"label":"B & P Barnurn Telecommunications Holdings","selected":"false","value":"B & P Barnurn Telecommunications Holdings"},{"label":"B & P Breer Telecommunications Holdings","selected":"false","value":"B & P Breer Telecommunications Holdings"},{"label":"B & P Brown Telecommunications Holdings","selected":"false","value":"B & P Brown Telecommunications Holdings"},{"label":"B & P Burkett Telecommunications Holdings","selected":"false","value":"B & P Burkett Telecommunications Holdings"},{"label":"B & P Cox Telecommunications Holdings","selected":"false","value":"B & P Cox Telecommunications Holdings"},{"label":"B & P Guardamondo Telecommunications Holdings","selected":"false","value":"B & P Guardamondo Telecommunications Holdings"},{"label":"B & P Ratcliff Telecommunications Holdings","selected":"false","value":"B & P Ratcliff Telecommunications Holdings"},{"label":"B & P Whitney Telecommunications Holdings","selected":"false","value":"B & P Whitney Telecommunications Holdings"},{"label":"Brady, Jr.-Gray Machinery Group","selected":"false","value":"Brady, Jr.-Gray Machinery Group"},{"label":"Brandberry-Henderson Electronics Group","selected":"false","value":"Brandberry-Henderson Electronics Group"},{"label":"Breer-Barrera Electronics, Ltd","selected":"false","value":"Breer-Barrera Electronics, Ltd"},{"label":"Brinkd-Clark Communications Holdings","selected":"false","value":"Brinkd-Clark Communications Holdings"},{"label":"Brooks-Logan Construction Holdings","selected":"false","value":"Brooks-Logan Construction Holdings"},{"label":"Browning-Lyeba Transportation, Inc","selected":"false","value":"Browning-Lyeba Transportation, Inc"},{"label":"Browqett-Kartz Communications Associates","selected":"false","value":"Browqett-Kartz Communications Associates"},{"label":"Bruha-Suggs Construction, Ltd","selected":"false","value":"Bruha-Suggs Construction, Ltd"},{"label":"Brumagen-Hamilton Transportation Holdings","selected":"false","value":"Brumagen-Hamilton Transportation Holdings"},{"label":"Bruner-Troyer Transportation Holdings","selected":"false","value":"Bruner-Troyer Transportation Holdings"},{"label":"Brunner-Frazier Telecommunications, Ltd","selected":"false","value":"Brunner-Frazier Telecommunications, Ltd"},{"label":"Brunner-Staton Construction Holdings","selected":"false","value":"Brunner-Staton Construction Holdings"},{"label":"Bruno-Berger Construction Partners","selected":"false","value":"Bruno-Berger Construction Partners"},{"label":"Burger-Blau Communications Holdings","selected":"false","value":"Burger-Blau Communications Holdings"},{"label":"Burke-Bates Construction Group","selected":"false","value":"Burke-Bates Construction Group"},{"label":"Burke-Lindsay Telecommunications Partners","selected":"false","value":"Burke-Lindsay Telecommunications Partners"},{"label":"Burkett-Drake Engineering Partners","selected":"false","value":"Burkett-Drake Engineering Partners"},{"label":"Burkhardt-Whitney Engineering, Ltd","selected":"false","value":"Burkhardt-Whitney Engineering, Ltd"},{"label":"Burnett-Haugh Telecommunications, Inc","selected":"false","value":"Burnett-Haugh Telecommunications, Inc"},{"label":"Bustamante-Eldridge Construction Associates","selected":"false","value":"Bustamante-Eldridge Construction Associates"},{"label":"B & X Rybolt Electronics, Inc","selected":"false","value":"B & X Rybolt Electronics, Inc"},{"label":"B & Y Maestas Engineering Holdings","selected":"false","value":"B & Y Maestas Engineering Holdings"},{"label":"C & A Bentley Engineering Group","selected":"false","value":"C & A Bentley Engineering Group"},{"label":"Camacho-Alvarado Transportation Company","selected":"false","value":"Camacho-Alvarado Transportation Company"},{"label":"C & A Mitzner Engineering Group","selected":"false","value":"C & A Mitzner Engineering Group"},{"label":"Campbell-Roberts Telecommunications, Inc","selected":"false","value":"Campbell-Roberts Telecommunications, Inc"},{"label":"Campbell-Walker Transportation Holdings","selected":"false","value":"Campbell-Walker Transportation Holdings"},{"label":"Campbell-Watson Engineering, Inc","selected":"false","value":"Campbell-Watson Engineering, Inc"},{"label":"Campen-Coffman Communications Corp","selected":"false","value":"Campen-Coffman Communications Corp"},{"label":"Campos-Unfried Construction, Ltd","selected":"false","value":"Campos-Unfried Construction, Ltd"},{"label":"C & A Orando Engineering Group","selected":"false","value":"C & A Orando Engineering Group"},{"label":"Caprio-Slaven Machinery Partners","selected":"false","value":"Caprio-Slaven Machinery Partners"},{"label":"Caravello-Paulson Construction Partners","selected":"false","value":"Caravello-Paulson Construction Partners"},{"label":"Cardoza-Hall Engineering, Inc","selected":"false","value":"Cardoza-Hall Engineering, Inc"},{"label":"Carlson-Margolis Machinery Company","selected":"false","value":"Carlson-Margolis Machinery Company"},{"label":"Carmona-Saxton Construction Associates","selected":"false","value":"Carmona-Saxton Construction Associates"},{"label":"Carpenter-Watkins Construction Partners","selected":"false","value":"Carpenter-Watkins Construction Partners"},{"label":"Carreras-Burtis Transportation Holdings","selected":"false","value":"Carreras-Burtis Transportation Holdings"},{"label":"Carroll-Contreras Communications Associates","selected":"false","value":"Carroll-Contreras Communications Associates"},{"label":"Carter-Sharp Machinery, Ltd","selected":"false","value":"Carter-Sharp Machinery, Ltd"},{"label":"Case-Terry Construction Holdings","selected":"false","value":"Case-Terry Construction Holdings"},{"label":"Castro-Caldwell Transportation Holdings","selected":"false","value":"Castro-Caldwell Transportation Holdings"},{"label":"Catalano-Coleman Telecommunications, Ltd","selected":"false","value":"Catalano-Coleman Telecommunications, Ltd"},{"label":"C & A Valerio Engineering Group","selected":"false","value":"C & A Valerio Engineering Group"},{"label":"C & A Vlass Engineering Group","selected":"false","value":"C & A Vlass Engineering Group"},{"label":"C & A Zingarelli Engineering Group","selected":"false","value":"C & A Zingarelli Engineering Group"},{"label":"Chestnut-Toone Construction Group","selected":"false","value":"Chestnut-Toone Construction Group"},{"label":"Christensen-Pectol Construction, Ltd","selected":"false","value":"Christensen-Pectol Construction, Ltd"},{"label":"Christie-Zocchi Engineering Company","selected":"false","value":"Christie-Zocchi Engineering Company"},{"label":"Ciochon-Berger Transportation, Inc","selected":"false","value":"Ciochon-Berger Transportation, Inc"},{"label":"Clifford-Smith Construction, Ltd","selected":"false","value":"Clifford-Smith Construction, Ltd"},{"label":"Cocadiz-Mcgough Engineering Corp","selected":"false","value":"Cocadiz-Mcgough Engineering Corp"},{"label":"Cole-Huntsman Construction, Ltd","selected":"false","value":"Cole-Huntsman Construction, Ltd"},{"label":"Corcoran-Good Transportation Holdings","selected":"false","value":"Corcoran-Good Transportation Holdings"},{"label":"Cox-Clare Engineering Associates","selected":"false","value":"Cox-Clare Engineering Associates"},{"label":"Cox-Jacobs Electronics, Ltd","selected":"false","value":"Cox-Jacobs Electronics, Ltd"},{"label":"Coy-Putinas Engineering Associates","selected":"false","value":"Coy-Putinas Engineering Associates"},{"label":"C & R Cruz Engineering Partners","selected":"false","value":"C & R Cruz Engineering Partners"},{"label":"Crouch-Henderson Electronics Holdings","selected":"false","value":"Crouch-Henderson Electronics Holdings"},{"label":"Crow-Sims Construction Associates","selected":"false","value":"Crow-Sims Construction Associates"},{"label":"Cruz-Geiermann Engineering Company","selected":"false","value":"Cruz-Geiermann Engineering Company"},{"label":"Curtsinger-Swartwood Engineering Holdings","selected":"false","value":"Curtsinger-Swartwood Engineering Holdings"},{"label":"C & Y Difatta Machinery Partners","selected":"false","value":"C & Y Difatta Machinery Partners"},{"label":"C & Y Tomlinson Machinery Partners","selected":"false","value":"C & Y Tomlinson Machinery Partners"},{"label":"D & A Blasingame Machinery Group","selected":"false","value":"D & A Blasingame Machinery Group"},{"label":"D & A Maccietto Machinery Group","selected":"false","value":"D & A Maccietto Machinery Group"},{"label":"D & A Rector Machinery Group","selected":"false","value":"D & A Rector Machinery Group"},{"label":"D & A Tancredy Machinery Group","selected":"false","value":"D & A Tancredy Machinery Group"},{"label":"D & A Vaughn Machinery Group","selected":"false","value":"D & A Vaughn Machinery Group"},{"label":"Davis-Westgaard Transportation Holdings","selected":"false","value":"Davis-Westgaard Transportation Holdings"},{"label":"D & A Wood Machinery Group","selected":"false","value":"D & A Wood Machinery Group"},{"label":"D & A Yates Machinery Group","selected":"false","value":"D & A Yates Machinery Group"},{"label":"D & A Zubaty Machinery Group","selected":"false","value":"D & A Zubaty Machinery Group"},{"label":"D & D Barrera Transportation, Ltd","selected":"false","value":"D & D Barrera Transportation, Ltd"},{"label":"D & D Collins Electronics Holdings","selected":"false","value":"D & D Collins Electronics Holdings"},{"label":"D & D Noice Transportation, Ltd","selected":"false","value":"D & D Noice Transportation, Ltd"},{"label":"D & D Saunders Transportation, Ltd","selected":"false","value":"D & D Saunders Transportation, Ltd"},{"label":"D & D Sipsy Electronics Holdings","selected":"false","value":"D & D Sipsy Electronics Holdings"},{"label":"D & D Tatman Electronics Holdings","selected":"false","value":"D & D Tatman Electronics Holdings"},{"label":"D & D Tench Electronics Holdings","selected":"false","value":"D & D Tench Electronics Holdings"},{"label":"D & D Trujillo Transportation, Ltd","selected":"false","value":"D & D Trujillo Transportation, Ltd"},{"label":"D & D Yuhasz Transportation, Ltd","selected":"false","value":"D & D Yuhasz Transportation, Ltd"},{"label":"Demott Jr-Carmichael Construction Associates","selected":"false","value":"Demott Jr-Carmichael Construction Associates"},{"label":"Dennis-Brumfield Transportation, Inc","selected":"false","value":"Dennis-Brumfield Transportation, Inc"},{"label":"D & E Sall Telecommunications, Inc","selected":"false","value":"D & E Sall Telecommunications, Inc"},{"label":"Detwiler-Biltoft Transportation Corp","selected":"false","value":"Detwiler-Biltoft Transportation Corp"},{"label":"D & G Aldred Transportation, Inc","selected":"false","value":"D & G Aldred Transportation, Inc"},{"label":"D & G Bales Transportation, Inc","selected":"false","value":"D & G Bales Transportation, Inc"},{"label":"D & G Berch Transportation, Inc","selected":"false","value":"D & G Berch Transportation, Inc"},{"label":"D & G Enlow Transportation, Inc","selected":"false","value":"D & G Enlow Transportation, Inc"},{"label":"D & G Estes Transportation, Inc","selected":"false","value":"D & G Estes Transportation, Inc"},{"label":"D & G Justice Transportation, Inc","selected":"false","value":"D & G Justice Transportation, Inc"},{"label":"Dodd-Cereghino Transportation Holdings","selected":"false","value":"Dodd-Cereghino Transportation Holdings"},{"label":"Doolittle-Burnham Transportation Corp","selected":"false","value":"Doolittle-Burnham Transportation Corp"},{"label":"Drury-Watts Engineering Company","selected":"false","value":"Drury-Watts Engineering Company"},{"label":"D & T Coy Transportation Holdings","selected":"false","value":"D & T Coy Transportation Holdings"},{"label":"D & Z Cocadiz Electronics, Ltd","selected":"false","value":"D & Z Cocadiz Electronics, Ltd"},{"label":"D & Z Fulcher Electronics, Ltd","selected":"false","value":"D & Z Fulcher Electronics, Ltd"},{"label":"D & Z Gonzales Electronics, Ltd","selected":"false","value":"D & Z Gonzales Electronics, Ltd"},{"label":"D & Z Moya Electronics, Ltd","selected":"false","value":"D & Z Moya Electronics, Ltd"},{"label":"D & Z Sincich Electronics, Ltd","selected":"false","value":"D & Z Sincich Electronics, Ltd"},{"label":"D & Z Smith Electronics, Ltd","selected":"false","value":"D & Z Smith Electronics, Ltd"},{"label":"D & Z Torre Electronics, Ltd","selected":"false","value":"D & Z Torre Electronics, Ltd"},{"label":"Earley-Horne Engineering Partners","selected":"false","value":"Earley-Horne Engineering Partners"},{"label":"E & C Bowen Machinery Partners","selected":"false","value":"E & C Bowen Machinery Partners"},{"label":"E & C Isaacs Machinery Partners","selected":"false","value":"E & C Isaacs Machinery Partners"},{"label":"Ecoffey-Swint Machinery Partners","selected":"false","value":"Ecoffey-Swint Machinery Partners"},{"label":"E & F Adams Machinery, Ltd","selected":"false","value":"E & F Adams Machinery, Ltd"},{"label":"E & F Anderson Machinery, Ltd","selected":"false","value":"E & F Anderson Machinery, Ltd"},{"label":"E & F Bockenkamp Machinery, Ltd","selected":"false","value":"E & F Bockenkamp Machinery, Ltd"},{"label":"E & F Deborde Machinery, Ltd","selected":"false","value":"E & F Deborde Machinery, Ltd"},{"label":"E & F Williams Machinery, Ltd","selected":"false","value":"E & F Williams Machinery, Ltd"},{"label":"Eichorn-Belsey Machinery Group","selected":"false","value":"Eichorn-Belsey Machinery Group"},{"label":"Elson-Hirota Telecommunications, Ltd","selected":"false","value":"Elson-Hirota Telecommunications, Ltd"},{"label":"E & M Consentino Electronics Company","selected":"false","value":"E & M Consentino Electronics Company"},{"label":"E & M Magenheimer Electronics Company","selected":"false","value":"E & M Magenheimer Electronics Company"},{"label":"E & M Noakes Electronics Company","selected":"false","value":"E & M Noakes Electronics Company"},{"label":"E & M Renfro Electronics Company","selected":"false","value":"E & M Renfro Electronics Company"},{"label":"E & M Spencer Electronics Company","selected":"false","value":"E & M Spencer Electronics Company"},{"label":"E & M Steger Electronics Company","selected":"false","value":"E & M Steger Electronics Company"},{"label":"E & M Vincenzi Electronics Company","selected":"false","value":"E & M Vincenzi Electronics Company"},{"label":"Enlow-Lee Engineering, Ltd","selected":"false","value":"Enlow-Lee Engineering, Ltd"},{"label":"E & Q Curtsinger Engineering, Ltd","selected":"false","value":"E & Q Curtsinger Engineering, Ltd"},{"label":"E & Q Petranoff Engineering, Ltd","selected":"false","value":"E & Q Petranoff Engineering, Ltd"},{"label":"Espinoza-Robinett Electronics Holdings","selected":"false","value":"Espinoza-Robinett Electronics Holdings"},{"label":"Evans-Storjohann Telecommunications, Ltd","selected":"false","value":"Evans-Storjohann Telecommunications, Ltd"},{"label":"Farrell-Ault Construction, Ltd","selected":"false","value":"Farrell-Ault Construction, Ltd"},{"label":"Fielder-Finnell Electronics Company","selected":"false","value":"Fielder-Finnell Electronics Company"},{"label":"F & M Detwiler Transportation Corp","selected":"false","value":"F & M Detwiler Transportation Corp"},{"label":"F & M Hansen Transportation Corp","selected":"false","value":"F & M Hansen Transportation Corp"},{"label":"F & P Bishop Communications, Inc","selected":"false","value":"F & P Bishop Communications, Inc"},{"label":"Frank-Wood Machinery, Ltd","selected":"false","value":"Frank-Wood Machinery, Ltd"},{"label":"Fulton-Dillon Construction, Ltd","selected":"false","value":"Fulton-Dillon Construction, Ltd"},{"label":"F & X Bowman Communications Partners","selected":"false","value":"F & X Bowman Communications Partners"},{"label":"F & X Brinkd Communications Partners","selected":"false","value":"F & X Brinkd Communications Partners"},{"label":"F & X Kobylinski Communications Partners","selected":"false","value":"F & X Kobylinski Communications Partners"},{"label":"F & X Kotc Communications Partners","selected":"false","value":"F & X Kotc Communications Partners"},{"label":"F & X Moberly Communications Partners","selected":"false","value":"F & X Moberly Communications Partners"},{"label":"F & X Murphy Communications Partners","selected":"false","value":"F & X Murphy Communications Partners"},{"label":"F & X Reynolds Communications Partners","selected":"false","value":"F & X Reynolds Communications Partners"},{"label":"Gabbard-Lebaron Construction Group","selected":"false","value":"Gabbard-Lebaron Construction Group"},{"label":"Galich-Watson Construction, Ltd","selected":"false","value":"Galich-Watson Construction, Ltd"},{"label":"Gambao-Snow Telecommunications, Ltd","selected":"false","value":"Gambao-Snow Telecommunications, Ltd"},{"label":"Garrison-Zeller Transportation Holdings","selected":"false","value":"Garrison-Zeller Transportation Holdings"},{"label":"Garza-Westover Machinery Partners","selected":"false","value":"Garza-Westover Machinery Partners"},{"label":"Gentry-Heckman Communications Corp","selected":"false","value":"Gentry-Heckman Communications Corp"},{"label":"Gerber-Grayson Electronics Corp","selected":"false","value":"Gerber-Grayson Electronics Corp"},{"label":"Gillmore-Mixon Construction Holdings","selected":"false","value":"Gillmore-Mixon Construction Holdings"},{"label":"Gimmi-Pugh Machinery Group","selected":"false","value":"Gimmi-Pugh Machinery Group"},{"label":"Givens-Beanston Transportation Holdings","selected":"false","value":"Givens-Beanston Transportation Holdings"},{"label":"Glancy-Cappa Communications Corp","selected":"false","value":"Glancy-Cappa Communications Corp"},{"label":"G & N Borden Communications Group","selected":"false","value":"G & N Borden Communications Group"},{"label":"G & N Cramer Communications Group","selected":"false","value":"G & N Cramer Communications Group"},{"label":"G & N Meyer Communications Group","selected":"false","value":"G & N Meyer Communications Group"},{"label":"G & N Sanders Communications Group","selected":"false","value":"G & N Sanders Communications Group"},{"label":"G & N Scarbrough Communications Group","selected":"false","value":"G & N Scarbrough Communications Group"},{"label":"G & N Tedford Communications Group","selected":"false","value":"G & N Tedford Communications Group"},{"label":"G & N Tribble Communications Group","selected":"false","value":"G & N Tribble Communications Group"},{"label":"G & N Wheeler Communications Group","selected":"false","value":"G & N Wheeler Communications Group"},{"label":"Goldey-Nickell Engineering Corp","selected":"false","value":"Goldey-Nickell Engineering Corp"},{"label":"Gonzales-Allen Engineering, Ltd","selected":"false","value":"Gonzales-Allen Engineering, Ltd"},{"label":"Gonzales-Valdez Construction Partners","selected":"false","value":"Gonzales-Valdez Construction Partners"},{"label":"G & Q Castano Engineering Corp","selected":"false","value":"G & Q Castano Engineering Corp"},{"label":"Graham.-Shaddy Telecommunications, Ltd","selected":"false","value":"Graham.-Shaddy Telecommunications, Ltd"},{"label":"Green-Stanford Communications Associates","selected":"false","value":"Green-Stanford Communications Associates"},{"label":"Greer-Benson Construction Company","selected":"false","value":"Greer-Benson Construction Company"},{"label":"Groome-Hill Engineering, Inc","selected":"false","value":"Groome-Hill Engineering, Inc"},{"label":"Grosvenor-Smrha Machinery Group","selected":"false","value":"Grosvenor-Smrha Machinery Group"},{"label":"G & T Beatty Engineering, Ltd","selected":"false","value":"G & T Beatty Engineering, Ltd"},{"label":"G & W Jones Transportation, Inc","selected":"false","value":"G & W Jones Transportation, Inc"},{"label":"G & W Kung Transportation, Inc","selected":"false","value":"G & W Kung Transportation, Inc"},{"label":"G & W Theriault Transportation, Inc","selected":"false","value":"G & W Theriault Transportation, Inc"},{"label":"G & W Vigil Transportation, Inc","selected":"false","value":"G & W Vigil Transportation, Inc"},{"label":"G & W Zgeirmann Transportation, Inc","selected":"false","value":"G & W Zgeirmann Transportation, Inc"},{"label":"Haddix-Thomas Construction Associates","selected":"false","value":"Haddix-Thomas Construction Associates"},{"label":"Hall-Narberes Engineering, Inc","selected":"false","value":"Hall-Narberes Engineering, Inc"},{"label":"Handley-Meyerhoff Machinery Associates","selected":"false","value":"Handley-Meyerhoff Machinery Associates"},{"label":"Hapke-Huff Engineering Associates","selected":"false","value":"Hapke-Huff Engineering Associates"},{"label":"Hass-Netz Construction Group","selected":"false","value":"Hass-Netz Construction Group"},{"label":"Hazlip-Carter Electronics Corp","selected":"false","value":"Hazlip-Carter Electronics Corp"},{"label":"H & E Abbott Machinery Group","selected":"false","value":"H & E Abbott Machinery Group"},{"label":"H & E Amland Machinery Group","selected":"false","value":"H & E Amland Machinery Group"},{"label":"Heaney-Karavites Electronics Company","selected":"false","value":"Heaney-Karavites Electronics Company"},{"label":"H & E Baker Machinery Group","selected":"false","value":"H & E Baker Machinery Group"},{"label":"H & E Knobel Machinery Group","selected":"false","value":"H & E Knobel Machinery Group"},{"label":"H & E Malik Machinery Group","selected":"false","value":"H & E Malik Machinery Group"},{"label":"H & E Pederson Machinery Group","selected":"false","value":"H & E Pederson Machinery Group"},{"label":"H & E Poorbaugh Machinery Group","selected":"false","value":"H & E Poorbaugh Machinery Group"},{"label":"H & E Stewart Machinery Group","selected":"false","value":"H & E Stewart Machinery Group"},{"label":"H & G Gerber Machinery Corp","selected":"false","value":"H & G Gerber Machinery Corp"},{"label":"H & G Van Antwerp Machinery Corp","selected":"false","value":"H & G Van Antwerp Machinery Corp"},{"label":"Highfill-Waggoner Machinery Group","selected":"false","value":"Highfill-Waggoner Machinery Group"},{"label":"Hill-Butcher Engineering Partners","selected":"false","value":"Hill-Butcher Engineering Partners"},{"label":"H & N Bayol Machinery Corp","selected":"false","value":"H & N Bayol Machinery Corp"},{"label":"H & N Handley Machinery Corp","selected":"false","value":"H & N Handley Machinery Corp"},{"label":"H & N Huckaby Machinery Corp","selected":"false","value":"H & N Huckaby Machinery Corp"},{"label":"H & N Price Machinery Corp","selected":"false","value":"H & N Price Machinery Corp"},{"label":"H & N Sanchez Machinery Corp","selected":"false","value":"H & N Sanchez Machinery Corp"},{"label":"H & N Stanley Machinery Corp","selected":"false","value":"H & N Stanley Machinery Corp"},{"label":"Holloway-Trau Transportation Holdings","selected":"false","value":"Holloway-Trau Transportation Holdings"},{"label":"Holmes-Chandler Engineering Associates","selected":"false","value":"Holmes-Chandler Engineering Associates"},{"label":"Homax-Adams Transportation Group","selected":"false","value":"Homax-Adams Transportation Group"},{"label":"Hopkins-Vicknair Machinery, Ltd","selected":"false","value":"Hopkins-Vicknair Machinery, Ltd"},{"label":"Howard-Elliott Telecommunications, Inc","selected":"false","value":"Howard-Elliott Telecommunications, Inc"},{"label":"Huckaby-Gustafson Machinery Associates","selected":"false","value":"Huckaby-Gustafson Machinery Associates"},{"label":"Hurkett-Pettengill Electronics Corp","selected":"false","value":"Hurkett-Pettengill Electronics Corp"},{"label":"H & Y Ansaldo Engineering, Inc","selected":"false","value":"H & Y Ansaldo Engineering, Inc"},{"label":"H & Y Azari Engineering, Inc","selected":"false","value":"H & Y Azari Engineering, Inc"},{"label":"H & Y Belleci Electronics, Ltd","selected":"false","value":"H & Y Belleci Electronics, Ltd"},{"label":"H & Y Belli Engineering, Inc","selected":"false","value":"H & Y Belli Engineering, Inc"},{"label":"H & Y Bernard Engineering, Inc","selected":"false","value":"H & Y Bernard Engineering, Inc"},{"label":"H & Y Brunner Engineering, Inc","selected":"false","value":"H & Y Brunner Engineering, Inc"},{"label":"H & Y Campbell Electronics, Ltd","selected":"false","value":"H & Y Campbell Electronics, Ltd"},{"label":"H & Y Elson Engineering, Inc","selected":"false","value":"H & Y Elson Engineering, Inc"},{"label":"H & Y Evans Engineering, Inc","selected":"false","value":"H & Y Evans Engineering, Inc"},{"label":"H & Y Gambao Engineering, Inc","selected":"false","value":"H & Y Gambao Engineering, Inc"},{"label":"H & Y Givens Electronics, Ltd","selected":"false","value":"H & Y Givens Electronics, Ltd"},{"label":"H & Y McCormick Electronics, Ltd","selected":"false","value":"H & Y McCormick Electronics, Ltd"},{"label":"H & Y Story Engineering, Inc","selected":"false","value":"H & Y Story Engineering, Inc"},{"label":"H & Y Styles Electronics, Ltd","selected":"false","value":"H & Y Styles Electronics, Ltd"},{"label":"H & Y Trujillo Electronics, Ltd","selected":"false","value":"H & Y Trujillo Electronics, Ltd"},{"label":"I & G Sharp Machinery Group","selected":"false","value":"I & G Sharp Machinery Group"},{"label":"I & M Buensalido Transportation, Ltd","selected":"false","value":"I & M Buensalido Transportation, Ltd"},{"label":"I & M Haemon Transportation, Ltd","selected":"false","value":"I & M Haemon Transportation, Ltd"},{"label":"I & M Hurkett Transportation, Ltd","selected":"false","value":"I & M Hurkett Transportation, Ltd"},{"label":"I & M Mann Transportation, Ltd","selected":"false","value":"I & M Mann Transportation, Ltd"},{"label":"I & M Styles Transportation, Ltd","selected":"false","value":"I & M Styles Transportation, Ltd"},{"label":"I & M Thompson Transportation, Ltd","selected":"false","value":"I & M Thompson Transportation, Ltd"},{"label":"I & M Turner Transportation, Ltd","selected":"false","value":"I & M Turner Transportation, Ltd"},{"label":"I & M Underwood Transportation, Ltd","selected":"false","value":"I & M Underwood Transportation, Ltd"},{"label":"I & O King Electronics Holdings","selected":"false","value":"I & O King Electronics Holdings"},{"label":"I & O Ritchie Electronics Holdings","selected":"false","value":"I & O Ritchie Electronics Holdings"},{"label":"Irwin-Son Construction, Ltd","selected":"false","value":"Irwin-Son Construction, Ltd"},{"label":"Isaacs-Yonce Engineering Corp","selected":"false","value":"Isaacs-Yonce Engineering Corp"},{"label":"Ison-Trent Construction Group","selected":"false","value":"Ison-Trent Construction Group"},{"label":"I & U Obaugh Transportation Holdings","selected":"false","value":"I & U Obaugh Transportation Holdings"},{"label":"I & U Stand Transportation Holdings","selected":"false","value":"I & U Stand Transportation Holdings"},{"label":"I & V Anderson Engineering, Inc","selected":"false","value":"I & V Anderson Engineering, Inc"},{"label":"I & V Cole Engineering, Inc","selected":"false","value":"I & V Cole Engineering, Inc"},{"label":"I & V Mcdonald Engineering, Inc","selected":"false","value":"I & V Mcdonald Engineering, Inc"},{"label":"I & V Netz Engineering, Inc","selected":"false","value":"I & V Netz Engineering, Inc"},{"label":"I & V Russell Engineering, Inc","selected":"false","value":"I & V Russell Engineering, Inc"},{"label":"I & V Tramel Engineering, Inc","selected":"false","value":"I & V Tramel Engineering, Inc"},{"label":"Jantzer-Dittmar Machinery, Inc","selected":"false","value":"Jantzer-Dittmar Machinery, Inc"},{"label":"J & B Heiser Telecommunications Company","selected":"false","value":"J & B Heiser Telecommunications Company"},{"label":"J & C Anderson Telecommunications Associates","selected":"false","value":"J & C Anderson Telecommunications Associates"},{"label":"J & C McDonald Telecommunications Associates","selected":"false","value":"J & C McDonald Telecommunications Associates"},{"label":"J & K Bouton Communications Corp","selected":"false","value":"J & K Bouton Communications Corp"},{"label":"J & K Netz Communications Corp","selected":"false","value":"J & K Netz Communications Corp"},{"label":"J & K Ortiz Communications Corp","selected":"false","value":"J & K Ortiz Communications Corp"},{"label":"J & K Santry Communications Corp","selected":"false","value":"J & K Santry Communications Corp"},{"label":"J & K Slattengren Communications Corp","selected":"false","value":"J & K Slattengren Communications Corp"},{"label":"J & K Walker Communications Corp","selected":"false","value":"J & K Walker Communications Corp"},{"label":"Johnson-Vrins Machinery, Inc","selected":"false","value":"Johnson-Vrins Machinery, Inc"},{"label":"J & R Green Construction Group","selected":"false","value":"J & R Green Construction Group"},{"label":"J & R Shanklin Construction Group","selected":"false","value":"J & R Shanklin Construction Group"},{"label":"Justice-Conner Engineering, Ltd","selected":"false","value":"Justice-Conner Engineering, Ltd"},{"label":"Kamas-Barr Construction Group","selected":"false","value":"Kamas-Barr Construction Group"},{"label":"Kharman-Kirschner Telecommunications, Inc","selected":"false","value":"Kharman-Kirschner Telecommunications, Inc"},{"label":"K & I Ardell Machinery Corp","selected":"false","value":"K & I Ardell Machinery Corp"},{"label":"King-Smith Engineering Company","selected":"false","value":"King-Smith Engineering Company"},{"label":"Knobel-Hope Electronics Holdings","selected":"false","value":"Knobel-Hope Electronics Holdings"},{"label":"Koeber-Wagner Construction Partners","selected":"false","value":"Koeber-Wagner Construction Partners"},{"label":"Kotc-Coriell Communications Holdings","selected":"false","value":"Kotc-Coriell Communications Holdings"},{"label":"Kouba-Clark Machinery Corp","selected":"false","value":"Kouba-Clark Machinery Corp"},{"label":"Kozlowski-Looney Machinery, Inc","selected":"false","value":"Kozlowski-Looney Machinery, Inc"},{"label":"K & R Arakawa Communications Group","selected":"false","value":"K & R Arakawa Communications Group"},{"label":"K & R Bidelman Communications Group","selected":"false","value":"K & R Bidelman Communications Group"},{"label":"K & R Bobbitt Communications Group","selected":"false","value":"K & R Bobbitt Communications Group"},{"label":"K & R Brandon Communications Group","selected":"false","value":"K & R Brandon Communications Group"},{"label":"K & R Chin Communications Group","selected":"false","value":"K & R Chin Communications Group"},{"label":"K & R Choin Communications Group","selected":"false","value":"K & R Choin Communications Group"},{"label":"K & R Cox Communications Group","selected":"false","value":"K & R Cox Communications Group"},{"label":"K & R Haines Communications Group","selected":"false","value":"K & R Haines Communications Group"},{"label":"K & R Morreale Communications Group","selected":"false","value":"K & R Morreale Communications Group"},{"label":"Kroes-Shafer Transportation, Inc","selected":"false","value":"Kroes-Shafer Transportation, Inc"},{"label":"K & R Turner Communications Group","selected":"false","value":"K & R Turner Communications Group"},{"label":"Kwiatkowski-Vann Electronics Corp","selected":"false","value":"Kwiatkowski-Vann Electronics Corp"},{"label":"Larkin-Bitler Communications Holdings","selected":"false","value":"Larkin-Bitler Communications Holdings"},{"label":"LaTulippe-Lewis Engineering Group","selected":"false","value":"LaTulippe-Lewis Engineering Group"},{"label":"Laudenslager-Dominica Telecommunications Group","selected":"false","value":"Laudenslager-Dominica Telecommunications Group"},{"label":"L & D Marple Electronics Corp","selected":"false","value":"L & D Marple Electronics Corp"},{"label":"L & E Baird Communications Partners","selected":"false","value":"L & E Baird Communications Partners"},{"label":"L & E Blanton Communications Partners","selected":"false","value":"L & E Blanton Communications Partners"},{"label":"L & E Brooks Communications Partners","selected":"false","value":"L & E Brooks Communications Partners"},{"label":"L & E Brunner Communications Partners","selected":"false","value":"L & E Brunner Communications Partners"},{"label":"L & E McPhearson Communications Partners","selected":"false","value":"L & E McPhearson Communications Partners"},{"label":"L & E Peoples Communications Partners","selected":"false","value":"L & E Peoples Communications Partners"},{"label":"L & E Potter Communications Partners","selected":"false","value":"L & E Potter Communications Partners"},{"label":"Leri-Carr Engineering Corp","selected":"false","value":"Leri-Carr Engineering Corp"},{"label":"L & E Richardson Communications Partners","selected":"false","value":"L & E Richardson Communications Partners"},{"label":"Lesko-Worland Construction Associates","selected":"false","value":"Lesko-Worland Construction Associates"},{"label":"Lewin-Desalvo Engineering Company","selected":"false","value":"Lewin-Desalvo Engineering Company"},{"label":"L & N Murphy Electronics Company","selected":"false","value":"L & N Murphy Electronics Company"},{"label":"Long-Olenzek Construction Company","selected":"false","value":"Long-Olenzek Construction Company"},{"label":"Long-Solimena Engineering Company","selected":"false","value":"Long-Solimena Engineering Company"},{"label":"Lopez-Valdivia Engineering Company","selected":"false","value":"Lopez-Valdivia Engineering Company"},{"label":"L & O Wheeler Machinery Group","selected":"false","value":"L & O Wheeler Machinery Group"},{"label":"Lynn-Cavendish Transportation Holdings","selected":"false","value":"Lynn-Cavendish Transportation Holdings"},{"label":"Maccietto-Buskirk Construction Associates","selected":"false","value":"Maccietto-Buskirk Construction Associates"},{"label":"Magenheimer-Hofsetz Engineering, Ltd","selected":"false","value":"Magenheimer-Hofsetz Engineering, Ltd"},{"label":"Maggard-Bezic Electronics Associates","selected":"false","value":"Maggard-Bezic Electronics Associates"},{"label":"Malaby-Caldwell Machinery Associates","selected":"false","value":"Malaby-Caldwell Machinery Associates"},{"label":"Malik-Eldridge Electronics Holdings","selected":"false","value":"Malik-Eldridge Electronics Holdings"},{"label":"Mann-Prater Electronics Corp","selected":"false","value":"Mann-Prater Electronics Corp"},{"label":"Manzanares-Stotler Machinery, Ltd","selected":"false","value":"Manzanares-Stotler Machinery, Ltd"},{"label":"Marez-Wachterman Transportation Company","selected":"false","value":"Marez-Wachterman Transportation Company"},{"label":"Mauro-Stroh Machinery Associates","selected":"false","value":"Mauro-Stroh Machinery Associates"},{"label":"Mcanich-Browning Telecommunications, Inc","selected":"false","value":"Mcanich-Browning Telecommunications, Inc"},{"label":"McCarthy-Bacalzo Machinery Group","selected":"false","value":"McCarthy-Bacalzo Machinery Group"},{"label":"McCarty-Bent Communications Corp","selected":"false","value":"McCarty-Bent Communications Corp"},{"label":"Mc Clane-Maxham Construction Holdings","selected":"false","value":"Mc Clane-Maxham Construction Holdings"},{"label":"McCormick-Sparacino Transportation Holdings","selected":"false","value":"McCormick-Sparacino Transportation Holdings"},{"label":"Mccoy-Tuck Construction Associates","selected":"false","value":"Mccoy-Tuck Construction Associates"},{"label":"Mcdonald-Weldon Construction, Ltd","selected":"false","value":"Mcdonald-Weldon Construction, Ltd"},{"label":"McGrath-Wright Engineering, Ltd","selected":"false","value":"McGrath-Wright Engineering, Ltd"},{"label":"McGuin-Amper Engineering, Inc","selected":"false","value":"McGuin-Amper Engineering, Inc"},{"label":"McPhearson-Albright Construction Holdings","selected":"false","value":"McPhearson-Albright Construction Holdings"},{"label":"Miller-Stern Machinery Group","selected":"false","value":"Miller-Stern Machinery Group"},{"label":"Mills-Reed Electronics Associates","selected":"false","value":"Mills-Reed Electronics Associates"},{"label":"Minarick-Los Olmos Transportation Holdings","selected":"false","value":"Minarick-Los Olmos Transportation Holdings"},{"label":"Minniear-Robinson Communications Group","selected":"false","value":"Minniear-Robinson Communications Group"},{"label":"M & K Carreras Telecommunications, Ltd","selected":"false","value":"M & K Carreras Telecommunications, Ltd"},{"label":"M & K Herman Telecommunications, Ltd","selected":"false","value":"M & K Herman Telecommunications, Ltd"},{"label":"M & K Steffen Telecommunications, Ltd","selected":"false","value":"M & K Steffen Telecommunications, Ltd"},{"label":"M & K Willeford Telecommunications, Ltd","selected":"false","value":"M & K Willeford Telecommunications, Ltd"},{"label":"Moberly-Meyer Communications Holdings","selected":"false","value":"Moberly-Meyer Communications Holdings"},{"label":"Montera-Ciochon Machinery, Inc","selected":"false","value":"Montera-Ciochon Machinery, Inc"},{"label":"Moore-Chaw Communications Associates","selected":"false","value":"Moore-Chaw Communications Associates"},{"label":"Morreale-Rupert Engineering Associates","selected":"false","value":"Morreale-Rupert Engineering Associates"},{"label":"Morris-Price Electronics Holdings","selected":"false","value":"Morris-Price Electronics Holdings"},{"label":"Moya-Chesnut Engineering Corp","selected":"false","value":"Moya-Chesnut Engineering Corp"},{"label":"M & R Winternitz Electronics Holdings","selected":"false","value":"M & R Winternitz Electronics Holdings"},{"label":"Mullins-Maes Construction Partners","selected":"false","value":"Mullins-Maes Construction Partners"},{"label":"Murphy-Rinks Communications Holdings","selected":"false","value":"Murphy-Rinks Communications Holdings"},{"label":"Murphy-Sweet Telecommunications Corp","selected":"false","value":"Murphy-Sweet Telecommunications Corp"},{"label":"M & Y Brummer Communications, Ltd","selected":"false","value":"M & Y Brummer Communications, Ltd"},{"label":"M & Y Lepro Communications, Ltd","selected":"false","value":"M & Y Lepro Communications, Ltd"},{"label":"M & Y Moore Communications, Ltd","selected":"false","value":"M & Y Moore Communications, Ltd"},{"label":"Netz-Amyotte Construction, Ltd","selected":"false","value":"Netz-Amyotte Construction, Ltd"},{"label":"Netz-Green Construction, Ltd","selected":"false","value":"Netz-Green Construction, Ltd"},{"label":"N & O Baker Electronics, Inc","selected":"false","value":"N & O Baker Electronics, Inc"},{"label":"N & O Brady, Jr. Electronics, Inc","selected":"false","value":"N & O Brady, Jr. Electronics, Inc"},{"label":"N & O Faubert Electronics, Inc","selected":"false","value":"N & O Faubert Electronics, Inc"},{"label":"N & O Gimmi Electronics, Inc","selected":"false","value":"N & O Gimmi Electronics, Inc"},{"label":"N & O Grosvenor Electronics, Inc","selected":"false","value":"N & O Grosvenor Electronics, Inc"},{"label":"Noice-Lindall Machinery, Inc","selected":"false","value":"Noice-Lindall Machinery, Inc"},{"label":"N & O Petty Electronics, Inc","selected":"false","value":"N & O Petty Electronics, Inc"},{"label":"N & O Townsend Electronics, Inc","selected":"false","value":"N & O Townsend Electronics, Inc"},{"label":"N & O Wilson Electronics, Inc","selected":"false","value":"N & O Wilson Electronics, Inc"},{"label":"N & W Armstrong Transportation Corp","selected":"false","value":"N & W Armstrong Transportation Corp"},{"label":"N & W Beutel Transportation Corp","selected":"false","value":"N & W Beutel Transportation Corp"},{"label":"N & W Byrnes Transportation Corp","selected":"false","value":"N & W Byrnes Transportation Corp"},{"label":"N & W Chrisulis Transportation Corp","selected":"false","value":"N & W Chrisulis Transportation Corp"},{"label":"N & W Creek Transportation Corp","selected":"false","value":"N & W Creek Transportation Corp"},{"label":"N & W Hill Transportation Corp","selected":"false","value":"N & W Hill Transportation Corp"},{"label":"N & W Koski Transportation Corp","selected":"false","value":"N & W Koski Transportation Corp"},{"label":"N & W White Transportation Corp","selected":"false","value":"N & W White Transportation Corp"},{"label":"O & A Jasper Engineering Corp","selected":"false","value":"O & A Jasper Engineering Corp"},{"label":"O & A Stone Engineering Corp","selected":"false","value":"O & A Stone Engineering Corp"},{"label":"O & C Johnson Construction, Inc","selected":"false","value":"O & C Johnson Construction, Inc"},{"label":"O & C Younce Construction, Inc","selected":"false","value":"O & C Younce Construction, Inc"},{"label":"O & D Hunt Communications Associates","selected":"false","value":"O & D Hunt Communications Associates"},{"label":"O & D Jones Communications Associates","selected":"false","value":"O & D Jones Communications Associates"},{"label":"O & D Lee Communications Associates","selected":"false","value":"O & D Lee Communications Associates"},{"label":"O & D Rutledge Communications Associates","selected":"false","value":"O & D Rutledge Communications Associates"},{"label":"O & D Sloper Communications Associates","selected":"false","value":"O & D Sloper Communications Associates"},{"label":"O & D Tate Communications Associates","selected":"false","value":"O & D Tate Communications Associates"},{"label":"O & D Taurman Communications Associates","selected":"false","value":"O & D Taurman Communications Associates"},{"label":"O & D White Communications Associates","selected":"false","value":"O & D White Communications Associates"},{"label":"O & K Agcaoili Transportation Corp","selected":"false","value":"O & K Agcaoili Transportation Corp"},{"label":"O & K Carnes Transportation Corp","selected":"false","value":"O & K Carnes Transportation Corp"},{"label":"O & K Ealey Transportation Corp","selected":"false","value":"O & K Ealey Transportation Corp"},{"label":"O & K Koeber Transportation Corp","selected":"false","value":"O & K Koeber Transportation Corp"},{"label":"O & K Mullins Transportation Corp","selected":"false","value":"O & K Mullins Transportation Corp"},{"label":"O & K Pasumansky Transportation Corp","selected":"false","value":"O & K Pasumansky Transportation Corp"},{"label":"O & K Racette Transportation Corp","selected":"false","value":"O & K Racette Transportation Corp"},{"label":"O & K Smith Transportation Corp","selected":"false","value":"O & K Smith Transportation Corp"},{"label":"Olguin-Ayers Telecommunications, Inc","selected":"false","value":"Olguin-Ayers Telecommunications, Inc"},{"label":"Ortiz-Beaver Construction, Ltd","selected":"false","value":"Ortiz-Beaver Construction, Ltd"},{"label":"Ortiz-Michaels Transportation Corp","selected":"false","value":"Ortiz-Michaels Transportation Corp"},{"label":"Ortiz-Tearpak Engineering Company","selected":"false","value":"Ortiz-Tearpak Engineering Company"},{"label":"Osborn-Binai Construction Associates","selected":"false","value":"Osborn-Binai Construction Associates"},{"label":"Oss-Smith Construction Company","selected":"false","value":"Oss-Smith Construction Company"},{"label":"Owens-Castillo Engineering Associates","selected":"false","value":"Owens-Castillo Engineering Associates"},{"label":"Pasumansky-Whitney Construction Partners","selected":"false","value":"Pasumansky-Whitney Construction Partners"},{"label":"Pederson-Renn Electronics Holdings","selected":"false","value":"Pederson-Renn Electronics Holdings"},{"label":"Peoples-Choi Construction Holdings","selected":"false","value":"Peoples-Choi Construction Holdings"},{"label":"Pierson-Jones Engineering Corp","selected":"false","value":"Pierson-Jones Engineering Corp"},{"label":"Planck-Marshall Communications Associates","selected":"false","value":"Planck-Marshall Communications Associates"},{"label":"P & N Stallings Construction Company","selected":"false","value":"P & N Stallings Construction Company"},{"label":"Pompa-Traube Machinery Group","selected":"false","value":"Pompa-Traube Machinery Group"},{"label":"Ponce-Borrelli Machinery, Ltd","selected":"false","value":"Ponce-Borrelli Machinery, Ltd"},{"label":"Poorbaugh-Hasty Electronics Holdings","selected":"false","value":"Poorbaugh-Hasty Electronics Holdings"},{"label":"Posey-Dimon Engineering Company","selected":"false","value":"Posey-Dimon Engineering Company"},{"label":"Potter-Holmes Construction Partners","selected":"false","value":"Potter-Holmes Construction Partners"},{"label":"Potter-Smith Construction Holdings","selected":"false","value":"Potter-Smith Construction Holdings"},{"label":"Q & P Adina Telecommunications Company","selected":"false","value":"Q & P Adina Telecommunications Company"},{"label":"Q & P Banack Telecommunications Company","selected":"false","value":"Q & P Banack Telecommunications Company"},{"label":"Q & P Barber Telecommunications Company","selected":"false","value":"Q & P Barber Telecommunications Company"},{"label":"Q & P Carreras Telecommunications Company","selected":"false","value":"Q & P Carreras Telecommunications Company"},{"label":"Q & Q Drury Telecommunications Associates","selected":"false","value":"Q & Q Drury Telecommunications Associates"},{"label":"Q & Q Gerber Telecommunications Associates","selected":"false","value":"Q & Q Gerber Telecommunications Associates"},{"label":"Q & Q Henry Telecommunications Associates","selected":"false","value":"Q & Q Henry Telecommunications Associates"},{"label":"Q & Q Ortiz Telecommunications Associates","selected":"false","value":"Q & Q Ortiz Telecommunications Associates"},{"label":"Q & Q Sanchez Telecommunications Associates","selected":"false","value":"Q & Q Sanchez Telecommunications Associates"},{"label":"Q & Q Zobairi Telecommunications Associates","selected":"false","value":"Q & Q Zobairi Telecommunications Associates"},{"label":"Quintana-Bright Transportation Holdings","selected":"false","value":"Quintana-Bright Transportation Holdings"},{"label":"Reynolds-Ibsen Communications Holdings","selected":"false","value":"Reynolds-Ibsen Communications Holdings"},{"label":"Reynolds-Posner Construction, Ltd","selected":"false","value":"Reynolds-Posner Construction, Ltd"},{"label":"Rhiger-Finley Communications Corp","selected":"false","value":"Rhiger-Finley Communications Corp"},{"label":"Rhodes-Kaffer Machinery Group","selected":"false","value":"Rhodes-Kaffer Machinery Group"},{"label":"Rizzi-Sotelo Transportation, Inc","selected":"false","value":"Rizzi-Sotelo Transportation, Inc"},{"label":"Rodgers-Gates Communications Corp","selected":"false","value":"Rodgers-Gates Communications Corp"},{"label":"Romero-Hicks Construction, Ltd","selected":"false","value":"Romero-Hicks Construction, Ltd"},{"label":"Rowland-Balleo Machinery, Inc","selected":"false","value":"Rowland-Balleo Machinery, Inc"},{"label":"R & Y Sowards Machinery Associates","selected":"false","value":"R & Y Sowards Machinery Associates"},{"label":"R & Z Azzolino Communications, Inc","selected":"false","value":"R & Z Azzolino Communications, Inc"},{"label":"R & Z Boje Communications, Inc","selected":"false","value":"R & Z Boje Communications, Inc"},{"label":"R & Z Ceballos Communications, Inc","selected":"false","value":"R & Z Ceballos Communications, Inc"},{"label":"R & Z Ecoffey Communications, Inc","selected":"false","value":"R & Z Ecoffey Communications, Inc"},{"label":"R & Z Garza Communications, Inc","selected":"false","value":"R & Z Garza Communications, Inc"},{"label":"R & Z Gilliat Communications, Inc","selected":"false","value":"R & Z Gilliat Communications, Inc"},{"label":"R & Z Larson Communications, Inc","selected":"false","value":"R & Z Larson Communications, Inc"},{"label":"R & Z Zugelder Communications, Inc","selected":"false","value":"R & Z Zugelder Communications, Inc"},{"label":"Salazar-Reardon Telecommunications, Ltd","selected":"false","value":"Salazar-Reardon Telecommunications, Ltd"},{"label":"Sall-Scott Telecommunications, Ltd","selected":"false","value":"Sall-Scott Telecommunications, Ltd"},{"label":"Sandidge-Skonnard Machinery Group","selected":"false","value":"Sandidge-Skonnard Machinery Group"},{"label":"Scarbrough-Martensen Construction Partners","selected":"false","value":"Scarbrough-Martensen Construction Partners"},{"label":"Schimanski-Alumbaugh Telecommunications, Ltd","selected":"false","value":"Schimanski-Alumbaugh Telecommunications, Ltd"},{"label":"Schuetz-Runyon Machinery, Ltd","selected":"false","value":"Schuetz-Runyon Machinery, Ltd"},{"label":"Shanklin-Lewis Communications Associates","selected":"false","value":"Shanklin-Lewis Communications Associates"},{"label":"Sherfy-Behnke Engineering, Inc","selected":"false","value":"Sherfy-Behnke Engineering, Inc"},{"label":"Shintani-Chavez Engineering, Ltd","selected":"false","value":"Shintani-Chavez Engineering, Ltd"},{"label":"Short-Mc Guigan Engineering, Inc","selected":"false","value":"Short-Mc Guigan Engineering, Inc"},{"label":"Short-Swesey Engineering Corp","selected":"false","value":"Short-Swesey Engineering Corp"},{"label":"Sincich-Jameson Engineering Corp","selected":"false","value":"Sincich-Jameson Engineering Corp"},{"label":"Skuce-Coleman Transportation Group","selected":"false","value":"Skuce-Coleman Transportation Group"},{"label":"Sloan-Villa Electronics Company","selected":"false","value":"Sloan-Villa Electronics Company"},{"label":"Sloper-Weinzimmer Transportation Company","selected":"false","value":"Sloper-Weinzimmer Transportation Company"},{"label":"Smith-Duff Construction Partners","selected":"false","value":"Smith-Duff Construction Partners"},{"label":"Smith-Gentile Telecommunications, Ltd","selected":"false","value":"Smith-Gentile Telecommunications, Ltd"},{"label":"Smith-Potter Engineering Corp","selected":"false","value":"Smith-Potter Engineering Corp"},{"label":"Smith-Serventi Transportation, Inc","selected":"false","value":"Smith-Serventi Transportation, Inc"},{"label":"Smith-Vuong Construction Partners","selected":"false","value":"Smith-Vuong Construction Partners"},{"label":"Smith-Yasi Telecommunications, Inc","selected":"false","value":"Smith-Yasi Telecommunications, Inc"},{"label":"Solano-Armstrong Machinery Group","selected":"false","value":"Solano-Armstrong Machinery Group"},{"label":"Sowards-James Telecommunications Partners","selected":"false","value":"Sowards-James Telecommunications Partners"},{"label":"Spicer-Medina Electronics Holdings","selected":"false","value":"Spicer-Medina Electronics Holdings"},{"label":"Staley-Lipford Engineering, Ltd","selected":"false","value":"Staley-Lipford Engineering, Ltd"},{"label":"Stalker-Fan Telecommunications Group","selected":"false","value":"Stalker-Fan Telecommunications Group"},{"label":"Stallings-Yoshimura Engineering Group","selected":"false","value":"Stallings-Yoshimura Engineering Group"},{"label":"Stand-Backlin Electronics, Inc","selected":"false","value":"Stand-Backlin Electronics, Inc"},{"label":"Steele-Thompson Transportation Group","selected":"false","value":"Steele-Thompson Transportation Group"},{"label":"Steelman-Adams Construction Partners","selected":"false","value":"Steelman-Adams Construction Partners"},{"label":"Steffen-Flynn Machinery, Ltd","selected":"false","value":"Steffen-Flynn Machinery, Ltd"},{"label":"Steinberg-Megel Telecommunications, Ltd","selected":"false","value":"Steinberg-Megel Telecommunications, Ltd"},{"label":"Story-Boone Telecommunications, Ltd","selected":"false","value":"Story-Boone Telecommunications, Ltd"},{"label":"Stotka-Johnson Transportation Company","selected":"false","value":"Stotka-Johnson Transportation Company"},{"label":"Strange-Richter Construction Partners","selected":"false","value":"Strange-Richter Construction Partners"},{"label":"Styles-Glenn Transportation Holdings","selected":"false","value":"Styles-Glenn Transportation Holdings"},{"label":"Styles-Head Electronics Corp","selected":"false","value":"Styles-Head Electronics Corp"},{"label":"Sullivan-Watada Transportation Holdings","selected":"false","value":"Sullivan-Watada Transportation Holdings"},{"label":"Sultan-Svoboda Machinery, Inc","selected":"false","value":"Sultan-Svoboda Machinery, Inc"},{"label":"S & X Allen Engineering Partners","selected":"false","value":"S & X Allen Engineering Partners"},{"label":"S & X Blauvelt Engineering Partners","selected":"false","value":"S & X Blauvelt Engineering Partners"},{"label":"S & X Browning Engineering Partners","selected":"false","value":"S & X Browning Engineering Partners"},{"label":"S & X Ciochon Engineering Partners","selected":"false","value":"S & X Ciochon Engineering Partners"},{"label":"S & X Dennis Engineering Partners","selected":"false","value":"S & X Dennis Engineering Partners"},{"label":"S & X Derby Engineering Partners","selected":"false","value":"S & X Derby Engineering Partners"},{"label":"S & X Minker Engineering Partners","selected":"false","value":"S & X Minker Engineering Partners"},{"label":"S & X Rizzi Engineering Partners","selected":"false","value":"S & X Rizzi Engineering Partners"},{"label":"S & X Smith Engineering Partners","selected":"false","value":"S & X Smith Engineering Partners"},{"label":"S & X Warthen Engineering Partners","selected":"false","value":"S & X Warthen Engineering Partners"},{"label":"S & Y Foster Construction, Ltd","selected":"false","value":"S & Y Foster Construction, Ltd"},{"label":"S & Y Miller Construction, Ltd","selected":"false","value":"S & Y Miller Construction, Ltd"},{"label":"S & Y Williamson Electronics Holdings","selected":"false","value":"S & Y Williamson Electronics Holdings"},{"label":"T & A Bustamante Electronics, Inc","selected":"false","value":"T & A Bustamante Electronics, Inc"},{"label":"T & A Chambers Electronics, Inc","selected":"false","value":"T & A Chambers Electronics, Inc"},{"label":"T & A Crow Electronics, Inc","selected":"false","value":"T & A Crow Electronics, Inc"},{"label":"T & A Haddix Electronics, Inc","selected":"false","value":"T & A Haddix Electronics, Inc"},{"label":"Takemura-Campbell Communications Associates","selected":"false","value":"Takemura-Campbell Communications Associates"},{"label":"T & A McCown Electronics, Inc","selected":"false","value":"T & A McCown Electronics, Inc"},{"label":"Tancredy-Wilson Construction Associates","selected":"false","value":"Tancredy-Wilson Construction Associates"},{"label":"T & A Netz Electronics, Inc","selected":"false","value":"T & A Netz Electronics, Inc"},{"label":"T & A Osborn Electronics, Inc","selected":"false","value":"T & A Osborn Electronics, Inc"},{"label":"Taryle-Spencer Transportation Holdings","selected":"false","value":"Taryle-Spencer Transportation Holdings"},{"label":"Tate-Watson Electronics Company","selected":"false","value":"Tate-Watson Electronics Company"},{"label":"T & A Watkins Electronics, Inc","selected":"false","value":"T & A Watkins Electronics, Inc"},{"label":"Taylor-Robinson Transportation Holdings","selected":"false","value":"Taylor-Robinson Transportation Holdings"},{"label":"Tedford-Roy Construction Partners","selected":"false","value":"Tedford-Roy Construction Partners"},{"label":"Tench-Brink Machinery, Inc","selected":"false","value":"Tench-Brink Machinery, Inc"},{"label":"Thames-Rusek Machinery Group","selected":"false","value":"Thames-Rusek Machinery Group"},{"label":"Theisen-Berger Construction Group","selected":"false","value":"Theisen-Berger Construction Group"},{"label":"Thompson-Hendricks Machinery Corp","selected":"false","value":"Thompson-Hendricks Machinery Corp"},{"label":"Thompson-Stevens Construction Partners","selected":"false","value":"Thompson-Stevens Construction Partners"},{"label":"Thompson-Sturgel Electronics Corp","selected":"false","value":"Thompson-Sturgel Electronics Corp"},{"label":"Thomsen-Baldwin Construction Partners","selected":"false","value":"Thomsen-Baldwin Construction Partners"},{"label":"Thoreson-Snowden Machinery, Ltd","selected":"false","value":"Thoreson-Snowden Machinery, Ltd"},{"label":"Thorton-Dumin Construction, Ltd","selected":"false","value":"Thorton-Dumin Construction, Ltd"},{"label":"Todd-Batouche Machinery Group","selected":"false","value":"Todd-Batouche Machinery Group"},{"label":"Tomlinson-Springate Machinery, Ltd","selected":"false","value":"Tomlinson-Springate Machinery, Ltd"},{"label":"Tommerup-Martinez Transportation Holdings","selected":"false","value":"Tommerup-Martinez Transportation Holdings"},{"label":"Touchstone-Bakhtyari Engineering, Ltd","selected":"false","value":"Touchstone-Bakhtyari Engineering, Ltd"},{"label":"Townsend-Rockne Machinery Group","selected":"false","value":"Townsend-Rockne Machinery Group"},{"label":"T & P Chenault Engineering, Inc","selected":"false","value":"T & P Chenault Engineering, Inc"},{"label":"T & P Zablah Engineering, Inc","selected":"false","value":"T & P Zablah Engineering, Inc"},{"label":"Trach-White Machinery Corp","selected":"false","value":"Trach-White Machinery Corp"},{"label":"Tramel-Curry Construction, Ltd","selected":"false","value":"Tramel-Curry Construction, Ltd"},{"label":"Tribble-Skapinok Construction Partners","selected":"false","value":"Tribble-Skapinok Construction Partners"},{"label":"Trolen-Vernon Construction Holdings","selected":"false","value":"Trolen-Vernon Construction Holdings"},{"label":"Tucker-Forham Construction Partners","selected":"false","value":"Tucker-Forham Construction Partners"},{"label":"Tu-Harris Transportation Holdings","selected":"false","value":"Tu-Harris Transportation Holdings"},{"label":"Turcios-Confetti Transportation Company","selected":"false","value":"Turcios-Confetti Transportation Company"},{"label":"Turner-Griffin Engineering Associates","selected":"false","value":"Turner-Griffin Engineering Associates"},{"label":"Turner-Zakerski Transportation Group","selected":"false","value":"Turner-Zakerski Transportation Group"},{"label":"U & D Johnston Communications, Ltd","selected":"false","value":"U & D Johnston Communications, Ltd"},{"label":"Underwood-Strain Electronics Corp","selected":"false","value":"Underwood-Strain Electronics Corp"},{"label":"U & S Baker Transportation, Inc","selected":"false","value":"U & S Baker Transportation, Inc"},{"label":"U & S Bowman Transportation, Inc","selected":"false","value":"U & S Bowman Transportation, Inc"},{"label":"U & S Burke Transportation, Inc","selected":"false","value":"U & S Burke Transportation, Inc"},{"label":"U & S Chestnut Transportation, Inc","selected":"false","value":"U & S Chestnut Transportation, Inc"},{"label":"U & S Gabbard Transportation, Inc","selected":"false","value":"U & S Gabbard Transportation, Inc"},{"label":"U & S Gallagher Transportation, Inc","selected":"false","value":"U & S Gallagher Transportation, Inc"},{"label":"U & S Ison Transportation, Inc","selected":"false","value":"U & S Ison Transportation, Inc"},{"label":"U & S Scheulen Transportation, Inc","selected":"false","value":"U & S Scheulen Transportation, Inc"},{"label":"U & S Theisen Transportation, Inc","selected":"false","value":"U & S Theisen Transportation, Inc"},{"label":"U & W Beck Construction Corp","selected":"false","value":"U & W Beck Construction Corp"},{"label":"U & W Bennetts Construction Corp","selected":"false","value":"U & W Bennetts Construction Corp"},{"label":"U & W Burchett Construction Corp","selected":"false","value":"U & W Burchett Construction Corp"},{"label":"U & W Fielder Construction Corp","selected":"false","value":"U & W Fielder Construction Corp"},{"label":"U & W Herrick Construction Corp","selected":"false","value":"U & W Herrick Construction Corp"},{"label":"U & W Tate Construction Corp","selected":"false","value":"U & W Tate Construction Corp"},{"label":"U & W Wall Construction Corp","selected":"false","value":"U & W Wall Construction Corp"},{"label":"U & W Wright Construction Corp","selected":"false","value":"U & W Wright Construction Corp"},{"label":"V & A Ace Transportation Corp","selected":"false","value":"V & A Ace Transportation Corp"},{"label":"V & A Baltazar Transportation Corp","selected":"false","value":"V & A Baltazar Transportation Corp"},{"label":"Vaca-Arbelaez Engineering Partners","selected":"false","value":"Vaca-Arbelaez Engineering Partners"},{"label":"V & A J Wilbert Transportation Corp","selected":"false","value":"V & A J Wilbert Transportation Corp"},{"label":"Valentine-Reams Machinery Corp","selected":"false","value":"Valentine-Reams Machinery Corp"},{"label":"Van Antwerp-Springer Electronics Corp","selected":"false","value":"Van Antwerp-Springer Electronics Corp"},{"label":"Vanderlinden-Virden Machinery, Inc","selected":"false","value":"Vanderlinden-Virden Machinery, Inc"},{"label":"V & A Rhiger Transportation Corp","selected":"false","value":"V & A Rhiger Transportation Corp"},{"label":"V & B Black Transportation Holdings","selected":"false","value":"V & B Black Transportation Holdings"},{"label":"V & B Brian Transportation Holdings","selected":"false","value":"V & B Brian Transportation Holdings"},{"label":"V & B Kwiatkowski Machinery, Ltd","selected":"false","value":"V & B Kwiatkowski Machinery, Ltd"},{"label":"V & B Munn Transportation Holdings","selected":"false","value":"V & B Munn Transportation Holdings"},{"label":"V & B Tuffield Transportation Holdings","selected":"false","value":"V & B Tuffield Transportation Holdings"},{"label":"V & B Worsham Transportation Holdings","selected":"false","value":"V & B Worsham Transportation Holdings"},{"label":"Vessa-Tran Communications Corp","selected":"false","value":"Vessa-Tran Communications Corp"},{"label":"Viellieux-Baugh Transportation Holdings","selected":"false","value":"Viellieux-Baugh Transportation Holdings"},{"label":"Vigil-Gash Machinery Corp","selected":"false","value":"Vigil-Gash Machinery Corp"},{"label":"Vij-Zugschwert Engineering, Inc","selected":"false","value":"Vij-Zugschwert Engineering, Inc"},{"label":"Vincenzi-Herring Engineering, Ltd","selected":"false","value":"Vincenzi-Herring Engineering, Ltd"},{"label":"Visser-Sanchez Construction Partners","selected":"false","value":"Visser-Sanchez Construction Partners"},{"label":"Vlass-Gonzalez Construction, Ltd","selected":"false","value":"Vlass-Gonzalez Construction, Ltd"},{"label":"Vonholt-Holmes Engineering Corp","selected":"false","value":"Vonholt-Holmes Engineering Corp"},{"label":"V & P Carlson Transportation Corp","selected":"false","value":"V & P Carlson Transportation Corp"},{"label":"V & P Gonzales Transportation Corp","selected":"false","value":"V & P Gonzales Transportation Corp"},{"label":"V & P Howard Transportation Corp","selected":"false","value":"V & P Howard Transportation Corp"},{"label":"V & P Kharman Transportation Corp","selected":"false","value":"V & P Kharman Transportation Corp"},{"label":"V & P Mcanich Transportation Corp","selected":"false","value":"V & P Mcanich Transportation Corp"},{"label":"V & P Olguin Transportation Corp","selected":"false","value":"V & P Olguin Transportation Corp"},{"label":"V & P Smallwood Transportation Corp","selected":"false","value":"V & P Smallwood Transportation Corp"},{"label":"V & P Smith Transportation Corp","selected":"false","value":"V & P Smith Transportation Corp"},{"label":"V & P Zubaty Transportation Corp","selected":"false","value":"V & P Zubaty Transportation Corp"},{"label":"Walker-Jones Construction, Ltd","selected":"false","value":"Walker-Jones Construction, Ltd"},{"label":"Wall-Appelbaum Machinery Associates","selected":"false","value":"Wall-Appelbaum Machinery Associates"},{"label":"Wall-Clendenen Electronics Company","selected":"false","value":"Wall-Clendenen Electronics Company"},{"label":"Waller-Barney Communications, Inc","selected":"false","value":"Waller-Barney Communications, Inc"},{"label":"Walton-Meastas Machinery Associates","selected":"false","value":"Walton-Meastas Machinery Associates"},{"label":"W & A Pierson Construction Company","selected":"false","value":"W & A Pierson Construction Company"},{"label":"Warthen-Johnson Transportation, Inc","selected":"false","value":"Warthen-Johnson Transportation, Inc"},{"label":"Waters-Jarvis Construction Partners","selected":"false","value":"Waters-Jarvis Construction Partners"},{"label":"Watson-Waddle Machinery Group","selected":"false","value":"Watson-Waddle Machinery Group"},{"label":"Weber-Kabbes Transportation Holdings","selected":"false","value":"Weber-Kabbes Transportation Holdings"},{"label":"Weller-Bloomberg Machinery, Inc","selected":"false","value":"Weller-Bloomberg Machinery, Inc"},{"label":"Wellington-Bacugalupi Communications Holdings","selected":"false","value":"Wellington-Bacugalupi Communications Holdings"},{"label":"Welsh-McCollum Transportation Holdings","selected":"false","value":"Welsh-McCollum Transportation Holdings"},{"label":"Weyerhaeuser-Robinson Electronics Corp","selected":"false","value":"Weyerhaeuser-Robinson Electronics Corp"},{"label":"Wheeler-Irvin Machinery Corp","selected":"false","value":"Wheeler-Irvin Machinery Corp"},{"label":"Wheeler-Swearengin Construction Partners","selected":"false","value":"Wheeler-Swearengin Construction Partners"},{"label":"Whitehead-Roy Machinery Group","selected":"false","value":"Whitehead-Roy Machinery Group"},{"label":"White-Simpson Engineering Partners","selected":"false","value":"White-Simpson Engineering Partners"},{"label":"Whitney-Mitchell Electronics, Ltd","selected":"false","value":"Whitney-Mitchell Electronics, Ltd"},{"label":"Wilkie-Lunt Machinery Partners","selected":"false","value":"Wilkie-Lunt Machinery Partners"},{"label":"Williams-Burke Communications Corp","selected":"false","value":"Williams-Burke Communications Corp"},{"label":"Williams-Masters Transportation Holdings","selected":"false","value":"Williams-Masters Transportation Holdings"},{"label":"Williamson-Goodwater Construction, Ltd","selected":"false","value":"Williamson-Goodwater Construction, Ltd"},{"label":"Wilson-Morrow Machinery Group","selected":"false","value":"Wilson-Morrow Machinery Group"},{"label":"Wilson-Stovall Machinery, Inc","selected":"false","value":"Wilson-Stovall Machinery, Inc"},{"label":"Winfrey-Brown Machinery Group","selected":"false","value":"Winfrey-Brown Machinery Group"},{"label":"Winter-Adams Construction Associates","selected":"false","value":"Winter-Adams Construction Associates"},{"label":"W & N Alcorn Telecommunications Partners","selected":"false","value":"W & N Alcorn Telecommunications Partners"},{"label":"W & N Cabrera Telecommunications Partners","selected":"false","value":"W & N Cabrera Telecommunications Partners"},{"label":"W & N Cook Telecommunications Partners","selected":"false","value":"W & N Cook Telecommunications Partners"},{"label":"W & N Lynn Telecommunications Partners","selected":"false","value":"W & N Lynn Telecommunications Partners"},{"label":"W & N Quintana Telecommunications Partners","selected":"false","value":"W & N Quintana Telecommunications Partners"},{"label":"W & N Several Telecommunications Partners","selected":"false","value":"W & N Several Telecommunications Partners"},{"label":"W & N Sims Telecommunications Partners","selected":"false","value":"W & N Sims Telecommunications Partners"},{"label":"W & N Sullivan Telecommunications Partners","selected":"false","value":"W & N Sullivan Telecommunications Partners"},{"label":"W & N Tommerup Telecommunications Partners","selected":"false","value":"W & N Tommerup Telecommunications Partners"},{"label":"Wold-French Construction Partners","selected":"false","value":"Wold-French Construction Partners"},{"label":"Wolf-Whitworth Construction, Ltd","selected":"false","value":"Wolf-Whitworth Construction, Ltd"},{"label":"Wollesen-Lee Transportation Holdings","selected":"false","value":"Wollesen-Lee Transportation Holdings"},{"label":"Wolter-Collins Construction Partners","selected":"false","value":"Wolter-Collins Construction Partners"},{"label":"Wood-Morgan Engineering, Ltd","selected":"false","value":"Wood-Morgan Engineering, Ltd"},{"label":"W & W Highfill Electronics Associates","selected":"false","value":"W & W Highfill Electronics Associates"},{"label":"W & W Miller Electronics Associates","selected":"false","value":"W & W Miller Electronics Associates"},{"label":"W & W Watson Electronics Associates","selected":"false","value":"W & W Watson Electronics Associates"},{"label":"W & W Whitehead Electronics Associates","selected":"false","value":"W & W Whitehead Electronics Associates"},{"label":"W & W Winfrey Electronics Associates","selected":"false","value":"W & W Winfrey Electronics Associates"},{"label":"W & Y Rowland Construction, Ltd","selected":"false","value":"W & Y Rowland Construction, Ltd"},{"label":"X & C McCain Transportation, Ltd","selected":"false","value":"X & C McCain Transportation, Ltd"},{"label":"X & C Owens Transportation, Ltd","selected":"false","value":"X & C Owens Transportation, Ltd"},{"label":"X & M Betsekas Construction Corp","selected":"false","value":"X & M Betsekas Construction Corp"},{"label":"X & M Borges Construction Corp","selected":"false","value":"X & M Borges Construction Corp"},{"label":"X & M Catalano Construction Corp","selected":"false","value":"X & M Catalano Construction Corp"},{"label":"X & M Fisher Construction Corp","selected":"false","value":"X & M Fisher Construction Corp"},{"label":"X & M Lundahl Construction Corp","selected":"false","value":"X & M Lundahl Construction Corp"},{"label":"X & M Witte Construction Corp","selected":"false","value":"X & M Witte Construction Corp"},{"label":"X & M Young Construction Corp","selected":"false","value":"X & M Young Construction Corp"},{"label":"X & N Eichorn Construction Corp","selected":"false","value":"X & N Eichorn Construction Corp"},{"label":"X & N Williams Construction Corp","selected":"false","value":"X & N Williams Construction Corp"},{"label":"X & V Purcell Communications Partners","selected":"false","value":"X & V Purcell Communications Partners"},{"label":"X & V Slusher Construction, Ltd","selected":"false","value":"X & V Slusher Construction, Ltd"},{"label":"X & V Smith Construction, Ltd","selected":"false","value":"X & V Smith Construction, Ltd"},{"label":"X & V Thorne Communications Partners","selected":"false","value":"X & V Thorne Communications Partners"},{"label":"X & W Usnick Machinery Group","selected":"false","value":"X & W Usnick Machinery Group"},{"label":"Y & B Bomar Communications Partners","selected":"false","value":"Y & B Bomar Communications Partners"},{"label":"Y & B Simmons Communications Partners","selected":"false","value":"Y & B Simmons Communications Partners"},{"label":"Young-Krupka Telecommunications, Ltd","selected":"false","value":"Young-Krupka Telecommunications, Ltd"},{"label":"Y & R Alpuerto Machinery, Inc","selected":"false","value":"Y & R Alpuerto Machinery, Inc"},{"label":"Y & R Altamirano Machinery, Inc","selected":"false","value":"Y & R Altamirano Machinery, Inc"},{"label":"Y & R Campbell Machinery, Inc","selected":"false","value":"Y & R Campbell Machinery, Inc"},{"label":"Y & R Cardoza Machinery, Inc","selected":"false","value":"Y & R Cardoza Machinery, Inc"},{"label":"Y & R Hall Machinery, Inc","selected":"false","value":"Y & R Hall Machinery, Inc"},{"label":"Y & R Marple Machinery, Inc","selected":"false","value":"Y & R Marple Machinery, Inc"},{"label":"Y & R Muenich Machinery, Inc","selected":"false","value":"Y & R Muenich Machinery, Inc"},{"label":"Y & R Sherfy Machinery, Inc","selected":"false","value":"Y & R Sherfy Machinery, Inc"},{"label":"Y & R Short Machinery, Inc","selected":"false","value":"Y & R Short Machinery, Inc"},{"label":"Y & R Vij Machinery, Inc","selected":"false","value":"Y & R Vij Machinery, Inc"},{"label":"Y & R Wood Machinery, Inc","selected":"false","value":"Y & R Wood Machinery, Inc"},{"label":"Zimmerman-Evans Construction, Ltd","selected":"false","value":"Zimmerman-Evans Construction, Ltd"},{"label":"Zingarelli-Valentine Construction, Ltd","selected":"false","value":"Zingarelli-Valentine Construction, Ltd"},{"label":"Z & L Glass Construction, Ltd","selected":"false","value":"Z & L Glass Construction, Ltd"},{"label":"Z & L Homax Construction, Ltd","selected":"false","value":"Z & L Homax Construction, Ltd"},{"label":"Z & L Maynard Construction, Ltd","selected":"false","value":"Z & L Maynard Construction, Ltd"},{"label":"Z & L Skapinok Construction, Ltd","selected":"false","value":"Z & L Skapinok Construction, Ltd"},{"label":"Z & L Skuce Construction, Ltd","selected":"false","value":"Z & L Skuce Construction, Ltd"},{"label":"Z & L Steele Construction, Ltd","selected":"false","value":"Z & L Steele Construction, Ltd"},{"label":"Z & L Whipple Construction, Ltd","selected":"false","value":"Z & L Whipple Construction, Ltd"},{"label":"Z & L Wilson Construction, Ltd","selected":"false","value":"Z & L Wilson Construction, Ltd"},{"label":"Z & L Wisnewski Construction, Ltd","selected":"false","value":"Z & L Wisnewski Construction, Ltd"},{"label":"Z & N Maggard Communications Partners","selected":"false","value":"Z & N Maggard Communications Partners"},{"label":"Zocchi-Walsh Machinery, Inc","selected":"false","value":"Zocchi-Walsh Machinery, Inc"},{"label":"Zugelder-Malmendier Machinery Partners","selected":"false","value":"Zugelder-Malmendier Machinery Partners"},{"label":"Zuluaga-Abo Engineering, Ltd","selected":"false","value":"Zuluaga-Abo Engineering, Ltd"}]}}]}'
                    },
                    expected:{
                        requestUrl:"rest_v2/reports/reports/samples/Cascading_multi_select_report/inputControls/values"
                    }
                },
                updatedValues:{
                    success:{
                        status:200,
                        responseText:'{"inputControlState":[{"uri":"/reports/samples/Cascading_multi_select_report_files/Country_multi_select","value":"","options":{"option":[{"label":"Canada","selected":"false","value":"Canada"},{"label":"Mexico","selected":"true","value":"Mexico"},{"label":"USA","selected":"true","value":"USA"}]}},{"uri":"/reports/samples/Cascading_multi_select_report_files/Cascading_state_multi_select","value":"","options":{"option":[{"label":"Mexico | DF","selected":"false","value":"DF"},{"label":"Mexico | Guerrero","selected":"true","value":"Guerrero"},{"label":"Mexico | Jalisco","selected":"false","value":"Jalisco"},{"label":"Mexico | Mexico","selected":"false","value":"Mexico"},{"label":"Mexico | Oaxaca","selected":"false","value":"Oaxaca"},{"label":"Mexico | Sinaloa","selected":"true","value":"Sinaloa"},{"label":"Mexico | Veracruz","selected":"false","value":"Veracruz"},{"label":"Mexico | Yucatan","selected":"false","value":"Yucatan"},{"label":"Mexico | Zacatecas","selected":"false","value":"Zacatecas"}]}},{"uri":"/reports/samples/Cascading_multi_select_report_files/Cascading_name_single_select","value":"","options":{"option":[{"label":"Barnurn-Chrisman Electronics, Ltd","selected":"false","value":"Barnurn-Chrisman Electronics, Ltd"},{"label":"Brown-Giglio Electronics, Ltd","selected":"false","value":"Brown-Giglio Electronics, Ltd"},{"label":"Bruno-Bowers Communications Associates","selected":"false","value":"Bruno-Bowers Communications Associates"},{"label":"Choin-Crow Engineering Associates","selected":"false","value":"Choin-Crow Engineering Associates"},{"label":"D & D Hollar Electronics Holdings","selected":"false","value":"D & D Hollar Electronics Holdings"},{"label":"D & D Minniear Transportation, Ltd","selected":"false","value":"D & D Minniear Transportation, Ltd"},{"label":"D & D Weller Electronics Holdings","selected":"false","value":"D & D Weller Electronics Holdings"},{"label":"D & G Burkhardt Transportation, Inc","selected":"false","value":"D & G Burkhardt Transportation, Inc"},{"label":"H & E Espinoza Machinery Group","selected":"false","value":"H & E Espinoza Machinery Group"},{"label":"K & R Holmes Communications Group","selected":"false","value":"K & R Holmes Communications Group"},{"label":"M & Y Browqett Communications, Ltd","selected":"false","value":"M & Y Browqett Communications, Ltd"},{"label":"N & W Hill Transportation Corp","selected":"false","value":"N & W Hill Transportation Corp"},{"label":"Q & Q Bergin Telecommunications Associates","selected":"false","value":"Q & Q Bergin Telecommunications Associates"},{"label":"Q & Q Christie Telecommunications Associates","selected":"false","value":"Q & Q Christie Telecommunications Associates"},{"label":"Renfro-Brockett Engineering, Ltd","selected":"false","value":"Renfro-Brockett Engineering, Ltd"},{"label":"Several-Thomas Transportation Holdings","selected":"false","value":"Several-Thomas Transportation Holdings"},{"label":"Sherwood-Becker Transportation Holdings","selected":"false","value":"Sherwood-Becker Transportation Holdings"},{"label":"S & X Kroes Engineering Partners","selected":"false","value":"S & X Kroes Engineering Partners"},{"label":"S & Y Romero Electronics Holdings","selected":"false","value":"S & Y Romero Electronics Holdings"},{"label":"Trujillo-Barrington Machinery, Inc","selected":"false","value":"Trujillo-Barrington Machinery, Inc"},{"label":"U & W Hirschboeck Construction Corp","selected":"false","value":"U & W Hirschboeck Construction Corp"},{"label":"V & P Burnett Transportation Corp","selected":"false","value":"V & P Burnett Transportation Corp"}]}}]}'
                    },
                    expected:{
                        requestUrl:"rest_v2/reports/reports/samples/Cascading_multi_select_report/inputControls/Country_multi_select;Cascading_state_multi_select;Cascading_name_single_select/values"
                    }
                },
                controlWithDependencies:{
                    success:{
                        status:200,
                        responseText:'{"fromIndex":"0","toIndex":"9","totalCount":"50","values":{"value":["value_0","value_1","value_2","value_3","value_4","value_5","value_6","value_7","value_8","value_9"]}}'
                    },
                    expected:{
                        formatedStructure:["value_0", "value_1", "value_2", "value_3", "value_4", "value_5", "value_6", "value_7", "value_8", "value_9"],
                        requestUrl:"rest_v2/reports/reports/samples/Cascading_multi_select_report/inputControls/Cascading_name_single_select/values?Country_multi_select=USA&Cascading_state_multi_select%5B%5D=CA&Cascading_state_multi_select%5B%5D=WA"
                    }
                },
                addControlStructure :{
                    success:{
                        status:200,
                        responseText:'{"inputControlState":[{"uri":"/bla/bla/control_1","id":"control_1","type":"singleSelect", "readOnly":"false"}]}'
                    }
                },

                addControlValues :{
                    success:{
                        status:200,
                        responseText:''
                    }
                },

                addControlsStructure :{
                    success:{
                        status:200,
//                        TODO: add two input controls
                        responseText:'{"inputControlState":[{"uri":"/bla/bla/control_1","id":"control_1","type":"singleSelect", "readOnly":"false"}]}'
                    }
                },


                addControlsValues :{
                    success:{
                        status:200,
                        responseText:''
                    }
                }

            }
        }
    })();
}
