define(["jquery",
        "underscore",
        "backbone",
        "components.ajaxdownloader",
        "components.state",
        "components.statecontrollertrait",
        "export.statecontroller"],
        function($, _, Backbone, AjaxDownloader, State, StateControllerTrait, StateController) {

        describe("StateController", function() {

            var controller;

            describe("Initialization", function() {

                it("should initialize downloader", function() {
                    sinon.stub(StateControllerTrait, "initialize");

                    var controller = new StateController();
                    expect(controller.downloader).toBeDefined();
                    expect(StateControllerTrait.initialize).toHaveBeenCalled();

                    StateControllerTrait.initialize.restore();
                });

            });

            describe("Base functionality", function() {

                var model, modelMock, downloaderMock, controllerMock, state;

                beforeEach(function() {
                    controller = new StateController();
                    state = new State({message: "message", phase: "phase"});
                    model = state;
                    model.reset = function() {
                    };
                    modelMock = sinon.mock(model);
                    downloaderMock = sinon.mock(controller.downloader);
                    controllerMock = sinon.mock(controller);
                });

                afterEach(function() {
                    downloaderMock.restore();
                    modelMock.restore();
                    controllerMock.restore();
                });

                it("can generate file url", function() {
                    model.set({id: "uuid"});
                    model.name = "testFileName.zip";
                    expect(controller.getFileUrl(model)).toEqual("rest_v2/export/uuid/testFileName.zip");

                    model.name = "testFileName";
                    expect(controller.getFileUrl(model)).toEqual("rest_v2/export/uuid/testFileName.zip");
                });

                it("can handle ready phase", function() {
                    sinon.stub(controller, "getFileUrl", function() {
                        return "test"
                    });
                    downloaderMock.expects("start").once().withArgs("test");
                    controller.handleReadyPhase(model);
                    downloaderMock.verify();
                });

            });

        });

    });