/*
 * Copyright (C) 2005 - 2012 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public  License
 *  along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.jaspersoft.jasperserver.api.security.externalAuth.sso;

import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

import javax.servlet.http.HttpServletRequest;

/**
 * @author Chaim Arbiv
 * extends {@link AbstractSsoAuthenticationProcessingFilter}
 */
public class SsoAuthenticationProcessingFilter extends AbstractSsoAuthenticationProcessingFilter {
	private final static Logger logger = LogManager.getLogger(SsoAuthenticationProcessingFilter.class);

	/**
     * If present, gets SSO token from the {@link HttpServletRequest}.
     *
     * @param request - redirect from SSO server
     * @return if present the artifact from the {@link HttpServletRequest}, else null
     */
    protected Object obtainTicket(HttpServletRequest request) {
		logger.debug("Obtaining ticket from request parameter");
        return request.getParameter(getExternalAuthProperties().getTicketParameterName());
    }
}
