package com.jaspersoft.jasperserver.api.metadata.olap.util;

import java.io.UnsupportedEncodingException;
import java.net.URL;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.olap4j.driver.xmla.cache.XmlaOlap4jNamedMemoryCache;

/**
 * this class overwrites XmlaOlap4jNamedMemoryCache to fix bug 29966
 * by enforcing UTF-8 characterset for cached responses
 * Created by IntelliJ IDEA. User: ichan Date: 11/27/12 Time: 2:47 PM
 */
public class JasperServerXMLACache extends XmlaOlap4jNamedMemoryCache {

	protected static final Log log = LogFactory.getLog(JasperServerXMLACache.class);

	public JasperServerXMLACache() {
		super();
	}

	@Override
	public void put(String id, URL url, byte[] request, byte[] response)
			throws RuntimeException {
		log.debug("Intercepted XMLA cache put\nid: "+id+"\nurl: "+url+"\nrequest: "+request+"\nresponse: s"+response);
		try {
			super.put(id, url, request, new String(response).getBytes("UTF-8"));
		} catch (UnsupportedEncodingException ex) {
			log.warn("Failed to convert XMLA response to UTF-8",ex);
		}
	}
}
