/*
* Copyright (C) 2005 - 2009 Jaspersoft Corporation. All rights  reserved.
* http://www.jaspersoft.com.
*
* Unless you have purchased  a commercial license agreement from Jaspersoft,
* the following license terms  apply:
*
* This program is free software: you can redistribute it and/or  modify
* it under the terms of the GNU Affero General Public License  as
* published by the Free Software Foundation, either version 3 of  the
* License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU Affero  General Public License for more details.
*
* You should have received a copy of the GNU Affero General Public  License
* along with this program.&nbsp; If not, see <http://www.gnu.org/licenses/>.
*/
package com.jaspersoft.jasperserver.dto.resources;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;

/**
 * <p></p>
 *
 * @author Yaroslav.Kovalchyk
 * @version $Id: ClientDataSourceHolder.java 29335 2013-03-07 09:15:12Z ykovalchyk $
 */
public class ClientDataSourceHolder extends ClientResourceLookup {

    private ClientReferenceableDataSource dataSource;

    @XmlElements({
            /*ClientResourceLookup is included here to serve as resource reference*/
            @XmlElement(type = ClientReference.class, name = "dataSourceReference"),
            @XmlElement(type = ClientAwsDataSource.class, name = "awsDataSource"),
            @XmlElement(type = ClientBeanDataSource.class, name = "beanDataSource"),
            @XmlElement(type = ClientCustomDataSource.class, name = "customDataSource"),
            @XmlElement(type = ClientJdbcDataSource.class, name = "jdbcDataSource"),
            @XmlElement(type = ClientJndiJdbcDataSource.class, name = "jndiJdbcDataSource"),
            @XmlElement(type = ClientVirtualDataSource.class, name = "virtualDataSource"),
            @XmlElement(type = ClientSemanticLayerDataSource.class, name = "semanticLayerDataSource"),
            @XmlElement(type = ClientAdhocDataView.class, name = "advDataSource")
    })
    public ClientReferenceableDataSource getDataSource() {
        return dataSource;
    }

    public void setDataSource(ClientReferenceableDataSource dataSource) {
        this.dataSource = dataSource;
    }
}
