/*
* Copyright (C) 2005 - 2013 Jaspersoft Corporation. All rights  reserved.
* http://www.jaspersoft.com.
*
* Unless you have purchased  a commercial license agreement from Jaspersoft,
* the following license terms  apply:
*
* This program is free software: you can redistribute it and/or  modify
* it under the terms of the GNU Affero General Public License  as
* published by the Free Software Foundation, either version 3 of  the
* License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU Affero  General Public License for more details.
*
* You should have received a copy of the GNU Affero General Public  License
* along with this program.&nbsp; If not, see <http://www.gnu.org/licenses/>.
*/
package com.jaspersoft.jasperserver.dto.resources;


import org.testng.annotations.Test;

import java.util.HashMap;
import java.util.List;

import static org.testng.Assert.*;

/**
 * <p></p>
 *
 * @author Yaroslav.Kovalchyk
 * @version $Id: ClientReportUnitTest.java 29531 2013-03-12 09:50:30Z ykovalchyk $
 */
public class ClientReportUnitTest {
    private ClientReportUnit reportUnit = new ClientReportUnit();

    @Test
    public void getResourcesAsList_nullProducesNull(){
        reportUnit.setFiles(null);
        assertNull(reportUnit.getFilesAsList());
    }

    @Test
    public void getResourcesAsList_emptyMapProducesNull(){
        reportUnit.setFiles(new HashMap<String, ClientReferenceableFile>());
        assertNull(reportUnit.getFilesAsList());
    }

    @Test
    public void getResourcesAsList(){
        final HashMap<String, ClientReferenceableFile> resources = new HashMap<String, ClientReferenceableFile>();
        final String resourceName1 = "testResourceName1";
        final String resourceName2 = "testResourceName2";
        final String resourceName3 = "testResourceName3";
        final ClientReferenceableFile resource1 = new ClientFile();
        final ClientReferenceableFile resource2 = new ClientFile();
        final ClientReferenceableFile resource3 = new ClientFile();
        resources.put(resourceName1, resource1);
        resources.put(resourceName2, resource2);
        resources.put(resourceName3, resource3);
        reportUnit.setFiles(resources);
        final List<ClientReportUnitResource> result = reportUnit.getFilesAsList();
        assertNotNull(result);
        assertEquals(result.size(), resources.size());
        for(ClientReportUnitResource currentResource : result){
            if(resourceName1.equals(currentResource.getName())){
                assertSame(currentResource.getFile(), resource1);
            } else if(resourceName2.equals(currentResource.getName())){
                assertSame(currentResource.getFile(), resource2);
            } else if(resourceName3.equals(currentResource.getName())){
                assertSame(currentResource.getFile(), resource3);
            } else {
                // no other names are allowed
                assertTrue(false);
            }
        }

    }
}
