/*
* Copyright (C) 2005 - 2009 Jaspersoft Corporation. All rights  reserved.
* http://www.jaspersoft.com.
*
* Unless you have purchased  a commercial license agreement from Jaspersoft,
* the following license terms  apply:
*
* This program is free software: you can redistribute it and/or  modify
* it under the terms of the GNU Affero General Public License  as
* published by the Free Software Foundation, either version 3 of  the
* License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU Affero  General Public License for more details.
*
* You should have received a copy of the GNU Affero General Public  License
* along with this program.&nbsp; If not, see <http://www.gnu.org/licenses/>.
*/
package com.jaspersoft.jasperserver.remote.resources.converters;

import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.MondrianConnection;
import com.jaspersoft.jasperserver.dto.resources.ClientFile;
import com.jaspersoft.jasperserver.dto.resources.ClientMondrianConnection;
import com.jaspersoft.jasperserver.dto.resources.ClientReferenceableFile;
import com.jaspersoft.jasperserver.remote.exception.IllegalParameterValueException;
import com.jaspersoft.jasperserver.remote.exception.MandatoryParameterNotFoundException;
import org.springframework.stereotype.Service;

/**
 * <p></p>
 *
 * @author Yaroslav.Kovalchyk
 * @version $Id: MondrianConnectionResourceConverter.java 29489 2013-03-11 15:59:46Z ztomchenco $
 */
@Service
public class MondrianConnectionResourceConverter extends DataSourceHolderResourceConverter<MondrianConnection,
        ClientMondrianConnection>{

    @Override
    protected MondrianConnection resourceSpecificFieldsToServer(ClientMondrianConnection clientObject,
            MondrianConnection resultToUpdate) throws IllegalParameterValueException, MandatoryParameterNotFoundException {
        resultToUpdate.setSchema(resourceReferenceConverterProvider.getConverterForType(ClientReferenceableFile.class)
                .addReferenceRestriction(new ResourceReferenceConverter.FileTypeRestriction(ClientFile.FileType.xml))
                .toServer(clientObject.getSchema(), resultToUpdate.getSchema()));
        return resultToUpdate;

    }

    @Override
    protected ClientMondrianConnection resourceSpecificFieldsToClient(ClientMondrianConnection client,
            MondrianConnection serverObject) {
        client.setSchema(resourceReferenceConverterProvider.getConverterForType(ClientReferenceableFile.class)
                .toClient(serverObject.getSchema()));
        return client;
    }

    @Override
    protected void setDataSourceToResource(ResourceReference dataSourceReference, MondrianConnection resource) {
        resource.setDataSource(dataSourceReference);
    }

    @Override
    protected ResourceReference getDataSourceFromResource(MondrianConnection resource) {
        return resource.getDataSource();
    }
}
