/*
* Copyright (C) 2005 - 2009 Jaspersoft Corporation. All rights  reserved.
* http://www.jaspersoft.com.
*
* Unless you have purchased  a commercial license agreement from Jaspersoft,
* the following license terms  apply:
*
* This program is free software: you can redistribute it and/or  modify
* it under the terms of the GNU Affero General Public License  as
* published by the Free Software Foundation, either version 3 of  the
* License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU Affero  General Public License for more details.
*
* You should have received a copy of the GNU Affero General Public  License
* along with this program.&nbsp; If not, see <http://www.gnu.org/licenses/>.
*/
package com.jaspersoft.jasperserver.remote.resources;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.AwsReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JdbcReportDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientResourceLookup;
import com.jaspersoft.jasperserver.remote.exception.IllegalParameterValueException;
import com.jaspersoft.jasperserver.remote.resources.converters.AwsDataSourceResourceConverter;
import com.jaspersoft.jasperserver.remote.resources.converters.FolderResourceConverter;
import com.jaspersoft.jasperserver.remote.resources.converters.JdbcDataSourceResourceConverter;
import com.jaspersoft.jasperserver.remote.resources.converters.ResourceConverter;
import com.jaspersoft.jasperserver.remote.resources.converters.ResourceConverterImpl;
import org.testng.annotations.Test;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import static org.testng.Assert.*;

/**
 * <p></p>
 *
 * @author Yaroslav.Kovalchyk
 * @version $Id: GenericParametersReflectionHelperTest.java 29335 2013-03-07 09:15:12Z ykovalchyk $
 */
public class GenericParametersReflectionHelperTest {

    public static final String NAME_FROM_XML_ROOT_ELEMENT_ANNOTATION = "nameFromXmlRootElementAnnotation";
    public static final String NAME_FROM_XML_TYPE_ANNOTATION = "nameFromXmlTypeAnnotation";

    @Test
    public void getGenericTypeArgument() {
        // raw type parsing should throw exception
        IllegalArgumentException exception = null;
        try {
            GenericParametersReflectionHelper.getGenericTypeArgument(new ResourceConverterImpl() {
                @Override
                protected Resource resourceSpecificFieldsToServer(ClientResourceLookup clientObject, Resource resultToUpdate) throws IllegalParameterValueException {
                    return null;
                }

                @Override
                protected ClientResourceLookup resourceSpecificFieldsToClient(ClientResourceLookup client, Resource serverObject) {
                    return null;
                }
            }.getClass(), ResourceConverterImpl.class, 0);
        } catch (IllegalArgumentException e) {
            exception = e;
        }
        assertNotNull(exception);
        assertEquals(GenericParametersReflectionHelper.getGenericTypeArgument(FolderResourceConverter.class, ResourceConverterImpl.class, 0), Folder.class);
        assertEquals(GenericParametersReflectionHelper.getGenericTypeArgument(JdbcDataSourceResourceConverter.class, ResourceConverterImpl.class, 0), JdbcReportDataSource.class);
        assertEquals(GenericParametersReflectionHelper.getGenericTypeArgument(JdbcDataSourceResourceConverter.class, ResourceConverter.class, 0), JdbcReportDataSource.class);
        assertEquals(GenericParametersReflectionHelper.getGenericTypeArgument(AwsDataSourceResourceConverter.class, ResourceConverter.class, 0), AwsReportDataSource.class);
    }

    @Test
    public void findParametrizedType() {
        IllegalArgumentException exception = null;
        try{
            // try to parse raw type for generic class arguments. Exception should be thrown.
            GenericParametersReflectionHelper.findParametrizedType(new ResourceConverterImpl() {
                @Override
                protected Resource resourceSpecificFieldsToServer(ClientResourceLookup clientObject, Resource resultToUpdate) throws IllegalParameterValueException {
                    return null;
                }

                @Override
                protected ClientResourceLookup resourceSpecificFieldsToClient(ClientResourceLookup client, Resource serverObject) {
                    return null;
                }
            }.getClass(), ResourceConverterImpl.class);
        } catch (IllegalArgumentException e){
            exception = e;
        }
        assertNotNull(exception);
        exception = null;
        try{
            // try to parse raw type for generic interface arguments. Exception should be thrown.
            GenericParametersReflectionHelper.findParametrizedType(new ResourceConverter() {
                @Override
                public Object toClient(Object serverObject) {
                    return null;
                }

                @Override
                public String getClientResourceType() {
                    return null;
                }

                @Override
                public Object toServer(Object clientObject) throws IllegalParameterValueException {
                    return null;
                }

                @Override
                public Object toServer(Object clientObject, Object resultToUpdate) throws IllegalParameterValueException {
                    return null;
                }

                @Override
                public String getServerResourceType() {
                    return null;
                }
            }.getClass(), ResourceConverter.class);
        } catch (IllegalArgumentException e){
            exception = e;
        }
        assertNotNull(exception);

        assertSame(GenericParametersReflectionHelper.findParametrizedType(AwsDataSourceResourceConverter.class, ResourceConverter.class), null);
        assertSame(GenericParametersReflectionHelper.findParametrizedType(JdbcDataSourceResourceConverter.class, ResourceConverter.class), null);
        assertSame(GenericParametersReflectionHelper.findParametrizedType(ResourceConverterImpl.class, ResourceConverter.class).getRawType(), ResourceConverter.class);
        assertSame(GenericParametersReflectionHelper.findParametrizedType(JdbcDataSourceResourceConverter.class, ResourceConverterImpl.class).getRawType(), ResourceConverterImpl.class);
    }

    @Test
    public void extractClientType_XmlRootElementAnnotation() {
        assertEquals(NAME_FROM_XML_ROOT_ELEMENT_ANNOTATION, GenericParametersReflectionHelper.extractClientType(TestClientObjectWithXmlRootAnnotation.class));
    }

    @Test
    public void extractClientType_XmlTypeAnnotation() {
        assertEquals(NAME_FROM_XML_TYPE_ANNOTATION, GenericParametersReflectionHelper.extractClientType(TestClientObjectWithXmlTypeAnnotation.class));
    }

    @Test
    public void extractClientType_NoAnnotation() {
        String simpleName = TestClientObjectWithoutAnnotation.class.getSimpleName();
        final String expectedClientType = simpleName.replaceFirst("^.", simpleName.substring(0, 1).toLowerCase());
        assertEquals(expectedClientType, GenericParametersReflectionHelper.extractClientType(TestClientObjectWithoutAnnotation.class));
    }

    @XmlRootElement(name = NAME_FROM_XML_ROOT_ELEMENT_ANNOTATION)
    private class TestClientObjectWithXmlRootAnnotation {
    }

    @XmlType(name = NAME_FROM_XML_TYPE_ANNOTATION)
    private class TestClientObjectWithXmlTypeAnnotation {
    }

    private class TestClientObjectWithoutAnnotation {
    }
}
