/*
* Copyright (C) 2005 - 2009 Jaspersoft Corporation. All rights  reserved.
* http://www.jaspersoft.com.
*
* Unless you have purchased  a commercial license agreement from Jaspersoft,
* the following license terms  apply:
*
* This program is free software: you can redistribute it and/or  modify
* it under the terms of the GNU Affero General Public License  as
* published by the Free Software Foundation, either version 3 of  the
* License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU Affero  General Public License for more details.
*
* You should have received a copy of the GNU Affero General Public  License
* along with this program.&nbsp; If not, see <http://www.gnu.org/licenses/>.
*/
package com.jaspersoft.jasperserver.remote.resources.converters;

import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.CustomReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.client.CustomReportDataSourceImpl;
import com.jaspersoft.jasperserver.dto.resources.ClientCustomDataSource;
import com.jaspersoft.jasperserver.dto.resources.ClientProperty;
import com.jaspersoft.jasperserver.remote.exception.IllegalParameterValueException;
import com.jaspersoft.jasperserver.remote.resources.GenericParametersReflectionHelper;
import org.testng.annotations.Test;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static org.testng.Assert.*;

/**
 * <p></p>
 *
 * @author Yaroslav.Kovalchyk
 * @version $Id: CustomDataSourceResourceConverterTest.java 29489 2013-03-11 15:59:46Z ztomchenco $
 */
public class CustomDataSourceResourceConverterTest {

    private CustomDataSourceResourceConverter converter = new CustomDataSourceResourceConverter();

    @Test
    public void correctClientServerResourceType(){
        assertEquals(converter.getClientResourceType(), GenericParametersReflectionHelper.extractClientType(ClientCustomDataSource.class));
        assertEquals(converter.getServerResourceType(), CustomReportDataSource.class.getName());
    }
    @Test
    public void resourceSpecificFieldsToServer() throws Exception {
        final String expectedServiceClass = "testServiceClass";
        final String expectedDataSourceName = "testDataSourceName";
        final String expectedPropertyKey1 = "testPropertyKey1";
        final String expectedPropertyKey2 = "testPropertyKey2";
        final String expectedPropertyValue1 = "testPropertyValue1";
        final String expectedPropertyValue2 = "testPropertyValue2";
        final ClientCustomDataSource clientObject = new ClientCustomDataSource();
        clientObject.setServiceClass(expectedServiceClass);
        clientObject.setDataSourceName(expectedDataSourceName);
        List<ClientProperty> properties = new ArrayList<ClientProperty>();
        properties.add(new ClientProperty(expectedPropertyKey1, expectedPropertyValue1));
        properties.add(new ClientProperty(expectedPropertyKey2, expectedPropertyValue2));
        clientObject.setProperties(properties);
        final CustomReportDataSource serverObject = new CustomReportDataSourceImpl();
        final CustomReportDataSource result = converter.resourceSpecificFieldsToServer(clientObject, serverObject);
        assertSame(result, serverObject);
        assertEquals(result.getServiceClass(), expectedServiceClass);
        assertEquals(result.getDataSourceName(), expectedDataSourceName);
        final Map<String, String> propertyMap = result.getPropertyMap();
        assertNotNull(propertyMap);
        assertEquals(propertyMap.size(), 2);
        for(String key : propertyMap.keySet()){
            if(expectedPropertyKey1.equals(key)){
                assertEquals(propertyMap.get(key), expectedPropertyValue1);
            } else if(expectedPropertyKey2.equals(key)){
                assertEquals(propertyMap.get(key), expectedPropertyValue2);
            } else {
                // it's not allowed to have some other keys
                assertTrue(false);
            }
        }

    }

    @Test
    public void resourceSpecificFieldsToClient(){
        final String expectedServiceClass = "testServiceClass";
        final String expectedDataSourceName = "testDataSourceName";
        final String expectedPropertyKey1 = "testPropertyKey1";
        final String expectedPropertyKey2 = "testPropertyKey2";
        final String expectedPropertyValue1 = "testPropertyValue1";
        final String expectedPropertyValue2 = "testPropertyValue2";
        final ClientCustomDataSource clientObject = new ClientCustomDataSource();
        final CustomReportDataSource serverObject = new CustomReportDataSourceImpl();
        serverObject.setServiceClass(expectedServiceClass);
        serverObject.setDataSourceName(expectedDataSourceName);
        Map<String, String> properties = new HashMap<String, String>();
        properties.put(expectedPropertyKey1, expectedPropertyValue1);
        properties.put(expectedPropertyKey2, expectedPropertyValue2);
        serverObject.setPropertyMap(properties);
        final ClientCustomDataSource result = converter.resourceSpecificFieldsToClient(clientObject, serverObject);
        assertSame(result, clientObject);
        assertEquals(result.getServiceClass(), expectedServiceClass);
        assertEquals(result.getDataSourceName(), expectedDataSourceName);
        final List<ClientProperty> resultProperties = result.getProperties();
        assertNotNull(resultProperties);
        assertEquals(resultProperties.size(), 2);
        for(ClientProperty property : resultProperties){
            if(expectedPropertyKey1.equals(property.getKey())){
                assertEquals(property.getValue(), expectedPropertyValue1);
            } else if(expectedPropertyKey2.equals(property.getKey())){
                assertEquals(property.getValue(), expectedPropertyValue2);
            } else {
                // not allowed to have any other property name
                assertTrue(false);
            }
        }
    }
}
