/*
* Copyright (C) 2005 - 2009 Jaspersoft Corporation. All rights  reserved.
* http://www.jaspersoft.com.
*
* Unless you have purchased  a commercial license agreement from Jaspersoft,
* the following license terms  apply:
*
* This program is free software: you can redistribute it and/or  modify
* it under the terms of the GNU Affero General Public License  as
* published by the Free Software Foundation, either version 3 of  the
* License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU Affero  General Public License for more details.
*
* You should have received a copy of the GNU Affero General Public  License
* along with this program.&nbsp; If not, see <http://www.gnu.org/licenses/>.
*/
package com.jaspersoft.jasperserver.remote.resources.converters;

import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.client.JdbcReportDataSourceImpl;
import com.jaspersoft.jasperserver.dto.resources.ClientJdbcDataSource;
import com.jaspersoft.jasperserver.remote.exception.IllegalParameterValueException;
import com.jaspersoft.jasperserver.remote.resources.GenericParametersReflectionHelper;
import org.testng.annotations.Test;

import static org.testng.Assert.assertEquals;
import static org.testng.Assert.assertSame;

/**
 * <p></p>
 *
 * @author Yaroslav.Kovalchyk
 * @version $Id: JdbcDataSourceResourceConverterTest.java 29489 2013-03-11 15:59:46Z ztomchenco $
 */
public class JdbcDataSourceResourceConverterTest {
    private JdbcDataSourceResourceConverter converter = new JdbcDataSourceResourceConverter();

    @Test
    public void correctClientServerResourceType(){
        assertEquals(converter.getClientResourceType(), GenericParametersReflectionHelper.extractClientType(ClientJdbcDataSource.class));
        assertEquals(converter.getServerResourceType(), JdbcReportDataSource.class.getName());
    }

    @Test
    public void resourceSpecificFieldsToServer() throws Exception {
        final String expectedDriverClass = "testDriverClass";
        final String expectedPassword = "testPassword";
        final String expectedUsername = "testUsername";
        final String expectedConnectionUrl = "testConnectionUrl";
        final ClientJdbcDataSource clientObject = new ClientJdbcDataSource();
        clientObject.setConnectionUrl(expectedConnectionUrl);
        clientObject.setDriverClass(expectedDriverClass);
        clientObject.setPassword(expectedPassword);
        clientObject.setUsername(expectedUsername);
        final JdbcReportDataSource serverObject = new JdbcReportDataSourceImpl();
        final JdbcReportDataSource result = converter.resourceSpecificFieldsToServer(clientObject, serverObject);
        assertSame(result, serverObject);
        assertEquals(result.getConnectionUrl(), expectedConnectionUrl);
        assertEquals(result.getDriverClass(), expectedDriverClass);
        assertEquals(result.getPassword(), expectedPassword);
        assertEquals(result.getUsername(), expectedUsername);
    }

    @Test
    public void resourceSpecificFieldsToClient(){
        final String expectedDriverClass = "testDriverClass";
        final String expectedPassword = "testPassword";
        final String expectedUsername = "testUsername";
        final String expectedConnectionUrl = "testConnectionUrl";
        final ClientJdbcDataSource clientObject = new ClientJdbcDataSource();
        final JdbcReportDataSource serverObject = new JdbcReportDataSourceImpl();
        serverObject.setConnectionUrl(expectedConnectionUrl);
        serverObject.setDriverClass(expectedDriverClass);
        serverObject.setPassword(expectedPassword);
        serverObject.setUsername(expectedUsername);
        final ClientJdbcDataSource result = converter.resourceSpecificFieldsToClient(clientObject, serverObject);
        assertSame(result, clientObject);
        assertEquals(result.getConnectionUrl(), expectedConnectionUrl);
        assertEquals(result.getDriverClass(), expectedDriverClass);
        assertEquals(result.getPassword(), expectedPassword);
        assertEquals(result.getUsername(), expectedUsername);
    }
}
