/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * @author inesterenko
 */


define({

    //Third-Party scripts
    "underscore":{
        exports:'_'
    },

    "backbone":{
        deps :["underscore"],
        exports:'Backbone'
    },

    "mustache":{
        exports:'Mustache'
    },

    "json2":{
        exports:"JSON"
    },

    "nwmatcher":{
        exports:"jQuery"   // workaround for IE 'enforceDefine'
    },

    "prototype":{
        deps:["nwmatcher"],
        exports:"$"
    },

    "builder" : {
         exports: "Builder"
    },

    "effects":{
        deps:["prototype"],
        exports:"Effect"
    },

    "dragdrop": {
        deps: ["prototype", "effects"],
        exports: "Draggable"  // workaround for IE 'enforceDefine'
    },

    "touchcontroller" : {
        deps: ["jquery"],
        exports: "TouchController"
    },

    "iscroll" : {
        exports: "iScroll"
    },

    //JasperServer Namespaces support


    "ns":{
        exports:"jaspersoft"
    },

    //CE modules

    "utils.common":{
        deps:["prototype", "jquery", "underscore"],
        exports:"jQuery"  // workaround for IE 'enforceDefine'
    },

    "utils.animation":{
        deps:["prototype", "effects"],
        exports:"jQuery" // workaround for IE 'enforceDefine'
    },

    "jquery.ui":{
        deps:["jquery"],
        exports: "jQuery"
    },

    "jquery.datapicker.extensions":{
        deps:["jquery", "jquery.ui"],
        exports:"jQuery"
    },

    "jquery.timepicker":{
        deps:["jquery", "jquery.datapicker.extensions"],
        exports: "jQuery"
    },

    "jquery.urldecoder":{
        deps:["jquery"],
        exports: "jQuery"
    },

    "tools.truncator":{
        deps:["prototype"],
        exports:"jQuery" // workaround for IE 'enforceDefine'
    },

    "actionModel.modelGenerator": {
        deps: ["prototype", "utils.common", "core.events.bis"],
        exports: "actionModel"
    },

    "fakeActionModel.primaryNavigation":{
        exports: "primaryNavModule"
    },

    "actionModel.primaryNavigation": {
        deps: ["actionModel.modelGenerator"],
        exports: "primaryNavModule"
    },

    "encryption.utils": {
        deps: [],
        exports: "JSEncrypter"
    },

    "core.layout":{
        deps:["jquery", "prototype", "utils.common", "dragdrop", "tools.truncator", "iscroll"],
        exports:"layoutModule"
    },

    "ajax.mock": {
        deps: ["jquery"],
        exports: "fakeResponce"
    },

    "core.ajax":{
        //TODO: it has dependency to 'jive' object in jasperreports-global.js (JasperReport)
        deps:["jquery", "prototype", "utils.common", "builder", "ns"],
        exports:"ajax"
    },

    "core.accessibility": {
        deps:["prototype", "components.list", "actionModel.modelGenerator", "core.events"],
        exports: "accessibilityModule"
    },

    "core.events.bis": {
        //use primary navigation as dependency
        deps: ["jquery", "prototype" , "utils.common", "core.layout"],
        exports: "buttonManager"
    },

    "components.templateengine":{
        deps:["ns", "jquery", "underscore", "mustache"],
        exports:"jaspersoft.components.templateEngine"
    },

    "components.ajaxdownloader":{
        deps:["ns", "jquery", "underscore", "backbone"],
        exports:"jaspersoft.components.AjaxDownloader"
    },

    "components.ajaxuploader":{
        deps:["ns", "jquery", "underscore", "components.templateengine"],
        exports:"jaspersoft.components.AjaxUploader"
    },

    "components.authoritymodel" : {
        deps:["ns", "jquery", "underscore", "backbone", "components.templateengine"],
        exports: "jaspersoft.components.AuthorityModel"
    },

    "components.authoritypickerview" : {
        deps:["ns", "jquery", "underscore", "backbone", "components.templateengine"],
        exports: "jaspersoft.components.AuthorityPickerView"
    },

    "components.dialogs":{
        deps: ["jquery", "prototype", "underscore", "utils.common", "utils.animation", "core.layout"],
        exports:"dialogs"
    },

    "components.dialog":{
        deps: ["jquery", "underscore", "components.templateengine", "components.dialogs"],
        exports:"jaspersoft.components.Dialog"
    },

    "components.list": {
        deps: ["jquery", "prototype", "components.layout", "utils.common", "dragdrop", "core.events.bis"],
        exports: "dynamicList"
    },

    "components.layout": {
        deps: ["jquery", "underscore", "components.dialog", "components.systemnotificationview"],
        exports: "jaspersoft.components.Layout"
    },

    "components.searchBox": {
        deps: ["prototype", "utils.common", "core.events.bis"],
        exports: "SearchBox"
    },

    "components.servererrorsbackbonetrait":{
        deps:["ns", "jquery", "underscore"],
        exports:"jaspersoft.components.ServerErrorsBackboneTrait"
    },

    "components.notificationviewtrait":{
         deps:["ns", "jquery", "underscore", "backbone"],
         exports:"jaspersoft.components.NotificationViewTrait"
    },

    "components.statecontrollertrait":{
        deps:["ns", "jquery", "underscore", "backbone", "components.state"],
        exports:"jaspersoft.components.StateControllerTrait"
    },

    "components.state":{
        deps:["ns", "jquery", "underscore", "components.servererrorsbackbonetrait"],
        exports:"jaspersoft.components.State"
    },

    "components.stateview":{
        deps:["ns", "jquery", "underscore", "components.utils", "components.state"],
        exports:"jaspersoft.components.StateView"
    },

    "components.notificationview":{
        deps:["ns", "jquery", "underscore", "components.notificationviewtrait"],
        exports:"jaspersoft.components.NotificationView"
    },

    "components.systemnotificationview":{
        deps:["ns", "jquery", "underscore", "components.dialogs", "components.notificationviewtrait"],
        exports:"jaspersoft.components.SystemNotificationView"
    },

    // should not be used directly, load 'components.toolbar' instead
    "components.toolbarButtons" : {
        deps: ["jquery", "prototype"],
        exports : "toolbarButtonModule"
    },

    "components.toolbar" : {
        deps: ["jquery", "prototype", "utils.common", "components.toolbarButtons"],
        exports : "toolbarButtonModule"
    },

    "components.tooltip" : {
        deps: ["jquery", "prototype", "utils.common"],
        exports : "JSTooltip"
    },

    "components.tree" : {
        deps: ["prototype", "tree.treenode", "tree.events"],
        exports: "dynamicTree"
    },

    "components.utils" : {
        deps: ["jquery", "underscore", "mustache", "components.dialogs", "core.ajax"],
        exports: "jaspersoft.components.utils"
    },

    "controls.core":{
        deps:["jquery", "underscore", "mustache" , "components.dialogs", "ns"],
        exports:"JRS.Controls"
    },

    "controls.datatransfer":{
        deps:["jquery", "controls.core", "backbone"],
        exports:"JRS.Controls"
    },

    "controls.basecontrol":{
        deps:["jquery", "underscore", "controls.core"],
        exports:"JRS.Controls"
    },

    "controls.base":{
        deps:["jquery", "underscore", "utils.common"],
        exports: "ControlsBase"
    },

    "attributes.model":{
        // TODO ZT use separate template engine instead of controls.core's in production
        deps: ["ns", "underscore", "backbone", "components.templateengine", "controls.core"],
        exports: "jaspersoft.attributes"
    },

    "attributes.view":{
        deps: ["jquery", "underscore", "backbone", "attributes.model", "components.templateengine"],
        exports: "jaspersoft.attributes"
    },

    "export" : {
        deps:["ns"],
        exports: "JRS.Export"
    },

    "export.statecontroller" : {
        deps:["jquery", "underscore", "backbone", "components.statecontrollertrait", "components.ajaxdownloader"],
        exports: "JRS.Export.StateController"
    },

    "export.servererrortrait" : {
        deps:["underscore", "components.servererrorsbackbonetrait"],
        exports: "JRS.Export.ServerErrorTrait"
    },

    "export.formmodel" : {
        deps:["jquery", "underscore", "backbone", "export.servererrortrait", "components.state"],
        exports: "JRS.Export.FormModel"
    },

    "export.extendedformview" : {
        deps:["jquery", "underscore", "backbone", "components.templateengine", "components.authoritymodel", "components.authoritypickerview", "components.state"],
        exports: "JRS.Export.ExtendedFormView"
    },

    "export.shortformview" : {
        deps:["jquery", "underscore", "backbone", "components.templateengine", "components.state"],
        exports: "JRS.Export.ShortFormView"
    },

    "export.app" : {
        deps: ["jquery", "underscore", "export.formmodel", "components.layout", "export.statecontroller", "components.state"],
        exports: "JRS.Export.App"
    },

    "import.formmodel" : {
        deps: ["import","jquery", "underscore", "backbone", "components.servererrorsbackbonetrait", "components.state"],
        exports: "JRS.Import.FormModel"
    },

    "import.extendedformview" : {
        deps:["import", "jquery", "underscore", "backbone", "components.templateengine", "components.state", "components.ajaxuploader", "components.stateview"],
        exports: "JRS.Import.ExtendedFormView"
    },

    "import":{
        deps:["ns"],
        exports: "JRS.Import"
    },

    "import.app" : {
        deps: ["import", "jquery", "underscore", "import.formmodel", "components.layout", "components.state"],
        exports: "JRS.Import.App"
    },


    "report.view.base":{
        deps:["jquery", "underscore", "controls.basecontrol", "controls.base"],
        exports: "Report"
    },

    "controls.components":{
        deps:["jquery", "underscore", "controls.basecontrol", "core.layout", "jquery.datapicker.extensions", "jquery.timepicker"],
        exports:"JRS.Controls"
    },

    "controls.viewmodel":{
        deps:["jquery", "underscore", "controls.core", "controls.basecontrol"],
        exports:"JRS.Controls"
    },

    "controls.controller":{
        deps:["jquery", "underscore", "controls.core", "controls.datatransfer", "controls.viewmodel", "report.view.base", "jquery.urldecoder"],
        exports:"JRS.Controls"
    },

    "components.about":{
        deps: ["components.dialogs"],
        exports:"about"
    },

    "tree.nanotree" : {
        deps: ["prototype", "dragdrop", "touchcontroller", "utils.common"],
        exports: "dynamicTree"
    },

    "tree.treenode" : {
        deps: ["prototype", "tree.nanotree"],
        exports: "dynamicTree"
    },

    "tree.events" : {
        deps: ["prototype", "tree.nanotree"],
        exports: "dynamicTree"
    },

    "components.webHelp": {
        deps: ["jquery"],
        exports: "webHelpModule"
    },

    "tools.infiniteScroll": {
        deps: ["jquery", "prototype", "utils.common"],
        exports: "InfiniteScroll"
    },

    "mng.common": {
        deps: ["jquery", "prototype", "utils.common", "tools.infiniteScroll", "components.list"],
        exports: "orgModule"
    },

    "mng.main" : {
        deps: ["jquery", "mng.common"],
        exports: "orgModule"
    },

    "org.role.mng.main": {
        deps: ["jquery", "mng.main", "components.webHelp"],
        exports: "orgModule"
    },

    "mng.common.actions": {
        deps: ["jquery", "prototype", "mng.common"],
        exports: "orgModule"
    },

    "org.user.mng.main": {
        deps: ["jquery", "mng.main"],
        exports: "orgModule"
    },

    "org.user.mng.actions": {
        deps: ["jquery", "org.role.mng.main", "org.user.mng.main", "mng.common.actions"],
        exports: "orgModule"
    },

    "org.user.mng.components": {
        deps: ["jquery", "org.user.mng.main", "mng.common.actions", "encryption.utils"],
        exports: "orgModule"
    },

    "org.role.mng.components": {
        deps: ["jquery", "org.role.mng.main"],
        exports: "orgModule"
    },

    "repository.search.components":{
        exports: "GenerateResource"  //TODO: refactoring
    },

    //PRO modules

    "controls.dashboard":{
        deps:["jquery", "underscore", "controls.core", "controls.viewmodel", "controls.controller"],
        exports:"JRS.Controls"
    },

    "controls.options": {
        deps:["ns","jquery", "underscore", "controls.core", "controls.basecontrol"],
        exports:"JRS.Controls"
    },

    "controls.editoptions" :{
        deps:["controls.controller"],
        exports : "JRS.EditOptions"
    },

    "ext.utils.xregexp.unicode.min" :{
        exports : "XRegExp"
    },

    "components.pickers" : {
        deps: ["components.dialogs"],
        exports: "picker"
    },

    "resource.base" : {
        deps: ["prototype", "utils.common"],
        exports: "resource"
    },

    "resource.locate" : {
        deps: ["resource.base", "components.pickers"],
        exports: "resourceLocator"
    },

    "resource.dataSource": {
        deps: ["backbone", "resource.locate"],
        exports: "ResourceDataSource"
    },

    "resource.dataSource.jdbc": {
        deps: ["resource.dataSource", "components.dialog", "core.events.bis"],
        exports: "JdbcDataSourceEditor"
    }
});