/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * @author inesterenko
 */

require([
    "app.tests.conf.aliases",
    "app.tests.conf.shims",
    "app.conf.jrs",
    "app.main"
], function (testPathAndAliases, testsShims, jrsConfigs) {

    var jasperTests = requirejs.config({

        //force paths merging
        paths:testPathAndAliases,

        //Non amd scripts

        shim:testsShims,

        //Wait before giving up on loading a script.
        waitSeconds:15
    });

    //Setup tests environment (Load all specs and create reports)

    jasperTests([
       "tests/jasmine.env.factory"
    ], function (envFactory) {

        console.log("Prepare tests environment...");

        var jasmineEnv = envFactory.createWithAllReporters();

        jasperTests([
            "tests/ce.specs",
            "tests/pro.specs",
            "prototype",
            "domReady!"
        ], function () {

            // Now, call the "dom:loaded" event to run all events which are associated with objects involved into tests
            document.fire("dom:loaded");

            console.log("Start tests execution");
            jasmineEnv.execute();
        },function (err) {

            //workaround for PRO tests suites
            function makeLoadable(moduleId) {
                var failedId = err.requireModules && err.requireModules[0];
                if (failedId === moduleId) {
                    requirejs.undef(failedId);
                    var paths = {};
                    // 'empty' module used for replacing modules which are not found
                    paths[failedId] = jrsConfigs.testLibPath + "/empty";
                    requirejs.config({paths:paths});
                    requirejs([failedId], function () {
                    });
                }
            }

            //replace with empty module
            makeLoadable("tests/pro.specs");

            if (err.message) {
                console.error(err.message);
                if (err.requireModules){
                    for (var i in err.requireModules) {
                        if (!err.requireModules.hasOwnProperty(i)) continue;
                        console.log("Failed to load module: " + err.requireModules[i]);
                    }
                }
            }
        });

    });


});
