/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * @author inesterenko
 */

function PhantomJasmineRunner(page, exitFunc) {

    this.getStatus = function () {
        return page.evaluate(function () {
            return jasmine.__console_reporter_status__
        });
    };

    this.terminate = function () {
        switch (this.getStatus()) {
            case "success":
                exitFunc(0);
                break;
            case "fail":
                exitFunc(1);
                break;
            default:
                exitFunc(2);
        }
    };

}

function JUnitXmlReportWriter(page, filePath) {
    var fs = require("fs");

    this.getContent = function () {
        return page.evaluate(function () {
            return jasmine.__junit_xml_output__;
        });
    };

    this.save = function () {
        if (filePath){
            var content = this.getContent();
            if (!content) {
                console.log("Can't get a JUnitXml content from the page");
            } else {
                console.log("Save tests reports to " + filePath);
                fs.write(filePath, content, 'w');
            }
        }
    }
}

//Script Begin
if (phantom.args.length == 0) {
    console.log("Need a url as the argument");
    phantom.exit(1);
}

var page = require('webpage').create();
var runner = new PhantomJasmineRunner(page, phantom.exit);
var junitReportWriter = new JUnitXmlReportWriter(page, phantom.args[1]);

//Don't suppress console output
page.onConsoleMessage = function (msg) {
    console.log(msg);
    //Terminate when the reporter signals that testing is over.
    //We cannot use a callback function for this (because page.evaluate is sandboxed),
    // so we have to *observe* the website.
    if (msg == "ConsoleReporter finished") {
        junitReportWriter.save();
        runner.terminate();
    }
};

var address = phantom.args[0];

page.open(address, function (status) {
    if (status != "success") {
        console.log("can't load the address!");
        phantom.exit(1);
    }
    //Now we wait until onConsoleMessage reads the termination signal from the log.
});


/* Global block avoider -- to be sure this script will not block the Ant's execution for more than X seconds */
executeTimeSeconds = 20;
setTimeout(function(){
    console.log(" !! " + executeTimeSeconds + " seconds have gone and the program is still working. Doing emergency stop...");
    phantom.exit(1);
}, executeTimeSeconds * 1000);
