@REM
@REM    This batch file performs various file manipulations that are to
@REM    to be conducted after a buildomatic 'ant deploy-webapp-pro' for JBoss7
@REM
@REM    These are done separately from the ant scripts because
@REM    currently ant is experiencing difficulty being able to carry out
@REM    the file operstions
@REM

@REM    For now just hard code these


@REM  ----------------------------
@REM
@REM   YOU MUST SET THE VALUE OF FIXED_APP_SERVER_DIR to be your JBoss deployment root
@REM     this is the directory that contains subdirs  modules, standalone, etc.
@REM
@REM
@REM   YOU MUST SET THE JBOSS_VERSION TO EITHER:
@REM       set JBOSS_VERSION=jboss-as-7
@REM       set JBOSS_VERSION=jboss-eap-6
@REM
@REM


set FIXED_APP_SERVER_DIR=c:\JBoss-7.1.1

 @REM  set FIXED_APP_SERVER_DIR=C:\jboss-eap-6.0.1\jboss-eap-6.0

@REM set JBOSS_VERSION=jboss-as-7
@REM set JBOSS_VERSION=jboss-eap-6

set JBOSS_VERSION=jboss-as-7




set JS_DEPLOY_DIR=%FIXED_APP_SERVER_DIR%\
set BUILDOMATIC_DIR=g:\JS\trunk\buildomatic
set JS_WEBINF_LIB_DIR=%FIXED_APP_SERVER_DIR%\standalone\deployments\jasperserver-pro.war\WEB-INF\lib
set JS_METAINF_DIR=%FIXED_APP_SERVER_DIR%\standalone\deployments\jasperserver-pro.war\META-INF

set JBOSS7_MODULES_DIR=%FIXED_APP_SERVER_DIR%\modules

set BUILDOMATIC_JBOSS7_RESOURCES_DIR=%BUILDOMATIC_DIR%\install_resources\jboss7
set BUILDOMATIC_JBOSS7_MODULE_DESCRIPTORS_SOURCE=%BUILDOMATIC_JBOSS7_RESOURCES_DIR%\module_descriptors




@REM  COPY THE jboss-deployment-structure.xml config file !

copy %BUILDOMATIC_JBOSS7_RESOURCES_DIR%\jboss-deployment-structure.xml %JS_METAINF_DIR% /Y






@REM
@REM -----------------------------------------------------------------
@REM  Handle Deployment Wide Module Conflicts
@REM    see:  http://wiki/display/jaspermain/JBoss+7+Port+Specification


@REM   listed in roughly alphabetical order




@REM  Handle commons.logging

mkdir %JBOSS7_MODULES_DIR%\org\apache\commons\logging\1.0.4

copy %BUILDOMATIC_JBOSS7_MODULE_DESCRIPTORS_SOURCE%\module_org.apache.commons.logging-1.0.4.xml %JBOSS7_MODULES_DIR%\org\apache\commons\logging\1.0.4\module.xml /Y
copy %JS_WEBINF_LIB_DIR%\commons-logging-1.0.4.jar  %JBOSS7_MODULES_DIR%\org\apache\commons\logging\1.0.4 /Y
del  %JS_WEBINF_LIB_DIR%\commons-logging-1.0.4.jar



@REM  Handle jaxb API

mkdir %JBOSS7_MODULES_DIR%\javax\xml\bind\api\2.1

copy %BUILDOMATIC_JBOSS7_MODULE_DESCRIPTORS_SOURCE%\module_jaxb-api-2.1.xml %JBOSS7_MODULES_DIR%\javax\xml\bind\api\2.1\module.xml /Y
copy %JS_WEBINF_LIB_DIR%\jaxb-api-2.1.jar  %JBOSS7_MODULES_DIR%\javax\xml\bind\api\2.1 /Y
del  %JS_WEBINF_LIB_DIR%\jaxb-api-2.1.jar



@REM  Handle jaxb impl

mkdir %JBOSS7_MODULES_DIR%\com\sun\xml\bind\2.1.5

copy %BUILDOMATIC_JBOSS7_MODULE_DESCRIPTORS_SOURCE%\module_jaxb-impl-2.1.5.xml %JBOSS7_MODULES_DIR%\com\sun\xml\bind\2.1.5\module.xml /Y
copy %JS_WEBINF_LIB_DIR%\jaxb-impl-2.1.5.jar  %JBOSS7_MODULES_DIR%\com\sun\xml\bind\2.1.5 /Y
del  %JS_WEBINF_LIB_DIR%\jaxb-impl-2.1.5.jar
@REM  echo "TO DO  delete  the jaxb-impl-2.1.5.jar from the dir %JS_WEBINF_LIB_DIR%"




@REM  Handle jsf

set MOD_DIR=javax\faces\api\1.1
set JAR_NAME=jsf-api-1.1.jar
set CONFIG_NAME=module_jsf-api-1.1.xml

mkdir  %JBOSS7_MODULES_DIR%\%MOD_DIR%
copy   %BUILDOMATIC_JBOSS7_MODULE_DESCRIPTORS_SOURCE%\%CONFIG_NAME% %JBOSS7_MODULES_DIR%\%MOD_DIR%\module.xml /Y
copy %JS_WEBINF_LIB_DIR%\%JAR_NAME%  %JBOSS7_MODULES_DIR%\%MOD_DIR%  /Y
del   %JS_WEBINF_LIB_DIR%\%JAR_NAME%




@REM  Handle jstl

set MOD_DIR=javax\servlet\jstl\api\1.1.2
set JAR_NAME=jstl-1.1.2.jar
set CONFIG_NAME=module_jstl-1.1.2.xml

mkdir  %JBOSS7_MODULES_DIR%\%MOD_DIR%
copy   %BUILDOMATIC_JBOSS7_MODULE_DESCRIPTORS_SOURCE%\%CONFIG_NAME% %JBOSS7_MODULES_DIR%\%MOD_DIR%\module.xml /Y
copy %JS_WEBINF_LIB_DIR%\%JAR_NAME%  %JBOSS7_MODULES_DIR%\%MOD_DIR%  /Y
del   %JS_WEBINF_LIB_DIR%\%JAR_NAME%



@REM  Handle  log4j

mkdir %JBOSS7_MODULES_DIR%\org\apache\log4j\1.2.12

copy %BUILDOMATIC_JBOSS7_MODULE_DESCRIPTORS_SOURCE%\module_log4j-1.2.12.xml %JBOSS7_MODULES_DIR%\org\apache\log4j\1.2.12\module.xml /Y
copy %JS_WEBINF_LIB_DIR%\log4j-1.2.12.jar  %JBOSS7_MODULES_DIR%\org\apache\log4j\1.2.12  /Y
del  %JS_WEBINF_LIB_DIR%\log4j-1.2.12.jar


@REM  Handle stax

del %JS_WEBINF_LIB_DIR%\stax-api-1.0.1.jar




@REM
@REM -----------------------------------------------------------------
@REM END     Handle Deployment Wide Module Conflicts







@REM
@REM -----------------------------------------------------------------
@REM           Handle Fundamental 3rd party conflicts


@REM   THERE ARE NONE TO BE DONE.



@REM
@REM -----------------------------------------------------------------
@REM END       Handle Fundamental 3rd party conflicts




@REM
@REM -----------------------------------------------------------------
@REM           Remove jars from WEB-INF/lib that overlatp with JBoss


del  %JS_WEBINF_LIB_DIR%\slf4j-api-1.6.1.jar
del  %JS_WEBINF_LIB_DIR%\slf4j-log4j12-1.6.1.jar
del  %JS_WEBINF_LIB_DIR%\commons-io-1.1.jar
del  %JS_WEBINF_LIB_DIR%\serializer-2.7.1.jar
del  %JS_WEBINF_LIB_DIR%\xalan-2.7.1.jar
del  %JS_WEBINF_LIB_DIR%\xercesImpl-2.10.0.jar
del  %JS_WEBINF_LIB_DIR%\xml-apis-1.3.04.jar
del  %JS_WEBINF_LIB_DIR%\xml-apis-ext-1.3.04.jar


@REM
@REM -----------------------------------------------------------------
@REM END          Remove jars from WEB-INF/lib that overlatp with JBoss





