/*
 * Decompiled with CFR 0.152.
 */
package rescue;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.FileReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import rescue.JukeBox;
import rescue.MissionObject;
import rescue.RunRescue;
import rescue.panels.BigMapPanel;
import rescue.panels.ContainerPanel;
import rescue.panels.InterfacePanel;
import rescue.panels.ShipInfoPanel;
import rescue.panels.ShipsPanel;
import rescue.panels.SmallMapPanel;
import rescue.qdxml.DocHandler;
import rescue.qdxml.QDParser;
import rescue.spaceobjects.ImageObject;

public class MissionLoader
implements DocHandler {
    private Vector MissionObjects;
    private Vector MissionWindows;
    private Component bigmap;
    private String missionName;
    private RunRescue rescue;
    private Vector containers;
    private Vector panels;
    private MissionObject cmo;
    private ContainerPanel cmf;
    private InterfacePanel cip;
    private JToolBar ctb;
    private String path;
    private boolean cluster;
    private boolean external;
    private ShipsPanel shiplist;
    private ShipsPanel baselist;
    private ShipInfoPanel shipinfo;
    private JukeBox jukebox = new JukeBox();

    public MissionLoader(String string, RunRescue runRescue) throws Exception {
        this.rescue = runRescue;
        this.MissionObjects = new Vector();
        this.MissionWindows = new Vector();
        this.containers = new Vector();
        this.panels = new Vector();
        File file = new File(string);
        this.path = file.getParent();
        FileReader fileReader = new FileReader(file);
        QDParser.parse(this, fileReader);
        fileReader.close();
    }

    public ImageObject[] getSpaceObjects(Vector vector) throws Exception {
        int n;
        int n2 = 0;
        for (int i = 0; i < this.MissionObjects.size(); ++i) {
            n2 += ((MissionObject)this.MissionObjects.elementAt(i)).getNumber();
        }
        ImageObject[] imageObjectArray = new ImageObject[n2];
        n2 = 0;
        for (n = 0; n < this.MissionObjects.size(); ++n) {
            n2 = ((MissionObject)this.MissionObjects.elementAt(n)).makeSpaceObjects(imageObjectArray, this.cluster, n2, vector);
        }
        for (n = 0; n < this.MissionObjects.size(); ++n) {
            ((MissionObject)this.MissionObjects.elementAt(n)).setLikes(imageObjectArray);
        }
        this.jukebox.load();
        return imageObjectArray;
    }

    public boolean getExternal() {
        return this.external;
    }

    public void setExternal(boolean bl) {
        this.external = bl;
    }

    public String getMissionName() {
        return this.missionName;
    }

    public MissionObject getPlayerObject() {
        return this.cmo;
    }

    public Vector getMissionObjects() {
        return this.MissionObjects;
    }

    public Component getBigMap() {
        return this.bigmap;
    }

    public Vector getPanels() {
        return this.panels;
    }

    public Vector getWindows() {
        return this.MissionWindows;
    }

    public ShipsPanel getShipList() {
        return this.shiplist;
    }

    public ShipsPanel getBaseList() {
        return this.baselist;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String string, Hashtable hashtable) throws Exception {
        Object object;
        Object object2;
        int n = 0;
        if (string.equals("object")) {
            n = 1;
        } else if (string.equals("like")) {
            n = 2;
        } else if (string.equals("name")) {
            n = 3;
        } else if (string.equals("mission")) {
            n = 4;
        } else if (string.equals("options")) {
            n = 5;
        } else if (string.equals("preset")) {
            n = 6;
        } else if (string.equals("maxtotalenergy")) {
            n = 7;
        } else if (string.equals("maxphaserbanks")) {
            n = 8;
        } else if (string.equals("maxtorpedosleft")) {
            n = 9;
        } else if (string.equals("maxshieldpower")) {
            n = 10;
        } else if (string.equals("maxwarp")) {
            n = 11;
        } else if (string.equals("maximpulse")) {
            n = 12;
        } else if (string.equals("jump")) {
            n = 13;
        } else if (string.equals("turn")) {
            n = 14;
        } else if (string.equals("maxphaserintensity")) {
            n = 15;
        } else if (string.equals("maxtorpedosalvo")) {
            n = 16;
        } else if (string.equals("maxtractorpower")) {
            n = 17;
        } else if (string.equals("maxcloakpower")) {
            n = 18;
        } else if (string.equals("spaceObjects")) {
            n = 19;
        } else if (string.equals("container")) {
            n = 101;
        } else if (string.equals("toolbar")) {
            n = 102;
        } else if (string.equals("bigmap")) {
            n = 103;
        } else if (string.equals("button")) {
            n = 104;
        } else if (string.equals("separator")) {
            n = 105;
        } else if (string.equals("smallmap")) {
            n = 106;
        } else if (string.equals("text")) {
            n = 107;
        } else if (string.equals("shiplist")) {
            n = 108;
        } else if (string.equals("panel")) {
            n = 109;
        } else if (string.equals("image")) {
            n = 110;
        } else if (string.equals("color")) {
            n = 111;
        } else if (string.equals("infotext")) {
            n = 112;
        } else if (string.equals("infobar")) {
            n = 113;
        } else if (string.equals("baselist")) {
            n = 114;
        } else if (string.equals("shipinfo")) {
            n = 115;
        } else if (string.equals("guitheme")) {
            n = 116;
        } else if (string.equals("sound")) {
            n = 117;
        } else {
            if (!string.equals("names") && !string.equals("info") && !string.equals("likes") && !string.equals("sounds")) throw new Exception("unknown tag in xml file: " + string);
            return;
        }
        Enumeration enumeration = hashtable.keys();
        String[] stringArray = new String[hashtable.size()];
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            object = (String)hashtable.get(object2);
            if (n == 4) {
                if (!((String)object2).equals("name")) continue;
                stringArray[0] = object;
                continue;
            }
            if (n == 1) {
                if (((String)object2).equals("name")) {
                    stringArray[0] = object;
                    continue;
                }
                if (((String)object2).equals("image")) {
                    stringArray[1] = object;
                    continue;
                }
                if (((String)object2).equals("number")) {
                    stringArray[2] = object;
                    continue;
                }
                if (((String)object2).equals("type")) {
                    stringArray[3] = object;
                    continue;
                }
                if (((String)object2).equals("small")) {
                    stringArray[4] = object;
                    continue;
                }
                if (!((String)object2).equals("info")) continue;
                stringArray[5] = object;
                continue;
            }
            if (n == 2) {
                if (((String)object2).equals("who")) {
                    stringArray[0] = object;
                    continue;
                }
                if (!((String)object2).equals("amount")) continue;
                stringArray[1] = object;
                continue;
            }
            if (n == 3) {
                if (((String)object2).equals("value")) {
                    stringArray[0] = object;
                    continue;
                }
                if (!((String)object2).equals("image")) continue;
                stringArray[1] = object;
                continue;
            }
            if (n == 5) {
                if (((String)object2).equals("min")) {
                    stringArray[0] = object;
                    continue;
                }
                if (!((String)object2).equals("max")) continue;
                stringArray[1] = object;
                continue;
            }
            if (n == 6) {
                if (((String)object2).equals("name")) {
                    stringArray[0] = object;
                    continue;
                }
                if (!((String)object2).equals("value")) continue;
                stringArray[1] = object;
                continue;
            }
            if (n == 7 || n == 8 || n == 9 || n == 10 || n == 11 || n == 12 || n == 13 || n == 14 || n == 15 || n == 16 || n == 17 || n == 18) {
                if (!((String)object2).equals("value")) continue;
                stringArray[0] = object;
                continue;
            }
            if (n == 19) {
                if (!((String)object2).equals("cluster")) continue;
                stringArray[0] = object;
                continue;
            }
            if (n == 102 || n == 103 || n == 106 || n == 107 || n == 109 || n == 101 || n == 108 || n == 114 || n == 115) {
                if (((String)object2).equals("constraints")) {
                    stringArray[0] = object;
                    continue;
                }
                if (((String)object2).equals("name")) {
                    stringArray[0] = object;
                    continue;
                }
                if (((String)object2).equals("x")) {
                    stringArray[1] = object;
                    continue;
                }
                if (((String)object2).equals("y")) {
                    stringArray[2] = object;
                    continue;
                }
                if (((String)object2).equals("w")) {
                    stringArray[1] = object;
                    continue;
                }
                if (((String)object2).equals("h")) {
                    stringArray[2] = object;
                    continue;
                }
                if (((String)object2).equals("nob")) {
                    stringArray[1] = object;
                    continue;
                }
                if (((String)object2).equals("on")) {
                    stringArray[2] = object;
                    continue;
                }
                if (((String)object2).equals("off")) {
                    stringArray[3] = object;
                    continue;
                }
                if (((String)object2).equals("up")) {
                    stringArray[4] = object;
                    continue;
                }
                if (((String)object2).equals("down")) {
                    stringArray[5] = object;
                    continue;
                }
                if (!((String)object2).equals("map")) continue;
                stringArray[6] = object;
                continue;
            }
            if (n == 104) {
                if (((String)object2).equals("name")) {
                    stringArray[0] = object;
                    continue;
                }
                if (!((String)object2).equals("action")) continue;
                stringArray[1] = object;
                continue;
            }
            if (n == 110) {
                if (((String)object2).equals("on")) {
                    stringArray[0] = object;
                    continue;
                }
                if (((String)object2).equals("off")) {
                    stringArray[1] = object;
                    continue;
                }
                if (((String)object2).equals("up")) {
                    stringArray[2] = object;
                    continue;
                }
                if (((String)object2).equals("down")) {
                    stringArray[3] = object;
                    continue;
                }
                if (((String)object2).equals("map")) {
                    stringArray[4] = object;
                    continue;
                }
                if (!((String)object2).equals("nob")) continue;
                stringArray[5] = object;
                continue;
            }
            if (n == 111) {
                if (((String)object2).equals("value")) {
                    stringArray[0] = object;
                    continue;
                }
                if (((String)object2).equals("action")) {
                    stringArray[1] = object;
                    continue;
                }
                if (!((String)object2).equals("tooltip")) continue;
                stringArray[2] = object;
                continue;
            }
            if (n == 112) {
                if (((String)object2).equals("type")) {
                    stringArray[0] = object;
                    continue;
                }
                if (((String)object2).equals("x")) {
                    stringArray[1] = object;
                    continue;
                }
                if (((String)object2).equals("y")) {
                    stringArray[2] = object;
                    continue;
                }
                if (((String)object2).equals("w")) {
                    stringArray[3] = object;
                    continue;
                }
                if (((String)object2).equals("h")) {
                    stringArray[4] = object;
                    continue;
                }
                if (((String)object2).equals("lx")) {
                    stringArray[5] = object;
                    continue;
                }
                if (((String)object2).equals("ly")) {
                    stringArray[6] = object;
                    continue;
                }
                if (!((String)object2).equals("color")) continue;
                stringArray[7] = object;
                continue;
            }
            if (n == 113) {
                if (((String)object2).equals("type")) {
                    stringArray[0] = object;
                    continue;
                }
                if (((String)object2).equals("x")) {
                    stringArray[1] = object;
                    continue;
                }
                if (((String)object2).equals("y")) {
                    stringArray[2] = object;
                    continue;
                }
                if (((String)object2).equals("w")) {
                    stringArray[3] = object;
                    continue;
                }
                if (((String)object2).equals("h")) {
                    stringArray[4] = object;
                    continue;
                }
                if (!((String)object2).equals("direction")) continue;
                stringArray[5] = object;
                continue;
            }
            if (n == 116) {
                if (!((String)object2).equals("external")) continue;
                stringArray[0] = object;
                continue;
            }
            if (n != 117) continue;
            if (((String)object2).equals("name")) {
                stringArray[0] = object;
                continue;
            }
            if (!((String)object2).equals("file")) continue;
            stringArray[1] = object;
        }
        if (n == 4) {
            this.missionName = stringArray[0];
            return;
        } else if (n == 1) {
            this.cmo = new MissionObject(stringArray[0], this.path + "/" + stringArray[1], this.path + "/" + stringArray[4], stringArray.length == 6 ? this.path + "/" + stringArray[5] : null, stringArray[2], stringArray[3]);
            this.MissionObjects.add(this.cmo);
            return;
        } else if (n == 2) {
            this.cmo.addLike(stringArray[0], stringArray[1]);
            return;
        } else if (n == 3) {
            this.cmo.addName(stringArray[0], stringArray.length > 1 ? this.path + "/" + stringArray[1] : null);
            return;
        } else if (n == 5) {
            this.cmo.setMinMax(stringArray[0], stringArray[1]);
            return;
        } else if (n == 6) {
            this.cmo.setPreset(stringArray[0], stringArray[1]);
            return;
        } else if (n == 7) {
            this.cmo.setInfoMaxTotalEnergy(stringArray[0]);
            return;
        } else if (n == 8) {
            this.cmo.setInfoMaxPhaserBanks(stringArray[0]);
            return;
        } else if (n == 9) {
            this.cmo.setInfoMaxTorpedosLeft(stringArray[0]);
            return;
        } else if (n == 10) {
            this.cmo.setInfoMaxShieldPower(stringArray[0]);
            return;
        } else if (n == 11) {
            this.cmo.setInfoWarp(stringArray[0]);
            return;
        } else if (n == 12) {
            this.cmo.setInfoImpulse(stringArray[0]);
            return;
        } else if (n == 13) {
            this.cmo.setInfoJump(stringArray[0]);
            return;
        } else if (n == 14) {
            this.cmo.setInfoTurn(stringArray[0]);
            return;
        } else if (n == 15) {
            this.cmo.setInfoPhaser(stringArray[0]);
            return;
        } else if (n == 16) {
            this.cmo.setInfoTorpedos(stringArray[0]);
            return;
        } else if (n == 17) {
            this.cmo.setInfoTractor(stringArray[0]);
            return;
        } else if (n == 18) {
            this.cmo.setInfoCloak(stringArray[0]);
            return;
        } else if (n == 19) {
            if (stringArray[0].equals("yes")) {
                this.cluster = true;
                return;
            } else {
                if (!stringArray[0].equals("no")) throw new Exception("unexpected value for cluster: " + stringArray[0]);
                this.cluster = false;
            }
            return;
        } else if (n == 101) {
            if (this.cmf != null) {
                this.containers.add(this.cmf);
            }
            if (this.containers.isEmpty()) {
                this.cmf = new ContainerPanel(stringArray[0], stringArray[1], stringArray[2]);
                this.MissionWindows.add(this.cmf);
                return;
            } else {
                this.cmf = new ContainerPanel();
                ((ContainerPanel)this.containers.lastElement()).add((Component)this.cmf, stringArray[0]);
            }
            return;
        } else if (n == 102) {
            this.ctb = new JToolBar();
            this.ctb.setRollover(true);
            this.cmf.add((Component)this.ctb, stringArray[0]);
            return;
        } else if (n == 103) {
            this.bigmap = new BigMapPanel(this.rescue, Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]));
            this.cmf.add(this.bigmap, stringArray[0]);
            return;
        } else if (n == 106) {
            object2 = new SmallMapPanel(this.rescue, Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]));
            this.panels.add(object2);
            this.cmf.add((Component)object2, stringArray[0]);
            return;
        } else if (n == 109) {
            if (stringArray.length == 3) {
                this.cip = new InterfacePanel(this.rescue, Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]));
            } else {
                if (stringArray.length != 7) throw new Exception("abnormal number of parameters for panel creation.\nonly 3 or 7 is allowed");
                this.cip = new InterfacePanel(this.rescue);
                this.cip.setupImages(this.path + "/" + stringArray[2], this.path + "/" + stringArray[3], this.path + "/" + stringArray[4], this.path + "/" + stringArray[5], this.path + "/" + stringArray[6], Integer.parseInt(stringArray[1]));
            }
            this.panels.add(this.cip);
            this.cmf.add((Component)this.cip, stringArray[0]);
            return;
        } else if (n == 108) {
            this.shiplist = new ShipsPanel(this.rescue, Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), 1);
            this.panels.add(this.shiplist);
            this.cmf.add((Component)this.shiplist, stringArray[0]);
            return;
        } else if (n == 114) {
            this.baselist = new ShipsPanel(this.rescue, Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), 2);
            this.panels.add(this.baselist);
            this.cmf.add((Component)this.baselist, stringArray[0]);
            return;
        } else if (n == 104) {
            object2 = new JButton(stringArray[0]);
            ((AbstractButton)object2).setActionCommand(stringArray[1]);
            if (this.ctb == null) return;
            this.ctb.add((Component)object2);
            return;
        } else if (n == 105) {
            if (this.ctb == null) return;
            this.ctb.addSeparator();
            return;
        } else if (n == 107) {
            object2 = new JTextArea("Welcome to Rescue! Max");
            ((JComponent)object2).setBorder(null);
            ((JComponent)object2).setBackground(Color.BLACK);
            ((JComponent)object2).setForeground(Color.WHITE);
            object = new JScrollPane((Component)object2);
            ((JComponent)object).setBorder(null);
            Dimension dimension = new Dimension(Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]));
            ((JComponent)object).setPreferredSize(dimension);
            ((JComponent)object).setMinimumSize(dimension);
            ((JComponent)object).setMaximumSize(dimension);
            this.cmf.add((Component)object, stringArray[0]);
            return;
        } else if (n == 110) {
            this.cip.setupImages(this.path + "/" + stringArray[0], this.path + "/" + stringArray[1], this.path + "/" + stringArray[2], this.path + "/" + stringArray[3], this.path + "/" + stringArray[4], Integer.parseInt(stringArray[5]));
            return;
        } else if (n == 111) {
            this.cip.setCommandValue(stringArray[1], Integer.parseInt(stringArray[0]), stringArray.length > 2 ? stringArray[2] : null);
            return;
        } else if (n == 112) {
            this.cip.setInfoText(stringArray[0], Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]), Integer.parseInt(stringArray[4]), Integer.parseInt(stringArray[5]), Integer.parseInt(stringArray[6]), stringArray.length > 7 ? MissionLoader.getColor(stringArray[7]) : Color.BLACK);
            return;
        } else if (n == 113) {
            this.cip.setInfoBar(stringArray[0], Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]), Integer.parseInt(stringArray[4]), stringArray[5]);
            return;
        } else if (n == 115) {
            this.shipinfo = new ShipInfoPanel(Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), this.rescue);
            this.panels.add(this.shipinfo);
            this.cmf.add((Component)this.shipinfo, stringArray[0]);
            return;
        } else if (n == 116) {
            if (stringArray[0].equals("yes")) {
                this.external = true;
                return;
            } else {
                if (!stringArray[0].equals("no")) throw new Exception("unexpected value for external: " + stringArray[0]);
                this.external = false;
            }
            return;
        } else {
            if (n != 117) return;
            this.jukebox.setUpSound(stringArray[0], this.path + "/" + stringArray[1]);
        }
    }

    public void endElement(String string) {
        if (string.equals("container")) {
            this.cmf = null;
            if (!this.containers.isEmpty()) {
                this.cmf = (ContainerPanel)this.containers.lastElement();
                this.containers.remove(this.cmf);
            }
        } else if (string.equals("panel")) {
            this.cip = null;
        } else if (string.equals("toolbar")) {
            this.ctb = null;
        }
    }

    public void text(String string) {
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public boolean getCluster() {
        return this.cluster;
    }

    public void setCluster(boolean bl) {
        this.cluster = bl;
    }

    public ShipInfoPanel getShipInfoPanel() {
        return this.shipinfo;
    }

    public static Color getColor(String string) throws Exception {
        if (string.equals("black")) {
            return Color.BLACK;
        }
        if (string.equals("blue")) {
            return Color.BLUE;
        }
        if (string.equals("cyan")) {
            return Color.CYAN;
        }
        if (string.equals("darkgray")) {
            return Color.DARK_GRAY;
        }
        if (string.equals("gray")) {
            return Color.GRAY;
        }
        if (string.equals("green")) {
            return Color.GREEN;
        }
        if (string.equals("lightgray")) {
            return Color.LIGHT_GRAY;
        }
        if (string.equals("magenta")) {
            return Color.MAGENTA;
        }
        if (string.equals("orange")) {
            return Color.ORANGE;
        }
        if (string.equals("pink")) {
            return Color.PINK;
        }
        if (string.equals("red")) {
            return Color.RED;
        }
        if (string.equals("white")) {
            return Color.WHITE;
        }
        if (string.equals("yellow")) {
            return Color.YELLOW;
        }
        throw new Exception("unknown color " + string);
    }
}

