/*
 * Decompiled with CFR 0.152.
 */
package rescue.panels;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;
import rescue.JukeBox;
import rescue.RunRescue;
import rescue.spaceobjects.ImageObject;
import rescue.spaceobjects.Ship;

public class InterfacePanel
extends JPanel
implements MouseInputListener {
    private RunRescue rescue;
    private mapButton[] ButtonImages;
    private Vector infoTexts;
    private Vector infoBars;
    private int width;
    private int height;
    private int[][] map;
    private BufferedImage img;
    private BufferedImage imgON;
    private int cc;
    private int pp;
    private int tt;
    private int COMMAND_STOP = -1;
    private int COMMAND_STOP2 = -1;
    private int COMMAND_IMPULSE_AUTO = -1;
    private int COMMAND_IMPULSE_MAN = -1;
    private int COMMAND_IMPULSE_START = -1;
    private int COMMAND_IMPULSE_UP = -1;
    private int COMMAND_IMPULSE_DOWN = -1;
    private int COMMAND_WARP_AUTO = -1;
    private int COMMAND_WARP_MAN = -1;
    private int COMMAND_WARP_START = -1;
    private int COMMAND_WARP_UP = -1;
    private int COMMAND_WARP_DOWN = -1;
    private int COMMAND_PHASER_UP = -1;
    private int COMMAND_PHASER_DOWN = -1;
    private int COMMAND_PHASER_FIRE = -1;
    private int COMMAND_TORPEDO_UP = -1;
    private int COMMAND_TORPEDO_DOWN = -1;
    private int COMMAND_TORPEDO_FIRE = -1;
    private int COMMAND_SHIELDS_UP = -1;
    private int COMMAND_SHIELDS_DOWN = -1;
    private int COMMAND_TRACTOR = -1;
    private int COMMAND_TRACTOR_OFF = -1;
    private int COMMAND_ZOOMIN = -1;
    private int COMMAND_ZOOMOUT = -1;
    private int[] COMMAND_SELECT = new int[3];
    private int COMMAND_BEAM_DOWN = -1;
    private int COMMAND_BEAM_UP = -1;
    private int COMMAND_DOCK = -1;
    private int COMMAND_BOARD = -1;
    private int COMMAND_SCAN_UP = -1;
    private int COMMAND_SCAN_DOWN = -1;
    private int COMMAND_SHIPS_UP = -1;
    private int COMMAND_SHIPS_DOWN = -1;
    private int COMMAND_BASE_UP = -1;
    private int COMMAND_BASE_DOWN = -1;
    private int COMMAND_PAUSE = -1;
    private int COMMAND_HEADSUP = -1;
    private int COMMAND_RESERVE = -1;
    private int COMMAND_DIVERT = -1;
    private int COMMAND_EVASIVE_1 = -1;
    private int COMMAND_EVASIVE_2 = -1;
    private int COMMAND_EVASIVE_3 = -1;
    private int COMMAND_ENDGAME = -1;
    private int COMMAND_HELP = -1;
    private int COMMAND_QUIT = -1;
    private int[] COMMAND_TARGET = new int[11];
    private int[] COMMAND_FIX = new int[11];
    private int[] COMMAND_SHIPS_SORT = new int[2];
    private int[] COMMAND_BASE_SORT = new int[2];
    private int[] COMMAND_SHIPS_SHOW = new int[4];
    private int[] COMMAND_BASE_SHOW = new int[4];
    private int[] COMMAND_WARP_SPEED = new int[9];
    private int[] COMMAND_IMPULSE_SPEED = new int[4];
    private int[] COMMAND_PHASER_INTENSITY = new int[3];
    private int[] COMMAND_TORPEDO_SALVO = new int[3];
    private infoText INFOTEXT_MAN_IMPULSE;
    private infoText INFOTEXT_MAN_WARP;
    private infoText INFOTEXT_IMPULSE_SPEED;
    private infoText INFOTEXT_IMPULSE_AUTO;
    private infoText INFOTEXT_WARP_SPEED;
    private infoText INFOTEXT_WARP_AUTO;
    private infoText INFOTEXT_PHASER;
    private infoText INFOTEXT_TORPEDO;
    private infoText INFOTEXT_SHIELDS_UP;
    private infoText INFOTEXT_SHIELDS_POWER;
    private infoText INFOTEXT_TOTAL_POWER;
    private infoText INFOTEXT_PHASER_BANKS;
    private infoText INFOTEXT_TORPEDOS_LEFT;
    private infoText INFOTEXT_SYSTEM_WARPDRIVE;
    private infoText INFOTEXT_SYSTEM_IMPULSEDRIVE;
    private infoText INFOTEXT_SYSTEM_PHASERBANKS;
    private infoText INFOTEXT_SYSTEM_TORPEDOTUBES;
    private infoText INFOTEXT_SYSTEM_LONGRANGESCAN;
    private infoText INFOTEXT_SYSTEM_SENSORSCAN;
    private infoText INFOTEXT_SYSTEM_SHIELDS;
    private infoText INFOTEXT_SYSTEM_COMPUTER;
    private infoText INFOTEXT_SYSTEM_TRANSPORTERS;
    private infoText INFOTEXT_SYSTEM_TRACTORBEAM;
    private infoText INFOTEXT_OUTPOSTS_RESCUED;
    private infoText INFOTEXT_OUTPOSTS_DESTROYED;
    private infoText INFOTEXT_OUTPOSTS_REMAINING;
    private infoText INFOTEXT_OTHERSHIPS_FRIENDLIES;
    private infoText INFOTEXT_OTHERSHIPS_ENEMIES;
    private infoText INFOTEXT_OTHERSHIPS_DESTROYED;
    private infoText INFOTEXT_COLONIES_ONBOARD;
    private infoText INFOTEXT_NUMBER_AWAY_TEAMS;
    private infoText INFOTEXT_SCAN;
    private infoText INFOTEXT_CONDITION;
    private infoBar INFOBAR_TOTAL_POWER;
    private infoBar INFOBAR_PHASER_BANKS;
    private infoBar INFOBAR_TORPEDOS_LEFT;
    private infoBar INFOBAR_TRACTOR_BEAM;
    private infoBar INFOBAR_SHIELD_POWER;

    public InterfacePanel(RunRescue runRescue, int n, int n2) {
        this(runRescue);
        this.width = n;
        this.height = n2;
    }

    public InterfacePanel(RunRescue runRescue) {
        int n;
        this.rescue = runRescue;
        this.width = -1;
        this.height = -1;
        this.setLayout(null);
        this.cc = 255;
        this.pp = 255;
        this.tt = 255;
        this.infoTexts = new Vector();
        this.infoBars = new Vector();
        for (n = 0; n < this.COMMAND_SELECT.length; ++n) {
            this.COMMAND_SELECT[n] = -1;
        }
        for (n = 0; n < this.COMMAND_TARGET.length; ++n) {
            this.COMMAND_TARGET[n] = -1;
        }
        for (n = 0; n < this.COMMAND_FIX.length; ++n) {
            this.COMMAND_FIX[n] = -1;
        }
        for (n = 0; n < this.COMMAND_SHIPS_SORT.length; ++n) {
            this.COMMAND_SHIPS_SORT[n] = -1;
        }
        for (n = 0; n < this.COMMAND_SHIPS_SHOW.length; ++n) {
            this.COMMAND_SHIPS_SHOW[n] = -1;
        }
        for (n = 0; n < this.COMMAND_BASE_SORT.length; ++n) {
            this.COMMAND_BASE_SORT[n] = -1;
        }
        for (n = 0; n < this.COMMAND_BASE_SHOW.length; ++n) {
            this.COMMAND_BASE_SHOW[n] = -1;
        }
        for (n = 0; n < this.COMMAND_WARP_SPEED.length; ++n) {
            this.COMMAND_WARP_SPEED[n] = -1;
        }
        for (n = 0; n < this.COMMAND_IMPULSE_SPEED.length; ++n) {
            this.COMMAND_IMPULSE_SPEED[n] = -1;
        }
        for (n = 0; n < this.COMMAND_PHASER_INTENSITY.length; ++n) {
            this.COMMAND_PHASER_INTENSITY[n] = -1;
        }
        for (n = 0; n < this.COMMAND_TORPEDO_SALVO.length; ++n) {
            this.COMMAND_TORPEDO_SALVO[n] = -1;
        }
        this.map = null;
    }

    public void setupImages(String string, String string2, String string3, String string4, String string5, int n) throws Exception {
        BufferedImage bufferedImage;
        BufferedImage bufferedImage2 = ImageIO.read(new File(string));
        if (this.width != -1 && bufferedImage2.getWidth() != this.width || this.height != -1 && bufferedImage2.getHeight() != this.height) {
            throw new Exception("image \"" + string + "\" does not mach panel size");
        }
        this.width = bufferedImage2.getWidth();
        this.height = bufferedImage2.getHeight();
        Dimension dimension = new Dimension(this.width, this.height);
        this.setPreferredSize(dimension);
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
        this.img = bufferedImage = ImageIO.read(new File(string2));
        this.imgON = bufferedImage2;
        if (n > 0) {
            int n2;
            int n3;
            int n4;
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            BufferedImage bufferedImage3 = ImageIO.read(new File(string3));
            BufferedImage bufferedImage4 = ImageIO.read(new File(string4));
            BufferedImage bufferedImage5 = ImageIO.read(new File(string5));
            int n5 = new Color(0, 0, 0, 0).getRGB();
            int n6 = bufferedImage5.getWidth();
            int n7 = bufferedImage5.getHeight();
            this.map = new int[n6][n7];
            this.ButtonImages = new mapButton[n];
            for (n4 = 0; n4 < n; ++n4) {
                this.ButtonImages[n4] = new mapButton(n6, n7);
            }
            for (n4 = 0; n4 < n7; ++n4) {
                for (n3 = 0; n3 < n6; ++n3) {
                    n2 = bufferedImage5.getRGB(n3, n4) & 0xFF;
                    if (n2 < n) {
                        this.map[n3][n4] = n2;
                        if (n3 < this.ButtonImages[n2].getX1()) {
                            this.ButtonImages[n2].setX1(n3);
                        }
                        if (n3 > this.ButtonImages[n2].getX2()) {
                            this.ButtonImages[n2].setX2(n3);
                        }
                        if (n4 < this.ButtonImages[n2].getY1()) {
                            this.ButtonImages[n2].setY1(n4);
                        }
                        if (n4 <= this.ButtonImages[n2].getY2()) continue;
                        this.ButtonImages[n2].setY2(n4);
                        continue;
                    }
                    this.map[n3][n4] = 255;
                }
            }
            for (n4 = 0; n4 < this.ButtonImages.length; ++n4) {
                n3 = this.ButtonImages[n4].getX1();
                n2 = this.ButtonImages[n4].getX2();
                int n8 = this.ButtonImages[n4].getY1();
                int n9 = this.ButtonImages[n4].getY2();
                int n10 = this.ButtonImages[n4].getWidth();
                int n11 = this.ButtonImages[n4].getHeight();
                BufferedImage bufferedImage6 = new BufferedImage(n10, n11, 2);
                bufferedImage6.getGraphics().drawImage(bufferedImage.getSubimage(n3, n8, n10, n11), 0, 0, this);
                BufferedImage bufferedImage7 = new BufferedImage(n10, n11, 2);
                bufferedImage7.getGraphics().drawImage(bufferedImage2.getSubimage(n3, n8, n10, n11), 0, 0, this);
                BufferedImage bufferedImage8 = new BufferedImage(n10, n11, 2);
                bufferedImage8.getGraphics().drawImage(bufferedImage3.getSubimage(n3, n8, n10, n11), 0, 0, this);
                BufferedImage bufferedImage9 = new BufferedImage(n10, n11, 2);
                bufferedImage9.getGraphics().drawImage(bufferedImage4.getSubimage(n3, n8, n10, n11), 0, 0, this);
                this.ButtonImages[n4].setOffImage(bufferedImage6);
                this.ButtonImages[n4].setOnImage(bufferedImage7);
                this.ButtonImages[n4].setUpImage(bufferedImage8);
                this.ButtonImages[n4].setDownImage(bufferedImage9);
                for (int i = n8; i <= n9; ++i) {
                    for (int j = 0; j <= n10 - 1; ++j) {
                        if (this.map[j + n3][i] == n4) continue;
                        bufferedImage6.setRGB(j, i - n8, n5);
                        bufferedImage7.setRGB(j, i - n8, n5);
                        bufferedImage8.setRGB(j, i - n8, n5);
                        bufferedImage9.setRGB(j, i - n8, n5);
                    }
                }
            }
        }
    }

    public void setCommandValue(String string, int n, String string2) throws Exception {
        if (string.equals("impulse_auto")) {
            this.COMMAND_IMPULSE_AUTO = n;
        } else if (string.equals("impulse_man")) {
            this.COMMAND_IMPULSE_MAN = n;
        } else if (string.equals("impulse_start")) {
            this.COMMAND_IMPULSE_START = n;
        } else if (string.equals("stop")) {
            this.COMMAND_STOP = n;
        } else if (string.equals("stop2")) {
            this.COMMAND_STOP2 = n;
        } else if (string.equals("impulse_up")) {
            this.COMMAND_IMPULSE_UP = n;
        } else if (string.equals("impulse_down")) {
            this.COMMAND_IMPULSE_DOWN = n;
        } else if (string.equals("warp_auto")) {
            this.COMMAND_WARP_AUTO = n;
        } else if (string.equals("warp_man")) {
            this.COMMAND_WARP_MAN = n;
        } else if (string.equals("warp_start")) {
            this.COMMAND_WARP_START = n;
        } else if (string.equals("warp_up")) {
            this.COMMAND_WARP_UP = n;
        } else if (string.equals("warp_down")) {
            this.COMMAND_WARP_DOWN = n;
        } else if (string.equals("phaser_up")) {
            this.COMMAND_PHASER_UP = n;
        } else if (string.equals("phaser_down")) {
            this.COMMAND_PHASER_DOWN = n;
        } else if (string.equals("phaser_fire")) {
            this.COMMAND_PHASER_FIRE = n;
        } else if (string.equals("torpedo_up")) {
            this.COMMAND_TORPEDO_UP = n;
        } else if (string.equals("torpedo_down")) {
            this.COMMAND_TORPEDO_DOWN = n;
        } else if (string.equals("torpedo_fire")) {
            this.COMMAND_TORPEDO_FIRE = n;
        } else if (string.equals("shields_up")) {
            this.COMMAND_SHIELDS_UP = n;
        } else if (string.equals("shields_down")) {
            this.COMMAND_SHIELDS_DOWN = n;
        } else if (string.equals("tractor")) {
            this.COMMAND_TRACTOR = n;
        } else if (string.equals("tractor_off")) {
            this.COMMAND_TRACTOR_OFF = n;
        } else if (string.equals("zoomin")) {
            this.COMMAND_ZOOMIN = n;
        } else if (string.equals("zoomout")) {
            this.COMMAND_ZOOMOUT = n;
        } else if (string.equals("select_all")) {
            this.COMMAND_SELECT[0] = n;
        } else if (string.equals("select_enemies")) {
            this.COMMAND_SELECT[1] = n;
        } else if (string.equals("select_manual")) {
            this.COMMAND_SELECT[2] = n;
        } else if (string.equals("beam_down")) {
            this.COMMAND_BEAM_DOWN = n;
        } else if (string.equals("beam_up")) {
            this.COMMAND_BEAM_UP = n;
        } else if (string.equals("dock")) {
            this.COMMAND_DOCK = n;
        } else if (string.equals("board")) {
            this.COMMAND_BOARD = n;
        } else if (string.equals("scan_up")) {
            this.COMMAND_SCAN_UP = n;
        } else if (string.equals("scan_down")) {
            this.COMMAND_SCAN_DOWN = n;
        } else if (string.equals("ships_up")) {
            this.COMMAND_SHIPS_UP = n;
        } else if (string.equals("ships_down")) {
            this.COMMAND_SHIPS_DOWN = n;
        } else if (string.equals("base_up")) {
            this.COMMAND_BASE_UP = n;
        } else if (string.equals("base_down")) {
            this.COMMAND_BASE_DOWN = n;
        } else if (string.equals("pause")) {
            this.COMMAND_PAUSE = n;
        } else if (string.equals("headsup")) {
            this.COMMAND_HEADSUP = n;
        } else if (string.equals("reserve")) {
            this.COMMAND_RESERVE = n;
        } else if (string.equals("divert")) {
            this.COMMAND_DIVERT = n;
        } else if (string.equals("evasive 1")) {
            this.COMMAND_EVASIVE_1 = n;
        } else if (string.equals("evasive 2")) {
            this.COMMAND_EVASIVE_2 = n;
        } else if (string.equals("evasive 3")) {
            this.COMMAND_EVASIVE_3 = n;
        } else if (string.equals("endgame")) {
            this.COMMAND_ENDGAME = n;
        } else if (string.equals("quit")) {
            this.COMMAND_QUIT = n;
        } else if (string.equals("help")) {
            this.COMMAND_HELP = n;
        } else if (string.startsWith("ships_sort")) {
            this.COMMAND_SHIPS_SORT[Integer.parseInt((String)string.substring((int)11))] = n;
        } else if (string.startsWith("base_sort")) {
            this.COMMAND_BASE_SORT[Integer.parseInt((String)string.substring((int)10))] = n;
        } else if (string.startsWith("ships_show")) {
            this.COMMAND_SHIPS_SHOW[Integer.parseInt((String)string.substring((int)11))] = n;
        } else if (string.startsWith("base_show")) {
            this.COMMAND_BASE_SHOW[Integer.parseInt((String)string.substring((int)10))] = n;
        } else if (string.startsWith("target")) {
            this.COMMAND_TARGET[Integer.parseInt((String)string.substring((int)7))] = n;
        } else if (string.startsWith("fix")) {
            this.COMMAND_FIX[Integer.parseInt((String)string.substring((int)4))] = n;
        } else if (string.startsWith("warp_speed")) {
            this.COMMAND_WARP_SPEED[Integer.parseInt((String)string.substring((int)11)) - 1] = n;
        } else if (string.startsWith("impulse_speed")) {
            this.COMMAND_IMPULSE_SPEED[Integer.parseInt((String)string.substring((int)14)) - 1] = n;
        } else if (string.startsWith("phaser_intensity")) {
            this.COMMAND_PHASER_INTENSITY[Integer.parseInt((String)string.substring((int)17)) - 1] = n;
        } else if (string.startsWith("torpedo_salvo")) {
            this.COMMAND_TORPEDO_SALVO[Integer.parseInt((String)string.substring((int)14)) - 1] = n;
        } else {
            throw new Exception("unknown command " + string);
        }
        this.ButtonImages[n].setToolTip(string2);
    }

    public void setInfoText(String string, int n, int n2, int n3, int n4, int n5, int n6, Color color) throws Exception {
        BufferedImage bufferedImage = this.img.getSubimage(n, n2, n3, n4);
        infoText infoText2 = new infoText(bufferedImage, n, n2, n5, n6, color);
        this.infoTexts.add(infoText2);
        if (string.equals("impulse_speed")) {
            this.INFOTEXT_IMPULSE_SPEED = infoText2;
        } else if (string.equals("impulse_auto")) {
            this.INFOTEXT_IMPULSE_AUTO = infoText2;
        } else if (string.equals("warp_speed")) {
            this.INFOTEXT_WARP_SPEED = infoText2;
        } else if (string.equals("warp_auto")) {
            this.INFOTEXT_WARP_AUTO = infoText2;
        } else if (string.equals("phaser")) {
            this.INFOTEXT_PHASER = infoText2;
        } else if (string.equals("torpedo")) {
            this.INFOTEXT_TORPEDO = infoText2;
        } else if (string.equals("shields_up")) {
            this.INFOTEXT_SHIELDS_UP = infoText2;
        } else if (string.equals("shields_power")) {
            this.INFOTEXT_SHIELDS_POWER = infoText2;
        } else if (string.equals("total_energy")) {
            this.INFOTEXT_TOTAL_POWER = infoText2;
        } else if (string.equals("phaser_banks")) {
            this.INFOTEXT_PHASER_BANKS = infoText2;
        } else if (string.equals("torpedos_left")) {
            this.INFOTEXT_TORPEDOS_LEFT = infoText2;
        } else if (string.equals("system_warpdrive")) {
            this.INFOTEXT_SYSTEM_WARPDRIVE = infoText2;
        } else if (string.equals("system_impulsedrive")) {
            this.INFOTEXT_SYSTEM_IMPULSEDRIVE = infoText2;
        } else if (string.equals("system_phaserbanks")) {
            this.INFOTEXT_SYSTEM_PHASERBANKS = infoText2;
        } else if (string.equals("system_torpedotubes")) {
            this.INFOTEXT_SYSTEM_TORPEDOTUBES = infoText2;
        } else if (string.equals("system_longrangescan")) {
            this.INFOTEXT_SYSTEM_LONGRANGESCAN = infoText2;
        } else if (string.equals("system_sencorscan")) {
            this.INFOTEXT_SYSTEM_SENSORSCAN = infoText2;
        } else if (string.equals("system_shields")) {
            this.INFOTEXT_SYSTEM_SHIELDS = infoText2;
        } else if (string.equals("system_computer")) {
            this.INFOTEXT_SYSTEM_COMPUTER = infoText2;
        } else if (string.equals("system_transporters")) {
            this.INFOTEXT_SYSTEM_TRANSPORTERS = infoText2;
        } else if (string.equals("system_tractorbeam")) {
            this.INFOTEXT_SYSTEM_TRACTORBEAM = infoText2;
        } else if (string.equals("outposts_rescued")) {
            this.INFOTEXT_OUTPOSTS_RESCUED = infoText2;
        } else if (string.equals("outposts_destroyed")) {
            this.INFOTEXT_OUTPOSTS_DESTROYED = infoText2;
        } else if (string.equals("outposts_remaining")) {
            this.INFOTEXT_OUTPOSTS_REMAINING = infoText2;
        } else if (string.equals("otherships_friendlies")) {
            this.INFOTEXT_OTHERSHIPS_FRIENDLIES = infoText2;
        } else if (string.equals("otherships_enemies")) {
            this.INFOTEXT_OTHERSHIPS_ENEMIES = infoText2;
        } else if (string.equals("otherships_destroyed")) {
            this.INFOTEXT_OTHERSHIPS_DESTROYED = infoText2;
        } else if (string.equals("colonies_onboard")) {
            this.INFOTEXT_COLONIES_ONBOARD = infoText2;
        } else if (string.equals("number_away_teams")) {
            this.INFOTEXT_NUMBER_AWAY_TEAMS = infoText2;
        } else if (string.equals("scan")) {
            this.INFOTEXT_SCAN = infoText2;
        } else if (string.equals("condition")) {
            this.INFOTEXT_CONDITION = infoText2;
        } else if (string.equals("man_impulse")) {
            this.INFOTEXT_MAN_IMPULSE = infoText2;
        } else if (string.equals("man_warp")) {
            this.INFOTEXT_MAN_WARP = infoText2;
        } else {
            throw new Exception("unknown infotext " + string);
        }
    }

    public void setInfoBar(String string, int n, int n2, int n3, int n4, String string2) throws Exception {
        BufferedImage bufferedImage = this.img.getSubimage(n, n2, n3, n4);
        BufferedImage bufferedImage2 = this.imgON.getSubimage(n, n2, n3, n4);
        infoBar infoBar2 = new infoBar(bufferedImage, bufferedImage2, n, n2, string2);
        this.infoBars.add(infoBar2);
        if (string.equals("total_energy")) {
            this.INFOBAR_TOTAL_POWER = infoBar2;
        } else if (string.equals("phaser_banks")) {
            this.INFOBAR_PHASER_BANKS = infoBar2;
        } else if (string.equals("torpedos_left")) {
            this.INFOBAR_TORPEDOS_LEFT = infoBar2;
        } else if (string.equals("tractor_beam")) {
            this.INFOBAR_TRACTOR_BEAM = infoBar2;
        } else if (string.equals("shield_power")) {
            this.INFOBAR_SHIELD_POWER = infoBar2;
        } else {
            throw new Exception("unknown infobar " + string);
        }
    }

    public void list() {
        int n;
        int n2;
        Ship ship = this.rescue.getShip();
        Graphics graphics = this.getGraphics();
        if (this.COMMAND_IMPULSE_AUTO != -1 && this.ButtonImages[this.COMMAND_IMPULSE_AUTO].checkOn(ship.getAutoImpulseOn())) {
            this.ButtonImages[this.COMMAND_IMPULSE_MAN].checkOn(!this.ButtonImages[this.COMMAND_IMPULSE_AUTO].getOn());
            graphics.drawImage(this.ButtonImages[this.COMMAND_IMPULSE_AUTO].getOffImage(), this.ButtonImages[this.COMMAND_IMPULSE_AUTO].getX1(), this.ButtonImages[this.COMMAND_IMPULSE_AUTO].getY1(), this);
            graphics.drawImage(this.ButtonImages[this.COMMAND_IMPULSE_MAN].getOffImage(), this.ButtonImages[this.COMMAND_IMPULSE_MAN].getX1(), this.ButtonImages[this.COMMAND_IMPULSE_MAN].getY1(), this);
        }
        if (this.COMMAND_WARP_AUTO != -1 && this.ButtonImages[this.COMMAND_WARP_AUTO].checkOn(ship.getAutoWarpOn())) {
            this.ButtonImages[this.COMMAND_WARP_MAN].checkOn(!this.ButtonImages[this.COMMAND_WARP_AUTO].getOn());
            graphics.drawImage(this.ButtonImages[this.COMMAND_WARP_AUTO].getOffImage(), this.ButtonImages[this.COMMAND_WARP_AUTO].getX1(), this.ButtonImages[this.COMMAND_WARP_AUTO].getY1(), this);
            graphics.drawImage(this.ButtonImages[this.COMMAND_WARP_MAN].getOffImage(), this.ButtonImages[this.COMMAND_WARP_MAN].getX1(), this.ButtonImages[this.COMMAND_WARP_MAN].getY1(), this);
        }
        if (this.COMMAND_TRACTOR_OFF != -1 && this.ButtonImages[this.COMMAND_TRACTOR_OFF].checkOn(ship.getTractoredShip() == null)) {
            this.ButtonImages[this.COMMAND_TRACTOR].checkOn(!this.ButtonImages[this.COMMAND_TRACTOR_OFF].getOn());
            graphics.drawImage(this.ButtonImages[this.COMMAND_TRACTOR_OFF].getOffImage(), this.ButtonImages[this.COMMAND_TRACTOR_OFF].getX1(), this.ButtonImages[this.COMMAND_TRACTOR_OFF].getY1(), this);
            graphics.drawImage(this.ButtonImages[this.COMMAND_TRACTOR].getOffImage(), this.ButtonImages[this.COMMAND_TRACTOR].getX1(), this.ButtonImages[this.COMMAND_TRACTOR].getY1(), this);
        }
        if (this.COMMAND_SHIELDS_UP != -1 && this.ButtonImages[this.COMMAND_SHIELDS_UP].checkOn(ship.getShieldsUp())) {
            graphics.drawImage(this.ButtonImages[this.COMMAND_SHIELDS_UP].getOffImage(), this.ButtonImages[this.COMMAND_SHIELDS_UP].getX1(), this.ButtonImages[this.COMMAND_SHIELDS_UP].getY1(), this);
        }
        if (this.COMMAND_SHIELDS_DOWN != -1 && this.ButtonImages[this.COMMAND_SHIELDS_DOWN].checkOn(!ship.getShieldsUp())) {
            graphics.drawImage(this.ButtonImages[this.COMMAND_SHIELDS_DOWN].getOffImage(), this.ButtonImages[this.COMMAND_SHIELDS_DOWN].getX1(), this.ButtonImages[this.COMMAND_SHIELDS_DOWN].getY1(), this);
        }
        if (this.COMMAND_IMPULSE_START != -1 && this.ButtonImages[this.COMMAND_IMPULSE_START].checkOn(ship.getImpulseOn())) {
            graphics.drawImage(this.ButtonImages[this.COMMAND_IMPULSE_START].getOffImage(), this.ButtonImages[this.COMMAND_IMPULSE_START].getX1(), this.ButtonImages[this.COMMAND_IMPULSE_START].getY1(), this);
        }
        if (this.COMMAND_WARP_START != -1 && this.ButtonImages[this.COMMAND_WARP_START].checkOn(ship.getWarpOn())) {
            graphics.drawImage(this.ButtonImages[this.COMMAND_WARP_START].getOffImage(), this.ButtonImages[this.COMMAND_WARP_START].getX1(), this.ButtonImages[this.COMMAND_WARP_START].getY1(), this);
        }
        if (this.COMMAND_ZOOMIN != -1 && this.ButtonImages[this.COMMAND_ZOOMIN].checkOn(!this.rescue.canZoom(true))) {
            graphics.drawImage(this.ButtonImages[this.COMMAND_ZOOMIN].getOffImage(), this.ButtonImages[this.COMMAND_ZOOMIN].getX1(), this.ButtonImages[this.COMMAND_ZOOMIN].getY1(), this);
        }
        if (this.COMMAND_ZOOMOUT != -1 && this.ButtonImages[this.COMMAND_ZOOMOUT].checkOn(!this.rescue.canZoom(false))) {
            graphics.drawImage(this.ButtonImages[this.COMMAND_ZOOMOUT].getOffImage(), this.ButtonImages[this.COMMAND_ZOOMOUT].getX1(), this.ButtonImages[this.COMMAND_ZOOMOUT].getY1(), this);
        }
        if (this.COMMAND_SHIPS_UP != -1 && this.ButtonImages[this.COMMAND_SHIPS_UP].checkOn(!this.rescue.canScrollShips(true, true))) {
            graphics.drawImage(this.ButtonImages[this.COMMAND_SHIPS_UP].getOffImage(), this.ButtonImages[this.COMMAND_SHIPS_UP].getX1(), this.ButtonImages[this.COMMAND_SHIPS_UP].getY1(), this);
        }
        if (this.COMMAND_SHIPS_DOWN != -1 && this.ButtonImages[this.COMMAND_SHIPS_DOWN].checkOn(!this.rescue.canScrollShips(true, false))) {
            graphics.drawImage(this.ButtonImages[this.COMMAND_SHIPS_DOWN].getOffImage(), this.ButtonImages[this.COMMAND_SHIPS_DOWN].getX1(), this.ButtonImages[this.COMMAND_SHIPS_DOWN].getY1(), this);
        }
        if (this.COMMAND_BASE_UP != -1 && this.ButtonImages[this.COMMAND_BASE_UP].checkOn(!this.rescue.canScrollShips(false, true))) {
            graphics.drawImage(this.ButtonImages[this.COMMAND_BASE_UP].getOffImage(), this.ButtonImages[this.COMMAND_BASE_UP].getX1(), this.ButtonImages[this.COMMAND_BASE_UP].getY1(), this);
        }
        if (this.COMMAND_BASE_DOWN != -1 && this.ButtonImages[this.COMMAND_BASE_DOWN].checkOn(!this.rescue.canScrollShips(false, false))) {
            graphics.drawImage(this.ButtonImages[this.COMMAND_BASE_DOWN].getOffImage(), this.ButtonImages[this.COMMAND_BASE_DOWN].getX1(), this.ButtonImages[this.COMMAND_BASE_DOWN].getY1(), this);
        }
        if (this.COMMAND_SELECT[0] != -1 && this.ButtonImages[this.COMMAND_SELECT[n2 = this.rescue.getSelect()]].checkOn(true)) {
            graphics.drawImage(this.ButtonImages[this.COMMAND_SELECT[n2]].getOffImage(), this.ButtonImages[this.COMMAND_SELECT[n2]].getX1(), this.ButtonImages[this.COMMAND_SELECT[n2]].getY1(), this);
            for (n = 0; n < this.COMMAND_SELECT.length; ++n) {
                if (n == n2 || !this.ButtonImages[this.COMMAND_SELECT[n]].checkOn(false)) continue;
                graphics.drawImage(this.ButtonImages[this.COMMAND_SELECT[n]].getOffImage(), this.ButtonImages[this.COMMAND_SELECT[n]].getX1(), this.ButtonImages[this.COMMAND_SELECT[n]].getY1(), this);
                break;
            }
        }
        if (this.COMMAND_SHIPS_SORT[0] != -1 && this.ButtonImages[this.COMMAND_SHIPS_SORT[n2 = this.rescue.getShipsSort()]].checkOn(true)) {
            graphics.drawImage(this.ButtonImages[this.COMMAND_SHIPS_SORT[n2]].getOffImage(), this.ButtonImages[this.COMMAND_SHIPS_SORT[n2]].getX1(), this.ButtonImages[this.COMMAND_SHIPS_SORT[n2]].getY1(), this);
            for (n = 0; n < this.COMMAND_SHIPS_SORT.length; ++n) {
                if (n == n2 || !this.ButtonImages[this.COMMAND_SHIPS_SORT[n]].checkOn(false)) continue;
                graphics.drawImage(this.ButtonImages[this.COMMAND_SHIPS_SORT[n]].getOffImage(), this.ButtonImages[this.COMMAND_SHIPS_SORT[n]].getX1(), this.ButtonImages[this.COMMAND_SHIPS_SORT[n]].getY1(), this);
                break;
            }
        }
        if (this.COMMAND_BASE_SORT[0] != -1 && this.ButtonImages[this.COMMAND_BASE_SORT[n2 = this.rescue.getBaseSort()]].checkOn(true)) {
            graphics.drawImage(this.ButtonImages[this.COMMAND_BASE_SORT[n2]].getOffImage(), this.ButtonImages[this.COMMAND_BASE_SORT[n2]].getX1(), this.ButtonImages[this.COMMAND_BASE_SORT[n2]].getY1(), this);
            for (n = 0; n < this.COMMAND_BASE_SORT.length; ++n) {
                if (n == n2 || !this.ButtonImages[this.COMMAND_BASE_SORT[n]].checkOn(false)) continue;
                graphics.drawImage(this.ButtonImages[this.COMMAND_BASE_SORT[n]].getOffImage(), this.ButtonImages[this.COMMAND_BASE_SORT[n]].getX1(), this.ButtonImages[this.COMMAND_BASE_SORT[n]].getY1(), this);
                break;
            }
        }
        if (this.COMMAND_SHIPS_SHOW[0] != -1 && this.ButtonImages[this.COMMAND_SHIPS_SHOW[n2 = this.rescue.getShipsShow()]].checkOn(true)) {
            graphics.drawImage(this.ButtonImages[this.COMMAND_SHIPS_SHOW[n2]].getOffImage(), this.ButtonImages[this.COMMAND_SHIPS_SHOW[n2]].getX1(), this.ButtonImages[this.COMMAND_SHIPS_SHOW[n2]].getY1(), this);
            for (n = 0; n < this.COMMAND_SHIPS_SHOW.length; ++n) {
                if (n == n2 || !this.ButtonImages[this.COMMAND_SHIPS_SHOW[n]].checkOn(false)) continue;
                graphics.drawImage(this.ButtonImages[this.COMMAND_SHIPS_SHOW[n]].getOffImage(), this.ButtonImages[this.COMMAND_SHIPS_SHOW[n]].getX1(), this.ButtonImages[this.COMMAND_SHIPS_SHOW[n]].getY1(), this);
                break;
            }
        }
        if (this.COMMAND_BASE_SHOW[0] != -1 && this.ButtonImages[this.COMMAND_BASE_SHOW[n2 = this.rescue.getBaseShow()]].checkOn(true)) {
            graphics.drawImage(this.ButtonImages[this.COMMAND_BASE_SHOW[n2]].getOffImage(), this.ButtonImages[this.COMMAND_BASE_SHOW[n2]].getX1(), this.ButtonImages[this.COMMAND_BASE_SHOW[n2]].getY1(), this);
            for (n = 0; n < this.COMMAND_BASE_SHOW.length; ++n) {
                if (n == n2 || !this.ButtonImages[this.COMMAND_BASE_SHOW[n]].checkOn(false)) continue;
                graphics.drawImage(this.ButtonImages[this.COMMAND_BASE_SHOW[n]].getOffImage(), this.ButtonImages[this.COMMAND_BASE_SHOW[n]].getX1(), this.ButtonImages[this.COMMAND_BASE_SHOW[n]].getY1(), this);
                break;
            }
        }
        if (this.COMMAND_TARGET[0] != -1 && this.ButtonImages[this.COMMAND_TARGET[n2 = ship.getTarget()]].checkOn(true)) {
            graphics.drawImage(this.ButtonImages[this.COMMAND_TARGET[n2]].getOffImage(), this.ButtonImages[this.COMMAND_TARGET[n2]].getX1(), this.ButtonImages[this.COMMAND_TARGET[n2]].getY1(), this);
            for (n = 0; n < this.COMMAND_TARGET.length; ++n) {
                if (n == n2 || !this.ButtonImages[this.COMMAND_TARGET[n]].checkOn(false)) continue;
                graphics.drawImage(this.ButtonImages[this.COMMAND_TARGET[n]].getOffImage(), this.ButtonImages[this.COMMAND_TARGET[n]].getX1(), this.ButtonImages[this.COMMAND_TARGET[n]].getY1(), this);
                break;
            }
        }
        if (this.COMMAND_FIX[0] != -1 && this.ButtonImages[this.COMMAND_FIX[n2 = ship.getFixPriority()]].checkOn(true)) {
            graphics.drawImage(this.ButtonImages[this.COMMAND_FIX[n2]].getOffImage(), this.ButtonImages[this.COMMAND_FIX[n2]].getX1(), this.ButtonImages[this.COMMAND_FIX[n2]].getY1(), this);
            for (n = 0; n < this.COMMAND_FIX.length; ++n) {
                if (n == n2 || !this.ButtonImages[this.COMMAND_FIX[n]].checkOn(false)) continue;
                graphics.drawImage(this.ButtonImages[this.COMMAND_FIX[n]].getOffImage(), this.ButtonImages[this.COMMAND_FIX[n]].getX1(), this.ButtonImages[this.COMMAND_FIX[n]].getY1(), this);
                break;
            }
        }
        if (this.COMMAND_WARP_SPEED[0] != -1 && this.ButtonImages[this.COMMAND_WARP_SPEED[n2 = ship.getWarpFactor() - 1]].checkOn(true)) {
            graphics.drawImage(this.ButtonImages[this.COMMAND_WARP_SPEED[n2]].getOffImage(), this.ButtonImages[this.COMMAND_WARP_SPEED[n2]].getX1(), this.ButtonImages[this.COMMAND_WARP_SPEED[n2]].getY1(), this);
            for (n = 0; n < this.COMMAND_WARP_SPEED.length; ++n) {
                if (n == n2 || !this.ButtonImages[this.COMMAND_WARP_SPEED[n]].checkOn(false)) continue;
                graphics.drawImage(this.ButtonImages[this.COMMAND_WARP_SPEED[n]].getOffImage(), this.ButtonImages[this.COMMAND_WARP_SPEED[n]].getX1(), this.ButtonImages[this.COMMAND_WARP_SPEED[n]].getY1(), this);
                break;
            }
        }
        if (this.COMMAND_IMPULSE_SPEED[0] != -1 && this.ButtonImages[this.COMMAND_IMPULSE_SPEED[n2 = (int)(ship.getImpulseFactor() * 4.0) - 1]].checkOn(true)) {
            graphics.drawImage(this.ButtonImages[this.COMMAND_IMPULSE_SPEED[n2]].getOffImage(), this.ButtonImages[this.COMMAND_IMPULSE_SPEED[n2]].getX1(), this.ButtonImages[this.COMMAND_IMPULSE_SPEED[n2]].getY1(), this);
            for (n = 0; n < this.COMMAND_IMPULSE_SPEED.length; ++n) {
                if (n == n2 || !this.ButtonImages[this.COMMAND_IMPULSE_SPEED[n]].checkOn(false)) continue;
                graphics.drawImage(this.ButtonImages[this.COMMAND_IMPULSE_SPEED[n]].getOffImage(), this.ButtonImages[this.COMMAND_IMPULSE_SPEED[n]].getX1(), this.ButtonImages[this.COMMAND_IMPULSE_SPEED[n]].getY1(), this);
                break;
            }
        }
        if (this.COMMAND_PHASER_INTENSITY[0] != -1 && this.ButtonImages[this.COMMAND_PHASER_INTENSITY[n2 = ship.getPhaserIntensityInt() - 1]].checkOn(true)) {
            graphics.drawImage(this.ButtonImages[this.COMMAND_PHASER_INTENSITY[n2]].getOffImage(), this.ButtonImages[this.COMMAND_PHASER_INTENSITY[n2]].getX1(), this.ButtonImages[this.COMMAND_PHASER_INTENSITY[n2]].getY1(), this);
            for (n = 0; n < this.COMMAND_PHASER_INTENSITY.length; ++n) {
                if (n == n2 || !this.ButtonImages[this.COMMAND_PHASER_INTENSITY[n]].checkOn(false)) continue;
                graphics.drawImage(this.ButtonImages[this.COMMAND_PHASER_INTENSITY[n]].getOffImage(), this.ButtonImages[this.COMMAND_PHASER_INTENSITY[n]].getX1(), this.ButtonImages[this.COMMAND_PHASER_INTENSITY[n]].getY1(), this);
                break;
            }
        }
        if (this.COMMAND_TORPEDO_SALVO[0] != -1 && this.ButtonImages[this.COMMAND_TORPEDO_SALVO[n2 = ship.getTorpedoSalvoInt() - 1]].checkOn(true)) {
            graphics.drawImage(this.ButtonImages[this.COMMAND_TORPEDO_SALVO[n2]].getOffImage(), this.ButtonImages[this.COMMAND_TORPEDO_SALVO[n2]].getX1(), this.ButtonImages[this.COMMAND_TORPEDO_SALVO[n2]].getY1(), this);
            for (n = 0; n < this.COMMAND_TORPEDO_SALVO.length; ++n) {
                if (n == n2 || !this.ButtonImages[this.COMMAND_TORPEDO_SALVO[n]].checkOn(false)) continue;
                graphics.drawImage(this.ButtonImages[this.COMMAND_TORPEDO_SALVO[n]].getOffImage(), this.ButtonImages[this.COMMAND_TORPEDO_SALVO[n]].getX1(), this.ButtonImages[this.COMMAND_TORPEDO_SALVO[n]].getY1(), this);
                break;
            }
        }
        if (this.INFOTEXT_IMPULSE_SPEED != null && this.INFOTEXT_IMPULSE_SPEED.checkOn(ship.getImpulseSpeed())) {
            this.INFOTEXT_IMPULSE_SPEED.draw(graphics, true);
        }
        if (this.INFOTEXT_IMPULSE_AUTO != null) {
            String string;
            Point point = ship.getAutoImpulse();
            if (point == null) {
                string = "  -- NOT SET --";
            } else if (point instanceof ImageObject) {
                string = ((ImageObject)point).getName();
                if (string.length() > 13) {
                    string = string.substring(0, 11) + "...";
                }
            } else {
                string = point.x + "," + point.y;
            }
            if (this.INFOTEXT_IMPULSE_AUTO.checkOn(string)) {
                this.INFOTEXT_IMPULSE_AUTO.draw(graphics, true);
            }
        }
        if (this.INFOTEXT_WARP_SPEED != null && this.INFOTEXT_WARP_SPEED.checkOn(ship.getWarpSpeed())) {
            this.INFOTEXT_WARP_SPEED.draw(graphics, true);
        }
        if (this.INFOTEXT_WARP_AUTO != null) {
            String string;
            Point point = ship.getAutoWarp();
            if (point == null) {
                string = "  -- NOT SET --";
            } else if (point instanceof ImageObject) {
                string = ((ImageObject)point).getName();
                if (string.length() > 13) {
                    string = string.substring(0, 11) + "...";
                }
            } else {
                string = point.x + "," + point.y;
            }
            if (this.INFOTEXT_WARP_AUTO.checkOn(string)) {
                this.INFOTEXT_WARP_AUTO.draw(graphics, true);
            }
        }
        if (this.INFOTEXT_PHASER != null && this.INFOTEXT_PHASER.checkOn(ship.getPhaserIntensity())) {
            this.INFOTEXT_PHASER.draw(graphics, true);
        }
        if (this.INFOTEXT_TORPEDO != null && this.INFOTEXT_TORPEDO.checkOn(ship.getTorpedoSalvo())) {
            this.INFOTEXT_TORPEDO.draw(graphics, true);
        }
        if (this.INFOTEXT_SHIELDS_UP != null && this.INFOTEXT_SHIELDS_UP.checkOn(ship.getShieldsUp() ? "ON" : "OFF")) {
            this.INFOTEXT_SHIELDS_UP.draw(graphics, true);
        }
        if (this.INFOTEXT_SHIELDS_POWER != null && this.INFOTEXT_SHIELDS_POWER.checkOn((int)((double)ship.getShieldPower() / (double)ship.getMaxshieldpower() * 100.0) + "")) {
            this.INFOTEXT_SHIELDS_POWER.draw(graphics, true);
        }
        if (this.INFOTEXT_TOTAL_POWER != null && this.INFOTEXT_TOTAL_POWER.checkOn(ship.getTotalEnergy() + "")) {
            this.INFOTEXT_TOTAL_POWER.draw(graphics, true);
        }
        if (this.INFOTEXT_PHASER_BANKS != null && this.INFOTEXT_PHASER_BANKS.checkOn(ship.getPhaserBanks() + "")) {
            this.INFOTEXT_PHASER_BANKS.draw(graphics, true);
        }
        if (this.INFOTEXT_TORPEDOS_LEFT != null && this.INFOTEXT_TORPEDOS_LEFT.checkOn(ship.getTorpedosLeft() + "")) {
            this.INFOTEXT_TORPEDOS_LEFT.draw(graphics, true);
        }
        if (this.INFOTEXT_SYSTEM_WARPDRIVE != null && this.INFOTEXT_SYSTEM_WARPDRIVE.checkOn(ship.getSystemText(1))) {
            this.INFOTEXT_SYSTEM_WARPDRIVE.draw(graphics, true);
        }
        if (this.INFOTEXT_SYSTEM_IMPULSEDRIVE != null && this.INFOTEXT_SYSTEM_IMPULSEDRIVE.checkOn(ship.getSystemText(2))) {
            this.INFOTEXT_SYSTEM_IMPULSEDRIVE.draw(graphics, true);
        }
        if (this.INFOTEXT_SYSTEM_PHASERBANKS != null && this.INFOTEXT_SYSTEM_PHASERBANKS.checkOn(ship.getSystemText(3))) {
            this.INFOTEXT_SYSTEM_PHASERBANKS.draw(graphics, true);
        }
        if (this.INFOTEXT_SYSTEM_TORPEDOTUBES != null && this.INFOTEXT_SYSTEM_TORPEDOTUBES.checkOn(ship.getSystemText(4))) {
            this.INFOTEXT_SYSTEM_TORPEDOTUBES.draw(graphics, true);
        }
        if (this.INFOTEXT_SYSTEM_LONGRANGESCAN != null && this.INFOTEXT_SYSTEM_LONGRANGESCAN.checkOn(ship.getSystemText(5))) {
            this.INFOTEXT_SYSTEM_LONGRANGESCAN.draw(graphics, true);
        }
        if (this.INFOTEXT_SYSTEM_SENSORSCAN != null && this.INFOTEXT_SYSTEM_SENSORSCAN.checkOn(ship.getSystemText(6))) {
            this.INFOTEXT_SYSTEM_SENSORSCAN.draw(graphics, true);
        }
        if (this.INFOTEXT_SYSTEM_SHIELDS != null && this.INFOTEXT_SYSTEM_SHIELDS.checkOn(ship.getSystemText(7))) {
            this.INFOTEXT_SYSTEM_SHIELDS.draw(graphics, true);
        }
        if (this.INFOTEXT_SYSTEM_COMPUTER != null && this.INFOTEXT_SYSTEM_COMPUTER.checkOn(ship.getSystemText(8))) {
            this.INFOTEXT_SYSTEM_COMPUTER.draw(graphics, true);
        }
        if (this.INFOTEXT_SYSTEM_TRANSPORTERS != null && this.INFOTEXT_SYSTEM_TRANSPORTERS.checkOn(ship.getSystemText(9))) {
            this.INFOTEXT_SYSTEM_TRANSPORTERS.draw(graphics, true);
        }
        if (this.INFOTEXT_SYSTEM_TRACTORBEAM != null && this.INFOTEXT_SYSTEM_TRACTORBEAM.checkOn(ship.getSystemText(10))) {
            this.INFOTEXT_SYSTEM_TRACTORBEAM.draw(graphics, true);
        }
        if (this.INFOTEXT_OUTPOSTS_RESCUED != null && this.INFOTEXT_OUTPOSTS_RESCUED.checkOn(this.rescue.getBaseNumbers(1) + "")) {
            this.INFOTEXT_OUTPOSTS_RESCUED.draw(graphics, true);
        }
        if (this.INFOTEXT_OUTPOSTS_DESTROYED != null && this.INFOTEXT_OUTPOSTS_DESTROYED.checkOn(this.rescue.getBaseNumbers(2) + "")) {
            this.INFOTEXT_OUTPOSTS_DESTROYED.draw(graphics, true);
        }
        if (this.INFOTEXT_OUTPOSTS_REMAINING != null && this.INFOTEXT_OUTPOSTS_REMAINING.checkOn(this.rescue.getBaseNumbers(3) + "")) {
            this.INFOTEXT_OUTPOSTS_REMAINING.draw(graphics, true);
        }
        if (this.INFOTEXT_OTHERSHIPS_FRIENDLIES != null && this.INFOTEXT_OTHERSHIPS_FRIENDLIES.checkOn(this.rescue.getShipNumbers(1) + "")) {
            this.INFOTEXT_OTHERSHIPS_FRIENDLIES.draw(graphics, true);
        }
        if (this.INFOTEXT_OTHERSHIPS_ENEMIES != null && this.INFOTEXT_OTHERSHIPS_ENEMIES.checkOn(this.rescue.getShipNumbers(2) + "")) {
            this.INFOTEXT_OTHERSHIPS_ENEMIES.draw(graphics, true);
        }
        if (this.INFOTEXT_OTHERSHIPS_DESTROYED != null && this.INFOTEXT_OTHERSHIPS_DESTROYED.checkOn(this.rescue.getShipNumbers(3) + "")) {
            this.INFOTEXT_OTHERSHIPS_DESTROYED.draw(graphics, true);
        }
        if (this.INFOTEXT_COLONIES_ONBOARD != null && this.INFOTEXT_COLONIES_ONBOARD.checkOn(ship.getNoColonies() + "")) {
            this.INFOTEXT_COLONIES_ONBOARD.draw(graphics, true);
        }
        if (this.INFOTEXT_NUMBER_AWAY_TEAMS != null && this.INFOTEXT_NUMBER_AWAY_TEAMS.checkOn(ship.getNoAwayTeams() + "")) {
            this.INFOTEXT_NUMBER_AWAY_TEAMS.draw(graphics, true);
        }
        if (this.INFOTEXT_SCAN != null && this.INFOTEXT_SCAN.checkOn(ship.getScan())) {
            this.INFOTEXT_SCAN.draw(graphics, true);
        }
        if (this.INFOTEXT_MAN_IMPULSE != null && this.INFOTEXT_MAN_IMPULSE.checkOn(ship.getManImpulse() + "")) {
            this.INFOTEXT_MAN_IMPULSE.draw(graphics, true);
        }
        if (this.INFOTEXT_MAN_WARP != null && this.INFOTEXT_MAN_WARP.checkOn(ship.getManWarp() + "")) {
            this.INFOTEXT_MAN_WARP.draw(graphics, true);
        }
        if (this.INFOTEXT_CONDITION != null) {
            Color color;
            String string;
            int n3 = ship.getCondition();
            if (n3 == 1) {
                string = " Green";
                color = Color.GREEN.darker().darker();
            } else if (n3 == 2) {
                string = " Yellow";
                color = Color.YELLOW;
            } else {
                string = "* RED *";
                color = Color.RED.darker().darker();
            }
            if (this.INFOTEXT_CONDITION.checkOn(string)) {
                this.INFOTEXT_CONDITION.setColor(color);
                this.INFOTEXT_CONDITION.draw(graphics, true);
            }
        }
        if (this.INFOBAR_TOTAL_POWER != null && this.INFOBAR_TOTAL_POWER.checkOn(ship.getTotalEnergy(), ship.getMaxtotalenergy())) {
            this.INFOBAR_TOTAL_POWER.draw(graphics, true);
        }
        if (this.INFOBAR_PHASER_BANKS != null && this.INFOBAR_PHASER_BANKS.checkOn(ship.getPhaserBanks(), ship.getMaxphaserbanks())) {
            this.INFOBAR_PHASER_BANKS.draw(graphics, true);
        }
        if (this.INFOBAR_TORPEDOS_LEFT != null && this.INFOBAR_TORPEDOS_LEFT.checkOn(ship.getTorpedosLeft(), ship.getMaxtorpedosleft())) {
            this.INFOBAR_TORPEDOS_LEFT.draw(graphics, true);
        }
        if (this.INFOBAR_TRACTOR_BEAM != null && this.INFOBAR_TRACTOR_BEAM.checkOn(ship.getTractorBeamPower(), ship.getTractorBeamMaxPower())) {
            this.INFOBAR_TRACTOR_BEAM.draw(graphics, true);
        }
        if (this.INFOBAR_SHIELD_POWER != null && this.INFOBAR_SHIELD_POWER.checkOn(ship.getShieldPower(), ship.getMaxshieldpower())) {
            this.INFOBAR_SHIELD_POWER.draw(graphics, true);
        }
    }

    public void paintComponent(Graphics graphics) {
        int n;
        graphics.drawImage(this.img, 0, 0, this.getWidth(), this.getHeight(), this);
        if (this.map != null) {
            if (this.pp != 255) {
                graphics.drawImage(this.ButtonImages[this.pp].getDownImage(), this.ButtonImages[this.pp].getX1(), this.ButtonImages[this.pp].getY1(), this);
            } else if (this.cc != 255) {
                graphics.drawImage(this.ButtonImages[this.cc].getUpImage(), this.ButtonImages[this.cc].getX1(), this.ButtonImages[this.cc].getY1(), this);
            }
            for (n = 0; n < this.ButtonImages.length; ++n) {
                if (!this.ButtonImages[n].getOn()) continue;
                graphics.drawImage(this.ButtonImages[n].getOffImage(), this.ButtonImages[n].getX1(), this.ButtonImages[n].getY1(), this);
            }
        }
        for (n = 0; n < this.infoTexts.size(); ++n) {
            ((infoText)this.infoTexts.elementAt(n)).draw(graphics, false);
        }
        for (n = 0; n < this.infoBars.size(); ++n) {
            ((infoBar)this.infoBars.elementAt(n)).draw(graphics, false);
        }
    }

    public void command(int n) {
        Ship ship = this.rescue.getShip();
        boolean bl = true;
        if (n == this.COMMAND_IMPULSE_AUTO) {
            ship.setAutoImpulseOn(true);
        } else if (n == this.COMMAND_IMPULSE_MAN) {
            ship.setAutoImpulseOn(false);
        } else if (n == this.COMMAND_IMPULSE_START) {
            ship.setImpulseOn(true);
        } else if (n == this.COMMAND_STOP || n == this.COMMAND_STOP2) {
            ship.stop();
        } else if (n == this.COMMAND_IMPULSE_UP) {
            ship.setImpulseUpDown(true);
        } else if (n == this.COMMAND_IMPULSE_DOWN) {
            ship.setImpulseUpDown(false);
        } else if (n == this.COMMAND_WARP_AUTO) {
            ship.setAutoWarpOn(true);
        } else if (n == this.COMMAND_WARP_MAN) {
            ship.setAutoWarpOn(false);
        } else if (n == this.COMMAND_WARP_START) {
            ship.setWarpOn(true);
        } else if (n == this.COMMAND_WARP_UP) {
            ship.setWarpUpDown(true);
        } else if (n == this.COMMAND_WARP_DOWN) {
            ship.setWarpUpDown(false);
        } else if (n == this.COMMAND_PHASER_UP) {
            ship.setPhaserIntensityUpDown(true);
        } else if (n == this.COMMAND_PHASER_DOWN) {
            ship.setPhaserIntensityUpDown(false);
        } else if (n == this.COMMAND_PHASER_FIRE) {
            this.rescue.shipFirePhaser();
        } else if (n == this.COMMAND_TORPEDO_UP) {
            ship.setTorpedoSalvoUpDown(true);
        } else if (n == this.COMMAND_TORPEDO_DOWN) {
            ship.setTorpedoSalvoUpDown(false);
        } else if (n == this.COMMAND_TORPEDO_FIRE) {
            this.rescue.shipFireTorpedo();
        } else if (n == this.COMMAND_SHIELDS_UP || n == this.COMMAND_SHIELDS_DOWN) {
            ship.changeShields();
        } else if (n == this.COMMAND_TRACTOR || n == this.COMMAND_TRACTOR_OFF) {
            this.rescue.shipTractorShip();
        } else if (n == this.COMMAND_ZOOMIN) {
            this.rescue.zoom(true);
        } else if (n == this.COMMAND_ZOOMOUT) {
            this.rescue.zoom(false);
        } else if (n == this.COMMAND_BEAM_DOWN) {
            this.rescue.shipBeamDown();
        } else if (n == this.COMMAND_BEAM_UP) {
            this.rescue.shipBeamUp();
        } else if (n == this.COMMAND_DOCK) {
            this.rescue.shipDock();
        } else if (n == this.COMMAND_BOARD) {
            this.rescue.shipBoard();
        } else if (n == this.COMMAND_SCAN_UP) {
            ship.setScan(true);
            this.rescue.updateGUI();
        } else if (n == this.COMMAND_SCAN_DOWN) {
            ship.setScan(false);
            this.rescue.updateGUI();
        } else if (n == this.COMMAND_SHIPS_UP) {
            this.rescue.scrollShips(true, true);
        } else if (n == this.COMMAND_SHIPS_DOWN) {
            this.rescue.scrollShips(true, false);
        } else if (n == this.COMMAND_BASE_UP) {
            this.rescue.scrollShips(false, true);
        } else if (n == this.COMMAND_BASE_DOWN) {
            this.rescue.scrollShips(false, false);
        } else if (n == this.COMMAND_PAUSE) {
            this.rescue.pause();
        } else if (n == this.COMMAND_HEADSUP) {
            this.rescue.headsUpDisplay();
        } else if (n == this.COMMAND_RESERVE) {
            ship.useReserve();
        } else if (n == this.COMMAND_DIVERT) {
            ship.divertPhaser();
        } else if (n == this.COMMAND_EVASIVE_1) {
            ship.setEvasive(1);
        } else if (n == this.COMMAND_EVASIVE_2) {
            ship.setEvasive(2);
        } else if (n == this.COMMAND_EVASIVE_3) {
            ship.setEvasive(3);
        } else {
            if (n == this.COMMAND_ENDGAME) {
                this.rescue.closeCurrentMission();
                this.cc = 255;
                this.pp = 255;
                this.tt = 255;
                return;
            }
            if (n == this.COMMAND_HELP) {
                this.rescue.help();
            } else if (n == this.COMMAND_QUIT) {
                System.exit(0);
            } else {
                int n2;
                bl = false;
                if (this.COMMAND_SELECT[0] != -1) {
                    for (n2 = 0; n2 < this.COMMAND_SELECT.length; ++n2) {
                        if (n != this.COMMAND_SELECT[n2]) continue;
                        this.rescue.setSelect(n2);
                        bl = true;
                        break;
                    }
                }
                if (!bl && this.COMMAND_TARGET[0] != -1) {
                    for (n2 = 0; n2 < this.COMMAND_TARGET.length; ++n2) {
                        if (n != this.COMMAND_TARGET[n2]) continue;
                        ship.setTarget(n2);
                        bl = true;
                        break;
                    }
                }
                if (!bl && this.COMMAND_FIX[0] != -1) {
                    for (n2 = 0; n2 < this.COMMAND_FIX.length; ++n2) {
                        if (n != this.COMMAND_FIX[n2]) continue;
                        ship.setFixPriority(n2);
                        bl = true;
                        break;
                    }
                }
                if (!bl && this.COMMAND_SHIPS_SORT[0] != -1) {
                    for (n2 = 0; n2 < this.COMMAND_SHIPS_SORT.length; ++n2) {
                        if (n != this.COMMAND_SHIPS_SORT[n2]) continue;
                        this.rescue.setShipsSort(n2);
                        bl = true;
                        break;
                    }
                }
                if (!bl && this.COMMAND_BASE_SORT[0] != -1) {
                    for (n2 = 0; n2 < this.COMMAND_BASE_SORT.length; ++n2) {
                        if (n != this.COMMAND_BASE_SORT[n2]) continue;
                        this.rescue.setBaseSort(n2);
                        bl = true;
                        break;
                    }
                }
                if (!bl && this.COMMAND_SHIPS_SHOW[0] != -1) {
                    for (n2 = 0; n2 < this.COMMAND_SHIPS_SHOW.length; ++n2) {
                        if (n != this.COMMAND_SHIPS_SHOW[n2]) continue;
                        this.rescue.setShipsShow(n2);
                        bl = true;
                        break;
                    }
                }
                if (!bl && this.COMMAND_BASE_SHOW[0] != -1) {
                    for (n2 = 0; n2 < this.COMMAND_BASE_SHOW.length; ++n2) {
                        if (n != this.COMMAND_BASE_SHOW[n2]) continue;
                        this.rescue.setBaseShow(n2);
                        bl = true;
                        break;
                    }
                }
                if (!bl && this.COMMAND_WARP_SPEED[0] != -1) {
                    for (n2 = 0; n2 < this.COMMAND_WARP_SPEED.length; ++n2) {
                        if (n != this.COMMAND_WARP_SPEED[n2]) continue;
                        ship.setWarpFactor(n2 + 1);
                        bl = true;
                        break;
                    }
                }
                if (!bl && this.COMMAND_IMPULSE_SPEED[0] != -1) {
                    for (n2 = 0; n2 < this.COMMAND_IMPULSE_SPEED.length; ++n2) {
                        if (n != this.COMMAND_IMPULSE_SPEED[n2]) continue;
                        ship.setImpulseFactor(n2 + 1);
                        bl = true;
                        break;
                    }
                }
                if (!bl && this.COMMAND_PHASER_INTENSITY[0] != -1) {
                    for (n2 = 0; n2 < this.COMMAND_PHASER_INTENSITY.length; ++n2) {
                        if (n != this.COMMAND_PHASER_INTENSITY[n2]) continue;
                        ship.setPhaserIntensity(n2 + 1);
                        bl = true;
                        break;
                    }
                }
                if (!bl && this.COMMAND_TORPEDO_SALVO[0] != -1) {
                    for (n2 = 0; n2 < this.COMMAND_TORPEDO_SALVO.length; ++n2) {
                        if (n != this.COMMAND_TORPEDO_SALVO[n2]) continue;
                        ship.setTorpedoSalvo(n2 + 1);
                        bl = true;
                        break;
                    }
                }
            }
        }
        if (bl) {
            JukeBox.play(0);
            this.list();
            return;
        }
        System.out.print("action not set for color " + n + "\n");
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = this.map[mouseEvent.getX()][mouseEvent.getY()];
        if (n != this.cc) {
            Graphics graphics = this.getGraphics();
            if (this.cc < this.ButtonImages.length) {
                graphics.drawImage(this.ButtonImages[this.cc].getOffImage(), this.ButtonImages[this.cc].getX1(), this.ButtonImages[this.cc].getY1(), this);
            }
            this.cc = n;
            if (this.cc < this.ButtonImages.length) {
                graphics.drawImage(this.ButtonImages[this.cc].getUpImage(), this.ButtonImages[this.cc].getX1(), this.ButtonImages[this.cc].getY1(), this);
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = this.map[mouseEvent.getX()][mouseEvent.getY()];
        if (n < this.ButtonImages.length) {
            Graphics graphics = this.getGraphics();
            graphics.drawImage(this.ButtonImages[n].getDownImage(), this.ButtonImages[n].getX1(), this.ButtonImages[n].getY1(), this);
            if (n < this.ButtonImages.length) {
                this.pp = n;
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (n < 0 || n >= this.img.getWidth() || n2 < 0 || n2 >= this.img.getHeight()) {
            return;
        }
        int n3 = this.map[n][n2];
        if (n3 != this.cc && this.pp != 255) {
            Graphics graphics = this.getGraphics();
            if (n3 != this.pp) {
                graphics.drawImage(this.ButtonImages[this.pp].getOffImage(), this.ButtonImages[this.pp].getX1(), this.ButtonImages[this.pp].getY1(), this);
            } else {
                graphics.drawImage(this.ButtonImages[this.pp].getDownImage(), this.ButtonImages[this.pp].getX1(), this.ButtonImages[this.pp].getY1(), this);
            }
            this.cc = n3;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (n < 0 || n >= this.img.getWidth() || n2 < 0 || n2 >= this.img.getHeight()) {
            this.pp = 255;
            return;
        }
        int n3 = this.map[n][n2];
        if (n3 < this.ButtonImages.length) {
            if (n3 == this.pp) {
                this.command(n3);
            }
            if (this.rescue.getShip() != null) {
                Graphics graphics = this.getGraphics();
                graphics.drawImage(this.ButtonImages[n3].getUpImage(), this.ButtonImages[n3].getX1(), this.ButtonImages[n3].getY1(), this);
            }
        }
        this.pp = 255;
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.cc != 255) {
            Graphics graphics = this.getGraphics();
            graphics.drawImage(this.ButtonImages[this.cc].getOffImage(), this.ButtonImages[this.cc].getX1(), this.ButtonImages[this.cc].getY1(), this);
            this.cc = 255;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public boolean contains(int n, int n2) {
        if (this.map != null) {
            if (n < 0 || n >= this.img.getWidth() || n2 < 0 || n2 >= this.img.getHeight()) {
                this.tt = 255;
                return false;
            }
            int n3 = this.map[n][n2];
            if (n3 == 255) {
                this.tt = 255;
                return false;
            }
            if (n3 != this.tt) {
                this.setToolTipText(this.ButtonImages[n3].getToolTip());
                this.tt = n3;
            }
            return true;
        }
        return false;
    }

    class mapButton {
        private int x1;
        private int y1;
        private int x2;
        private int y2;
        private BufferedImage offImage;
        private BufferedImage onImage;
        private BufferedImage HighLightImage;
        private BufferedImage PressDownImage;
        private boolean on;
        private String tooltip;

        public mapButton(int n, int n2) {
            this.x1 = n;
            this.y1 = n2;
            this.x2 = 0;
            this.y2 = 0;
            this.onImage = null;
            this.HighLightImage = null;
            this.PressDownImage = null;
        }

        public String getToolTip() {
            return this.tooltip;
        }

        public void setToolTip(String string) {
            this.tooltip = string;
        }

        public boolean checkOn(boolean bl) {
            if (bl != this.on) {
                this.on = bl;
                return true;
            }
            return false;
        }

        public boolean getOn() {
            return this.on;
        }

        public void setOffImage(BufferedImage bufferedImage) {
            this.offImage = bufferedImage;
        }

        public void setOnImage(BufferedImage bufferedImage) {
            this.onImage = bufferedImage;
        }

        public void setUpImage(BufferedImage bufferedImage) {
            this.HighLightImage = bufferedImage;
        }

        public void setDownImage(BufferedImage bufferedImage) {
            this.PressDownImage = bufferedImage;
        }

        public void setX1(int n) {
            this.x1 = n;
        }

        public void setY1(int n) {
            this.y1 = n;
        }

        public void setX2(int n) {
            this.x2 = n;
        }

        public void setY2(int n) {
            this.y2 = n;
        }

        public BufferedImage getOffImage() {
            if (this.on) {
                return this.onImage;
            }
            return this.offImage;
        }

        public BufferedImage getUpImage() {
            if (this.on) {
                return this.onImage;
            }
            return this.HighLightImage;
        }

        public BufferedImage getDownImage() {
            if (this.on) {
                return this.onImage;
            }
            return this.PressDownImage;
        }

        public int getX1() {
            return this.x1;
        }

        public int getY1() {
            return this.y1;
        }

        public int getX2() {
            return this.x2;
        }

        public int getY2() {
            return this.y2;
        }

        public int getWidth() {
            return this.x2 - this.x1 + 1;
        }

        public int getHeight() {
            return this.y2 - this.y1 + 1;
        }
    }

    class infoText {
        private int x;
        private int y;
        private int textX;
        private int textY;
        private BufferedImage back;
        private String text;
        private Color color;

        public infoText(BufferedImage bufferedImage, int n, int n2, int n3, int n4, Color color) {
            this.back = bufferedImage;
            this.text = "";
            this.x = n;
            this.y = n2;
            this.textX = n3;
            this.textY = n4;
            this.color = color;
        }

        public boolean checkOn(String string) {
            if (this.text.equals(string)) {
                return false;
            }
            this.text = string;
            return true;
        }

        public void draw(Graphics graphics, boolean bl) {
            if (bl) {
                graphics.drawImage(this.back, this.x, this.y, InterfacePanel.this);
            }
            graphics.setColor(this.color);
            graphics.drawString(this.text, this.textX, this.textY);
        }

        public void setColor(Color color) {
            this.color = color;
        }
    }

    class infoBar {
        private int x;
        private int y;
        private int value;
        private int direction;
        private BufferedImage on;
        private BufferedImage off;
        private int nx;
        private int ny;
        private int nw;
        private int nh;

        public infoBar(BufferedImage bufferedImage, BufferedImage bufferedImage2, int n, int n2, String string) throws Exception {
            this.x = n;
            this.y = n2;
            this.value = 0;
            if (string.equals("right")) {
                this.direction = 1;
            } else if (string.equals("left")) {
                this.direction = 2;
            } else if (string.equals("up")) {
                this.direction = 3;
            } else if (string.equals("down")) {
                this.direction = 4;
            } else {
                throw new Exception("unknows direction " + string);
            }
            this.on = bufferedImage2;
            this.off = bufferedImage;
        }

        public boolean checkOn(int n, int n2) {
            if (this.value == n) {
                return false;
            }
            this.value = n;
            this.nx = 0;
            this.ny = 0;
            this.nw = this.on.getWidth();
            this.nh = this.on.getHeight();
            if (this.direction == 1) {
                this.nw = (int)((double)this.nw * ((double)this.value / (double)n2));
            } else if (this.direction == 2) {
                this.nw = (int)((double)this.nw * ((double)this.value / (double)n2));
                this.nx += this.on.getWidth() - this.nw;
            } else if (this.direction == 3) {
                this.nh = (int)((double)this.nh * ((double)this.value / (double)n2));
                this.ny += this.on.getHeight() - this.nh;
            } else if (this.direction == 4) {
                this.nh = (int)((double)this.nh * ((double)this.value / (double)n2));
            }
            return true;
        }

        public void draw(Graphics graphics, boolean bl) {
            if (bl) {
                graphics.drawImage(this.off, this.x, this.y, InterfacePanel.this);
            }
            if (this.nw != 0 && this.nh != 0) {
                graphics.drawImage(this.on.getSubimage(this.nx, this.ny, this.nw, this.nh), this.x + this.nx, this.y + this.ny, InterfacePanel.this);
            }
        }
    }
}

