/*
 * Decompiled with CFR 0.152.
 */
package rescue.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import rescue.RunRescue;
import rescue.spaceobjects.Base;
import rescue.spaceobjects.ImageObject;
import rescue.spaceobjects.MannedObject;
import rescue.spaceobjects.Planet;
import rescue.spaceobjects.Ship;
import rescue.spaceobjects.Wormhole;

public class ShipsPanel
extends JScrollPane
implements MouseWheelListener {
    private RunRescue rescue;
    private JList ShipsBox;
    private Vector SpaceObjectPanels;
    private Vector theOthers;
    private int type;
    private int height = 30;
    private int show;
    private int sort;

    public ShipsPanel(RunRescue runRescue, int n, int n2, int n3) {
        super(21, 31);
        this.setWheelScrollingEnabled(false);
        this.type = n3;
        this.rescue = runRescue;
        Dimension dimension = new Dimension(n, n2);
        this.setPreferredSize(dimension);
        this.ShipsBox = new JList();
        this.ShipsBox.setCellRenderer(new CustomCellRenderer());
        this.ShipsBox.setFixedCellHeight(this.height);
        this.ShipsBox.setVisibleRowCount(4);
        this.ShipsBox.addMouseWheelListener(this);
        this.ShipsBox.setBackground(Color.BLACK);
        this.getViewport().setView(this.ShipsBox);
        this.setBorder(null);
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (mouseWheelEvent.getWheelRotation() < 0) {
            this.rescue.scrollShips(this.type == 1, true);
        } else {
            this.rescue.scrollShips(this.type == 1, false);
        }
    }

    public void newGame() {
        this.SpaceObjectPanels = new Vector();
        this.theOthers = new Vector();
        ImageObject[] imageObjectArray = this.rescue.getSpaceObjects();
        Ship ship = this.rescue.getShip();
        if (this.type == 1) {
            this.theOthers.add(new ShipPanel(ship));
        }
        for (int i = 0; i < imageObjectArray.length; ++i) {
            ImageObject imageObject = imageObjectArray[i];
            if (this.type == 1 && imageObject instanceof Ship && imageObject != ship) {
                this.SpaceObjectPanels.add(new ShipPanel(imageObject));
                continue;
            }
            if (this.type != 2 || !(imageObject instanceof Planet) && !(imageObject instanceof Base) && !(imageObject instanceof Wormhole)) continue;
            this.SpaceObjectPanels.add(new ShipPanel(imageObject));
        }
        this.ShipsBox.setListData(this.SpaceObjectPanels);
        this.sort = 0;
        this.show = 3;
    }

    public void list() {
        Object e = this.ShipsBox.getSelectedValue();
        Collections.sort(this.SpaceObjectPanels);
        this.ShipsBox.setSelectedValue(e, false);
        this.ShipsBox.repaint();
        this.setShow(this.show);
    }

    public void scroll(boolean bl) {
        JScrollBar jScrollBar = this.getVerticalScrollBar();
        int n = jScrollBar.getValue();
        if (bl) {
            jScrollBar.setValue(n - this.height);
        } else {
            jScrollBar.setValue(n + this.height);
        }
    }

    public boolean canScroll(boolean bl) {
        int n = this.getVerticalScrollBar().getValue();
        if (bl) {
            return n != 0;
        }
        return n != this.height * (this.SpaceObjectPanels.size() - this.ShipsBox.getVisibleRowCount()) && this.SpaceObjectPanels.size() >= this.ShipsBox.getVisibleRowCount();
    }

    public void setSort(int n) {
        this.sort = n;
    }

    public void setShow(int n) {
        ImageObject imageObject;
        int n2;
        this.show = n;
        Vector vector = new Vector();
        Ship ship = this.rescue.getShip();
        boolean bl = false;
        int n3 = this.rescue.getScan();
        for (n2 = 0; n2 < this.theOthers.size(); ++n2) {
            imageObject = ((ShipPanel)this.theOthers.elementAt(n2)).getSO();
            if (!(imageObject instanceof Planet || imageObject instanceof Wormhole || ((MannedObject)imageObject).isAlive())) {
                this.theOthers.remove(n2);
                --n2;
                continue;
            }
            if (this.type == 1 && imageObject != ship && n3 >= ((MannedObject)imageObject).getCloakPower() && ship.getSystem(5) == 0 && (this.show == 0 && ((MannedObject)imageObject).enemyOf(ship.getNumber()) || this.show == 1 && ((MannedObject)imageObject).friendOf(ship.getNumber()) || this.show == 2 && !((MannedObject)imageObject).enemyOf(ship.getNumber()) && !((MannedObject)imageObject).friendOf(ship.getNumber()) || this.show == 3)) {
                vector.add(this.theOthers.remove(n2));
                --n2;
                bl = true;
                continue;
            }
            if (this.type != 2 || !(imageObject instanceof Wormhole) && n3 < ((MannedObject)imageObject).getCloakPower() || ship.getSystem(5) != 0 || !(this.show == 0 && imageObject instanceof Planet || this.show == 1 && imageObject instanceof Base || this.show == 2 && imageObject instanceof Wormhole) && this.show != 3) continue;
            vector.add(this.theOthers.remove(n2));
            --n2;
            bl = true;
        }
        for (n2 = 0; n2 < this.SpaceObjectPanels.size(); ++n2) {
            imageObject = ((ShipPanel)this.SpaceObjectPanels.elementAt(n2)).getSO();
            if (!(imageObject instanceof Planet || imageObject instanceof Wormhole || ((MannedObject)imageObject).isAlive())) {
                this.SpaceObjectPanels.remove(n2);
                --n2;
                bl = true;
                continue;
            }
            if (this.type == 1 && (ship.getSystem(5) != 0 || n3 < ((MannedObject)imageObject).getCloakPower() || imageObject == ship || this.show == 0 && !((MannedObject)imageObject).enemyOf(ship.getNumber()) || this.show == 1 && !((MannedObject)imageObject).friendOf(ship.getNumber()) || this.show == 2 && (((MannedObject)imageObject).enemyOf(ship.getNumber()) || ((MannedObject)imageObject).friendOf(ship.getNumber())))) {
                this.theOthers.add(this.SpaceObjectPanels.remove(n2));
                --n2;
                bl = true;
                continue;
            }
            if (this.type != 2 || !(ship.getSystem(5) != 0 || !(imageObject instanceof Wormhole) && n3 < ((MannedObject)imageObject).getCloakPower() || this.show == 0 && !(imageObject instanceof Planet) || this.show == 1 && !(imageObject instanceof Base)) && (this.show != 2 || imageObject instanceof Wormhole)) continue;
            this.theOthers.add(this.SpaceObjectPanels.remove(n2));
            --n2;
            bl = true;
        }
        if (bl) {
            this.ShipsBox.clearSelection();
            this.getVerticalScrollBar().setValue(0);
            this.SpaceObjectPanels.addAll(vector);
            this.ShipsBox.revalidate();
        }
    }

    public int getSort() {
        return this.sort;
    }

    public int getShow() {
        return this.show;
    }

    public void clearSelection() {
        this.ShipsBox.clearSelection();
    }

    class ShipPanel
    extends JPanel
    implements Comparable {
        private BufferedImage pic;
        private ImageObject mySO;
        private boolean selected;

        public ShipPanel(ImageObject imageObject) {
            this.setBackground(Color.BLACK);
            this.mySO = imageObject;
            this.pic = new BufferedImage(172, 24, 5);
            Graphics graphics = this.pic.getGraphics();
            graphics.setColor(Color.BLACK);
            graphics.fillRect(0, 0, 200, 24);
            graphics.setColor(Color.WHITE);
            graphics.drawString(imageObject.getName(), 24, 10);
            graphics.drawImage(imageObject.getIcon(), 2, 2, this);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            graphics.drawImage(this.pic, 3, 3, this);
            graphics.setColor(Color.WHITE);
            graphics.drawString(this.mySO.getDistanceToPlayer() + "", 27, 26);
            if (!(this.mySO instanceof Wormhole) && ShipsPanel.this.rescue.getScan() > 0) {
                graphics.drawRect(92, 17, 81, 8);
                graphics.setColor(Color.GREEN.darker());
                graphics.fillRect(93, 18, (int)(80.0 * ((double)((MannedObject)this.mySO).getTotalEnergy() / (double)((MannedObject)this.mySO).getMaxtotalenergy())), 7);
            }
        }

        public ImageObject getSO() {
            return this.mySO;
        }

        public boolean setSelected(boolean bl) {
            if (this.selected == bl) {
                return false;
            }
            this.selected = bl;
            return true;
        }

        public int compareTo(Object object) {
            if (ShipsPanel.this.sort == 0) {
                int n = (int)this.mySO.distance(ShipsPanel.this.rescue.getShip());
                int n2 = (int)((ShipPanel)object).getSO().distance(ShipsPanel.this.rescue.getShip());
                return n - n2;
            }
            int n = 0;
            int n3 = 0;
            if (this.mySO instanceof MannedObject) {
                n = ((MannedObject)this.mySO).getTotalEnergy();
            }
            if (((ShipPanel)object).getSO() instanceof MannedObject) {
                n3 = ((MannedObject)((ShipPanel)object).getSO()).getTotalEnergy();
            }
            return n - n3;
        }
    }

    class CustomCellRenderer
    implements ListCellRenderer {
        CustomCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            ShipPanel shipPanel = (ShipPanel)object;
            if (shipPanel.setSelected(bl)) {
                shipPanel.setBackground(bl ? Color.RED : Color.BLACK);
                if (bl) {
                    ShipsPanel.this.rescue.newSelection(ShipsPanel.this.type, shipPanel.getSO());
                }
            }
            return shipPanel;
        }
    }
}

