package rescue;

import java.io.*;
import java.awt.*;
import javax.swing.*;
import java.awt.event.*;

public class SimplePrintStream {

	public static PrintStream getSimplePrintStream(final StringWriter a) {

		return new PrintStream(new OutputStream() {

			private ByteArrayOutputStream outputStream = new ByteArrayOutputStream(256);
			private StringWriter sw = null;

			{ sw = a; }
 
			public void write(int b) {

				outputStream.write(b);
			}
 
			public void flush() throws IOException {

				super.flush();

				sw.write( outputStream.toString() );

				outputStream.reset();

			}

		}, true);

	}

	private static JFrame errFrame;
	private static JTextArea debugText;

	public static void catchErrors() {


		PrintStream ps = SimplePrintStream.getSimplePrintStream(

		    new StringWriter() {
			public void write(String x) {

			    // only create all this stuff if an error has happened
			    if (errFrame==null) {

				debugText = new JTextArea();

			    	errFrame = new JFrame("an error has occurred!!!");

				errFrame.setDefaultCloseOperation( JFrame.DO_NOTHING_ON_CLOSE );

				debugText.setEditable(false);

				JScrollPane errScroll = new JScrollPane(debugText);

				Dimension size = new Dimension(400,400);

				errScroll.setMaximumSize(size);
				errScroll.setPreferredSize(size);
				errScroll.setMinimumSize(size);

				JLabel label = new JLabel(" please copy and paste this log into an e-mail and send it to yura@yura.net");
				label.setBorder( BorderFactory.createMatteBorder(10,10,10,10,Color.RED) );

				JButton saveErr = new JButton("save error log to file");

				saveErr.addActionListener(
				    new ActionListener() {
					public void actionPerformed(ActionEvent a) {




						JFileChooser fc = new JFileChooser();
						//RiskFileFilter filter = new RiskFileFilter(RiskFileFilter.RISK_LOG_FILES);
						//fc.setFileFilter(filter);

						int returnVal = fc.showSaveDialog(errFrame);
						if (returnVal == JFileChooser.APPROVE_OPTION) {
							java.io.File file = fc.getSelectedFile();
							// Write your code here what to do with selected file

							String fileName = file.getAbsolutePath();

							//if (!(fileName.endsWith( "." + RiskFileFilter.RISK_LOG_FILES ))) {
							//	fileName = fileName + "." + RiskFileFilter.RISK_LOG_FILES;
							//}

							try {

								FileWriter fileout = new FileWriter(fileName);
								BufferedWriter buffer = new BufferedWriter(fileout);
								PrintWriter printer = new PrintWriter(buffer);

								printer.write(debugText.getText());

								printer.close();

							}

							catch(Exception error) {
								JOptionPane.showMessageDialog(errFrame, "unable to save file: " + error.getMessage(), "save error", JOptionPane.ERROR_MESSAGE);
							}

						}





					}
				    }
				);

				errFrame.getContentPane().add( label , BorderLayout.NORTH );
				errFrame.getContentPane().add( errScroll , BorderLayout.CENTER);
				errFrame.getContentPane().add( saveErr , BorderLayout.SOUTH);

				errFrame.pack();

				String n = System.getProperty("line.separator");

				debugText.append("Date: "+new java.util.Date().toString()+n+n+n);

				errFrame.setVisible(true);

			    }

			    debugText.append(x);

			}
		    }

		);

		// catch everything in my PrintStream
		//System.setOut(ps);
		System.setErr(ps);

	}

}
