package rescue.gui;

import rescue.*;

import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JLabel;
import javax.swing.JButton;
import javax.swing.JTextArea;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.WindowEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JSpinner;

/**
 * <p> About Dialog </p>
 * @author Yura Mamyrin
 */


public class PrefDialog extends JDialog implements ActionListener {

    private RunRescue rescue;
    private RescueGUI gui;
    private JCheckBox inout;
    private JSpinner delay;

    public PrefDialog(Frame parent, boolean modal, RunRescue r, RescueGUI g) {
        super(parent,"Preferences", modal);

	rescue=r;
	gui=g;

        initGUI();
        pack();
    }

    /** This method is called from within the constructor to initialize the dialog. */
    private void initGUI() {

        setResizable(false);


	//Rescue! Max Startup Prefererences
	//Initial window positions - default/saved
	//Initial sound setting - on/off
	//Initial skill level setting - Cadet/...
	//[v] Begin new game at startup

	//set Default Preferences
	//Save Window Positions

	JButton cancelButton = new JButton("Cancel");
	cancelButton.setActionCommand("cancel");
	cancelButton.addActionListener(this);

	JButton okButton = new JButton("OK");
	okButton.setActionCommand("ok");
	okButton.addActionListener(this);

	JPanel bottomPanel = new JPanel( new BorderLayout(20,20) );
	bottomPanel.add(cancelButton,java.awt.BorderLayout.WEST);
	bottomPanel.add(okButton,java.awt.BorderLayout.EAST);

	inout = new JCheckBox("Use External Frames", rescue.getMode() );

	JPanel optionsPanel = new JPanel();
	delay = new JSpinner();
	delay.setValue(new Integer( rescue.getDelay() ));
	optionsPanel.add(new JLabel("Delay in milliseconds:") );
	optionsPanel.add( delay );

	getContentPane().add(inout, java.awt.BorderLayout.NORTH );
	getContentPane().add(optionsPanel, java.awt.BorderLayout.CENTER);
	getContentPane().add(bottomPanel, java.awt.BorderLayout.SOUTH);

        addWindowListener(
            new java.awt.event.WindowAdapter() {
                public void windowClosing(WindowEvent evt) {
                    closeDialog();
                }
            }
	);

    }

    public void actionPerformed(ActionEvent e) {

	if (e.getActionCommand().equals("ok")) {

	    rescue.setMode( inout.isSelected() );
	    rescue.setDelay( ((Integer)delay.getValue()).intValue() );

	}
	else if (e.getActionCommand().equals("cancel")) {

	}

	closeDialog();

    }

    /** Closes the dialog */
    private void closeDialog() {
        setVisible(false);
        dispose();
    }
}
