/*
 * Decompiled with CFR 0.152.
 */
package com.dnsalias.java.timer;

import com.dnsalias.java.timer.NativeTimer;
import com.dnsalias.java.timer.nanotimer.NanoTimer;
import com.dnsalias.java.timer.windows.WindowsTimer;

public class AdvancedTimer {
    private static long resolution;
    private long start = 0L;
    private long ticks = 0L;
    private boolean running = false;
    private static NativeTimer wintimer;

    public AdvancedTimer() {
        if (resolution == 0L) {
            AdvancedTimer.init();
        }
    }

    private static void init() {
        long l;
        long l2 = l = System.currentTimeMillis();
        if (new NanoTimer().available()) {
            System.out.println("1.5 NanoTimer selected.");
            wintimer = new NanoTimer();
            resolution = 1L;
        } else if (new WindowsTimer().available()) {
            wintimer = new WindowsTimer();
            resolution = 1L;
        } else {
            while (l == l2) {
                l = System.currentTimeMillis();
            }
            resolution = l - l2;
            l2 = l = System.currentTimeMillis();
            while (l == l2) {
                l = System.currentTimeMillis();
            }
            if (l - l2 < resolution) {
                resolution = l - l2;
            }
        }
    }

    private long getTime() {
        if (wintimer != null) {
            return wintimer.getClockTicks();
        }
        return System.currentTimeMillis();
    }

    public void start() {
        long l;
        long l2 = l = this.getTime();
        this.ticks = 0L;
        this.running = true;
        while (l == l2) {
            l = this.getTime();
        }
        this.start = this.getTime();
    }

    public long getClockTicks() {
        if (this.running) {
            this.ticks = (this.getTime() - this.start) / resolution;
        }
        return this.ticks;
    }

    public void stop() {
        this.getClockTicks();
        this.running = false;
    }

    public void sleep() throws IllegalStateException {
        this.sleep(1L);
    }

    public void sleep(long l) throws IllegalStateException {
        long l2 = this.getClockTicks();
        if (!this.running) {
            throw new IllegalStateException("Timer not running!");
        }
        while (this.getClockTicks() < l2 + l) {
            Thread.yield();
        }
    }

    public void sleepUntil(long l) throws IllegalStateException {
        if (!this.running) {
            throw new IllegalStateException("Timer not running!");
        }
        while (this.getClockTicks() < l) {
            Thread.yield();
        }
    }

    public static long getResolution() {
        if (resolution == 0L) {
            AdvancedTimer.init();
        }
        return resolution;
    }

    public static long getTicksPerSecond() {
        if (resolution == 0L) {
            AdvancedTimer.init();
        }
        if (wintimer != null) {
            return wintimer.getResolution();
        }
        return 1000L / AdvancedTimer.getResolution();
    }
}

