/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev;

import com.golden.gamedev.Game;
import com.golden.gamedev.engine.BaseGraphics;
import com.golden.gamedev.engine.graphics.AppletMode;
import com.golden.gamedev.engine.graphics.FullScreenMode;
import com.golden.gamedev.engine.graphics.WindowExitListener;
import com.golden.gamedev.engine.graphics.WindowedMode;
import com.golden.gamedev.funbox.ErrorNotificationDialog;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;

public class GameLoader
extends AppletMode
implements WindowListener,
Runnable {
    public static final String JAVA_VERSION;
    public String MINIMUM_VERSION = "1.4";
    private boolean c = true;
    private String[] d = new String[]{"Loading Game, please wait a moment"};
    protected BaseGraphics gfx;
    protected Game game;

    public void start() {
        if (this.c) {
            if (this.gfx != null) {
                if (this.game != null) {
                    this.game.start();
                }
                return;
            }
            try {
                String string = this.getParameter("MINIMUM_VERSION");
                if (string != null) {
                    this.MINIMUM_VERSION = string;
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "ERROR: GameLoader.setup(Game, Dimension, Fullscreen); need to be called\nbefore calling GameLoader.start();", "Game Initialization", 0);
                System.exit(0);
            }
            if (!this.validJavaVersion()) {
                this.d = new String[]{"Sorry, this game requires Java " + this.MINIMUM_VERSION + "++", "Your machine only has Java " + JAVA_VERSION + " installed", "", "Install the latest Java Runtime Edition (JRE)", "from http://www.java.com"};
                return;
            }
            try {
                if (this.game == null) {
                    this.game = this.createAppletGame();
                    if (this.game == null) {
                        JOptionPane.showMessageDialog(null, "FATAL ERROR: Game main-class is not specified!\nPlease subclass GameLoader class and override\ncreateAppletGame() method to return your game main class.\n\nFor example :\npublic class YourGameApplet extends GameLoader {\n   protected Game createAppletGame() {\n      return new YourGame();\n   }\n}", "Game Initialization", 0);
                        this.c = false;
                        return;
                    }
                    this.game.bsGraphics = this.gfx = this;
                }
                super.start();
                new Thread(this).start();
                return;
            }
            catch (Throwable throwable) {
                this.d = new String[]{"UNRECOVERABLE ERROR", "PLEASE CONTACT THE GAME AUTHOR"};
                this.removeAll();
                this.setIgnoreRepaint(false);
                GameLoader gameLoader = this;
                new ErrorNotificationDialog(throwable, gameLoader, gameLoader.getClass().getName(), null);
            }
        }
    }

    public void stop() {
        if (this.game != null) {
            this.game.stop();
        }
    }

    public final void run() {
        if (this.game != null) {
            this.game.start();
        }
    }

    protected Game createAppletGame() {
        try {
            String string = this.getParameter("GAME");
            if (string != null) {
                if (string.endsWith(".class")) {
                    string = string.substring(0, string.length() - 6);
                }
                return (Game)Class.forName(string).newInstance();
            }
        }
        catch (Throwable throwable) {}
        return null;
    }

    public void setup(Game game, Dimension dimension, boolean bl, boolean bl2) {
        try {
            BaseGraphics baseGraphics;
            block7: {
                if (!this.validJavaVersion()) {
                    JOptionPane.showMessageDialog(null, "Sorry, this game requires Java " + this.MINIMUM_VERSION + "++ installed\n" + "Your machine only has Java " + JAVA_VERSION + " installed\n\n" + "Please install the latest Java Runtime Edition (JRE)\n" + "from http://www.java.com", "Game Initialization", 0);
                    System.exit(-1);
                }
                if (bl) {
                    baseGraphics = null;
                    try {
                        baseGraphics = new FullScreenMode(dimension, bl2);
                        ((FullScreenMode)baseGraphics).getFrame().removeWindowListener(WindowExitListener.getInstance());
                        ((FullScreenMode)baseGraphics).getFrame().addWindowListener(this);
                        this.gfx = baseGraphics;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        throwable.printStackTrace();
                        JOptionPane.showMessageDialog(null, "ERROR: Entering FullScreen Mode\nCaused by: " + throwable2.toString(), "Graphics Engine Initialization", 0);
                        bl = false;
                        if (baseGraphics == null) break block7;
                        ((FullScreenMode)baseGraphics).cleanup();
                    }
                }
            }
            if (!bl) {
                baseGraphics = new WindowedMode(dimension, bl2);
                ((WindowedMode)baseGraphics).getFrame().removeWindowListener(WindowExitListener.getInstance());
                ((WindowedMode)baseGraphics).getFrame().addWindowListener(this);
                this.gfx = baseGraphics;
            }
            this.game = game;
            this.game.bsGraphics = this.gfx;
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            throwable.printStackTrace();
            JOptionPane.showMessageDialog(null, "Fatal Error: Failed to initialize game environment!\nCaused by:\n       " + throwable3 + "\n" + "Please send above exception to the Game Author.\n", "Game Initialization", 0);
            System.exit(-1);
            return;
        }
    }

    public void setup(Game game, Dimension dimension, boolean bl) {
        this.setup(game, dimension, bl, true);
    }

    public Game getGame() {
        return this.game;
    }

    public void paint(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        graphics.setColor(new Color(255, 0, 0));
        graphics.fillRect(0, 0, n, n2);
        graphics.setFont(new Font("Monospaced", 0, 16));
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = n2 / 2 - (fontMetrics.getHeight() + 10) * (this.d.length / 2);
        graphics.setColor(new Color(0, 0, 0));
        try {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        catch (Exception exception) {}
        int n4 = 0;
        while (n4 < this.d.length) {
            graphics.drawString(this.d[n4], n / 2 - fontMetrics.stringWidth(this.d[n4]) / 2, n3);
            n3 += fontMetrics.getHeight() + 10;
            ++n4;
        }
    }

    protected boolean validJavaVersion() {
        this.c = this.k();
        return this.c;
    }

    private boolean k() {
        try {
            int n;
            StringTokenizer stringTokenizer = new StringTokenizer(JAVA_VERSION, ".");
            StringTokenizer stringTokenizer2 = new StringTokenizer(this.MINIMUM_VERSION, ".");
            int n2 = stringTokenizer.countTokens() > stringTokenizer2.countTokens() ? stringTokenizer.countTokens() : stringTokenizer2.countTokens();
            String string = "";
            String string2 = "";
            String string3 = "";
            int n3 = 0;
            while (n3 < n2) {
                try {
                    n = stringTokenizer.nextToken().charAt(0);
                }
                catch (Exception exception) {
                    n = 48;
                }
                string = string + (char)n;
                try {
                    n = stringTokenizer2.nextToken().charAt(0);
                    if (string3.length() > 0) {
                        string3 = string3 + ".";
                    }
                    string3 = string3 + (char)n;
                }
                catch (Exception exception) {
                    n = 48;
                }
                string2 = string2 + (char)n;
                ++n3;
            }
            n = Integer.parseInt(string);
            int n4 = Integer.parseInt(string2);
            this.MINIMUM_VERSION = string3;
            return n >= n4;
        }
        catch (Exception exception) {
            System.err.println("WARNING: MINIMUM_VERSION [" + this.MINIMUM_VERSION + "] and/or " + "JAVA_VERSION [" + JAVA_VERSION + "] value is not valid!");
            return true;
        }
    }

    public String getGraphicsDescription() {
        try {
            if (this.gfx != null) {
                return this.gfx.getGraphicsDescription();
            }
            return super.getGraphicsDescription();
        }
        catch (Exception exception) {
            if (this.gfx != null) {
                return this.gfx.getClass().toString();
            }
            return this.getClass().toString();
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (this.game != null) {
            this.game.finish();
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    static {
        String string = "1.4.1";
        try {
            string = System.getProperty("java.version");
        }
        catch (Exception exception) {}
        JAVA_VERSION = string;
    }
}

