/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.engine;

import java.net.URL;

public abstract class BaseAudioRenderer {
    public static final int PLAYING = 1;
    public static final int STOPPED = 2;
    public static final int END_OF_SOUND = 3;
    public static final int ERROR = 4;
    private URL e;
    private boolean f;
    protected int status = 2;
    protected float volume = 1.0f;

    protected abstract void playSound(URL var1);

    protected abstract void replaySound(URL var1);

    protected abstract void stopSound();

    protected void setSoundVolume(float f) {
    }

    public void play(URL uRL) {
        this.status = 1;
        if (this.e == uRL) {
            this.replaySound(uRL);
            return;
        }
        this.e = uRL;
        this.playSound(uRL);
    }

    public void play() {
        this.status = 1;
        BaseAudioRenderer baseAudioRenderer = this;
        baseAudioRenderer.replaySound(baseAudioRenderer.e);
    }

    public void stop() {
        if (this.e != null && this.status == 1) {
            this.status = 2;
            this.stopSound();
        }
    }

    public void setLoop(boolean bl) {
        this.f = bl;
    }

    public boolean isLoop() {
        return this.f;
    }

    public void setVolume(float f) {
        if (this.volume != f && this.isVolumeSupported()) {
            this.volume = f;
            this.setSoundVolume(f);
        }
    }

    public float getVolume() {
        return this.volume;
    }

    public boolean isVolumeSupported() {
        return true;
    }

    public URL getAudioFile() {
        return this.e;
    }

    public int getStatus() {
        return this.status;
    }

    public abstract boolean isAvailable();
}

