/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.object.collision;

import com.golden.gamedev.object.CollisionManager;
import com.golden.gamedev.object.Sprite;
import com.golden.gamedev.object.SpriteGroup;
import com.golden.gamedev.object.collision.CollisionRect;
import com.golden.gamedev.object.collision.CollisionShape;

public abstract class BasicCollisionGroup
extends CollisionManager {
    protected final CollisionRect rect1 = new CollisionRect();
    protected final CollisionRect rect2 = new CollisionRect();
    public boolean pixelPerfectCollision;

    public CollisionShape getCollisionShape1(Sprite sprite) {
        this.rect1.setBounds(sprite.getX(), sprite.getY(), sprite.getWidth(), sprite.getHeight());
        return this.rect1;
    }

    public CollisionShape getCollisionShape2(Sprite sprite) {
        this.rect2.setBounds(sprite.getX(), sprite.getY(), sprite.getWidth(), sprite.getHeight());
        return this.rect2;
    }

    public void checkCollision() {
        SpriteGroup spriteGroup = this.getGroup1();
        SpriteGroup spriteGroup2 = this.getGroup2();
        if (spriteGroup.isActive() && spriteGroup2.isActive()) {
            Sprite[] spriteArray = spriteGroup.getSprites();
            Sprite[] spriteArray2 = spriteGroup2.getSprites();
            int n = spriteGroup.getSize();
            int n2 = spriteGroup2.getSize();
            int n3 = 0;
            while (n3 < n) {
                CollisionShape collisionShape;
                Sprite sprite = spriteArray[n3];
                if (sprite.isActive() && (collisionShape = this.getCollisionShape1(sprite)) != null) {
                    int n4 = 0;
                    while (n4 < n2) {
                        CollisionShape collisionShape2;
                        Sprite sprite2 = spriteArray2[n4];
                        if (sprite2.isActive() && sprite != sprite2 && (collisionShape2 = this.getCollisionShape2(sprite2)) != null && this.isCollide(sprite, sprite2, collisionShape, collisionShape2)) {
                            this.collided(sprite, sprite2);
                            n = spriteGroup.getSize();
                            n2 = spriteGroup2.getSize();
                            if (!sprite.isActive() || (collisionShape = this.getCollisionShape1(sprite)) == null) break;
                        }
                        ++n4;
                    }
                }
                ++n3;
            }
        }
    }

    public boolean isCollide(Sprite sprite, Sprite sprite2, CollisionShape collisionShape, CollisionShape collisionShape2) {
        if (!this.pixelPerfectCollision) {
            return collisionShape.intersects(collisionShape2);
        }
        if (collisionShape.intersects(collisionShape2)) {
            return CollisionManager.isPixelCollide(sprite.getX(), sprite.getY(), sprite.getImage(), sprite2.getX(), sprite2.getY(), sprite2.getImage());
        }
        return false;
    }

    public abstract void collided(Sprite var1, Sprite var2);
}

