/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.object.collision;

import com.golden.gamedev.object.Background;
import com.golden.gamedev.object.CollisionManager;
import com.golden.gamedev.object.Sprite;
import com.golden.gamedev.object.SpriteGroup;
import com.golden.gamedev.object.collision.CollisionRect;
import com.golden.gamedev.object.collision.CollisionShape;
import java.awt.Rectangle;

public abstract class CollisionBounds
extends CollisionManager {
    public static final int LEFT_COLLISION = 1;
    public static final int RIGHT_COLLISION = 2;
    public static final int TOP_COLLISION = 4;
    public static final int BOTTOM_COLLISION = 8;
    private static final SpriteGroup e = new SpriteGroup("Dummy");
    private final Rectangle f = new Rectangle();
    private Sprite g;
    private int h;
    private int i;
    private int j;
    protected final CollisionRect rect1 = new CollisionRect();

    public CollisionBounds(int n, int n2, int n3, int n4) {
        this.f.setBounds(n, n2, n3, n4);
    }

    public CollisionBounds(Background background) {
        this.f.setBounds(0, 0, background.getWidth(), background.getHeight());
    }

    public void setCollisionGroup(SpriteGroup spriteGroup, SpriteGroup spriteGroup2) {
        super.setCollisionGroup(spriteGroup, e);
    }

    public void checkCollision() {
        SpriteGroup spriteGroup = this.getGroup1();
        if (spriteGroup.isActive()) {
            Sprite[] spriteArray = spriteGroup.getSprites();
            int n = spriteGroup.getSize();
            int n2 = 0;
            while (n2 < n) {
                this.g = spriteArray[n2];
                if (this.g.isActive()) {
                    CollisionBounds collisionBounds = this;
                    CollisionShape collisionShape = collisionBounds.getCollisionShape1(collisionBounds.g);
                    if (collisionShape != null) {
                        this.h = 0;
                        this.i = (int)this.g.getX();
                        this.j = (int)this.g.getY();
                        if (collisionShape.getX() < (double)this.f.x) {
                            this.i = this.f.x;
                            this.h |= 1;
                        }
                        if (collisionShape.getY() < (double)this.f.y) {
                            this.j = this.f.y;
                            this.h |= 4;
                        }
                        if (collisionShape.getX() + (double)collisionShape.getWidth() > (double)(this.f.x + this.f.width)) {
                            this.i = this.f.x + this.f.width - collisionShape.getWidth();
                            this.h |= 2;
                        }
                        if (collisionShape.getY() + (double)collisionShape.getHeight() > (double)(this.f.y + this.f.height)) {
                            this.j = this.f.y + this.f.height - collisionShape.getHeight();
                            this.h |= 8;
                        }
                        if (this.h != 0) {
                            CollisionBounds collisionBounds2 = this;
                            collisionBounds2.collided(collisionBounds2.g);
                        }
                    }
                }
                ++n2;
            }
        }
    }

    public void revertPosition1() {
        this.g.forceX(this.i);
        this.g.forceY(this.j);
    }

    public CollisionShape getCollisionShape1(Sprite sprite) {
        this.rect1.setBounds(sprite.getX(), sprite.getY(), sprite.getWidth(), sprite.getHeight());
        return this.rect1;
    }

    public boolean isCollisionSide(int n) {
        return (this.h & n) != 0;
    }

    public void setBoundary(int n, int n2, int n3, int n4) {
        this.f.setBounds(n, n2, n3, n4);
    }

    public Rectangle getBoundary() {
        return this.f;
    }

    public abstract void collided(Sprite var1);
}

