/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.object.font;

import com.golden.gamedev.object.GameFont;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class BitmapFont
implements GameFont {
    private BufferedImage[] a;
    private int w;
    private int h;
    protected int[] charIndex = new int[256];

    public BitmapFont(BufferedImage[] bufferedImageArray, String string) {
        this.a = bufferedImageArray;
        this.w = bufferedImageArray[0].getWidth();
        this.h = bufferedImageArray[0].getHeight();
        int n = 0;
        while (n < this.charIndex.length) {
            this.charIndex[n] = -1;
            ++n;
        }
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            this.charIndex[string.charAt((int)n3)] = n3;
            ++n3;
        }
    }

    public BitmapFont(BufferedImage[] bufferedImageArray) {
        this(bufferedImageArray, " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~");
    }

    public int drawString(Graphics2D graphics2D, String string, int n, int n2) {
        int n3 = string.length();
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            char c = string.charAt(n5);
            n4 = this.charIndex[c];
            if (n4 != -1) {
                try {
                    graphics2D.drawImage((Image)this.a[n4], n, n2, null);
                    n += this.getWidth(c);
                }
                catch (Exception exception) {
                    throw new RuntimeException(this + "\nunable to draw letter '" + string.charAt(n5) + "'[" + (n5 + 1) + "] in " + "\"" + string + "\"! charIndex = " + n4 + "\n" + "caused by : " + exception);
                }
            } else {
                throw new RuntimeException(this + "\nunable to draw letter [" + string.charAt(n5) + "] (" + (n5 + 1) + ") in " + "[" + string + "] text! ");
            }
            ++n5;
        }
        return n;
    }

    public int drawString(Graphics2D graphics2D, String string, int n, int n2, int n3, int n4) {
        if (n == 1) {
            return this.drawString(graphics2D, string, n2, n3);
        }
        if (n == 3) {
            return this.drawString(graphics2D, string, n2 + n4 / 2 - this.getWidth(string) / 2, n3);
        }
        if (n == 2) {
            return this.drawString(graphics2D, string, n2 + n4 - this.getWidth(string), n3);
        }
        if (n == 4) {
            int n5 = n4 - this.getWidth(string);
            if (n5 <= 0) {
                return this.drawString(graphics2D, string, n2, n3);
            }
            int n6 = string.length();
            int n7 = 0;
            int n8 = 0;
            while (n8 < n6) {
                if (string.charAt(n8++) != ' ') continue;
                ++n7;
            }
            if (n7 > 0) {
                n7 = (n5 + this.w * n7) / n7;
            }
            n8 = 0;
            while (n8 < n6) {
                int n9 = string.indexOf(32, n8);
                if (n9 == -1) {
                    n9 = n6;
                }
                String string2 = string.substring(n8, n9);
                this.drawString(graphics2D, string2, n2, n3);
                n2 += this.getWidth(string2) + n7;
                n8 = n9 + 1;
            }
            return n2;
        }
        return 0;
    }

    public int drawText(Graphics2D graphics2D, String string, int n, int n2, int n3, int n4, int n5, int n6) {
        boolean bl = true;
        int n7 = string.length();
        int n8 = n6;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        while (n11 < n7) {
            char c = string.charAt(n11++);
            n8 += this.getWidth(c);
            if (c - 32 == 0) {
                n9 = n11 - 1;
            }
            if (n8 < n4) continue;
            if (bl) {
                int n12 = n;
                this.drawString(graphics2D, string.substring(n10, n9), n12, n12 == 2 ? n2 : n2 + n6, n3, n4 - n6);
                bl = false;
            } else {
                this.drawString(graphics2D, string.substring(n10, n9), n, n2, n3, n4);
            }
            n3 += this.getHeight() + n5;
            n8 = 0;
            n10 = n11 = n9 + 1;
        }
        if (bl) {
            int n13 = n;
            this.drawString(graphics2D, string.substring(n10, n11), n13, n13 == 2 ? n2 : n2 + n6, n3, n4 - n6);
        } else if (n8 != 0) {
            this.drawString(graphics2D, string.substring(n10, n11), n == 2 ? 2 : 1, n2, n3, n4);
        }
        return n3 + this.getHeight();
    }

    public BufferedImage[] getImageFont() {
        return this.a;
    }

    public void setImageFont(BufferedImage[] bufferedImageArray, String string) {
        this.a = bufferedImageArray;
        this.w = bufferedImageArray[0].getWidth();
        this.h = bufferedImageArray[0].getHeight();
        int n = 0;
        while (n < this.charIndex.length) {
            this.charIndex[n] = -1;
            ++n;
        }
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            this.charIndex[string.charAt((int)n3)] = n3;
            ++n3;
        }
    }

    public int getWidth(char c) {
        return this.w;
    }

    public int getWidth(String string) {
        return string.length() * this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public String toString() {
        return super.toString() + " " + "[totalChar=" + this.a.length + ", width=" + this.w + ", height=" + this.h + "]";
    }

    public boolean isAvailable(char c) {
        try {
            return this.charIndex[c] != -1;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

