/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.util;

import com.golden.gamedev.util.ImageUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;

public class FontUtil {
    public static Font createTrueTypeFont(URL uRL, int n, float f) {
        Font font;
        try {
            font = Font.createFont(0, uRL.openStream());
        }
        catch (IOException iOException) {
            System.err.println("ERROR: " + uRL + " is not found or can not be read");
            font = new Font("Verdana", 0, 0);
        }
        catch (FontFormatException fontFormatException) {
            System.err.println("ERROR: " + uRL + " is not a valid true type font");
            font = new Font("Verdana", 0, 0);
        }
        return font.deriveFont(n, f);
    }

    public static BufferedImage createBitmapFont(Font font, Color color) {
        Graphics2D graphics2D = ImageUtil.createImage(1, 1).createGraphics();
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        graphics2D.dispose();
        byte[] byArray = new byte[95];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = (byte)(32 + n);
            ++n;
        }
        String string = new String(byArray);
        int n2 = fontMetrics.stringWidth(string);
        int n3 = fontMetrics.getHeight();
        int n4 = string.length();
        int n5 = 0;
        int n6 = n3 - fontMetrics.getDescent() + 1;
        Color color2 = Color.GREEN;
        if (color2.equals(color)) {
            color2 = Color.YELLOW;
        }
        BufferedImage bufferedImage = ImageUtil.createImage(n2, n3, 2);
        graphics2D = bufferedImage.createGraphics();
        graphics2D.setFont(font);
        int n7 = 0;
        while (n7 < n4) {
            char c = string.charAt(n7);
            graphics2D.setColor(color2);
            graphics2D.drawLine(n5, 0, n5, 0);
            graphics2D.setColor(color);
            graphics2D.drawString(String.valueOf(c), n5, n6);
            n5 += fontMetrics.charWidth(c);
            ++n7;
        }
        graphics2D.dispose();
        return bufferedImage;
    }
}

