/*
 * Decompiled with CFR 0.152.
 */
package com.golden.gamedev.engine.jogl;

import com.golden.gamedev.engine.BaseGraphics;
import com.golden.gamedev.engine.graphics.WindowExitListener;
import com.golden.gamedev.engine.jogl.JOGLRenderer;
import com.golden.gamedev.util.ImageUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import net.java.games.jogl.GLCanvas;
import net.java.games.jogl.GLCapabilities;
import net.java.games.jogl.GLDrawableFactory;
import net.java.games.jogl.GLEventListener;

public class JOGLFullScreenMode
implements BaseGraphics,
Comparator {
    public static final GraphicsDevice DEVICE = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
    public static final GraphicsConfiguration CONFIG = DEVICE.getDefaultConfiguration();
    private Frame d;
    private Dimension e;
    private GLCanvas f;
    private JOGLRenderer g;
    static Class a;

    public JOGLFullScreenMode(Dimension dimension, boolean bl) {
        this.e = dimension;
        if (!DEVICE.isFullScreenSupported()) {
            throw new RuntimeException("Full Screen Exclusive Mode is not supported");
        }
        this.d = new Frame("Golden T Game Engine", CONFIG);
        try {
            this.d.setIconImage(ImageUtil.getImage((URL)(a == null ? (a = JOGLFullScreenMode.a("com.golden.gamedev.engine.graphics.WindowExitListener")) : a).getResource("Icon.png")));
        }
        catch (Exception exception) {}
        this.d.addWindowListener(WindowExitListener.getInstance());
        this.d.setResizable(false);
        this.d.setIgnoreRepaint(true);
        this.d.setLayout(null);
        this.d.setUndecorated(true);
        this.d.dispose();
        DEVICE.setFullScreenWindow(this.d);
        if (!DEVICE.isDisplayChangeSupported()) {
            DEVICE.setFullScreenWindow(null);
            this.d.dispose();
            throw new RuntimeException("Changing Display Mode is not supported");
        }
        JOGLFullScreenMode jOGLFullScreenMode = this;
        DisplayMode displayMode = jOGLFullScreenMode.p(jOGLFullScreenMode.e);
        if (displayMode == null) {
            DEVICE.setFullScreenWindow(null);
            this.d.dispose();
            throw new RuntimeException("Changing Display Mode to " + this.e.width + "x" + this.e.height + " is not supported");
        }
        DEVICE.setDisplayMode(displayMode);
        this.g = new JOGLRenderer(bl);
        this.f = GLDrawableFactory.getFactory().createGLCanvas(new GLCapabilities());
        this.f.addGLEventListener((GLEventListener)this.g);
        this.f.setNoAutoRedrawMode(true);
        this.f.setFocusable(true);
        this.f.setSize(this.e);
        this.d.add((Component)this.f);
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {}
        this.f.setRenderingThread(Thread.currentThread());
        this.f.display();
        try {
            Thread.sleep(500L);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public Graphics2D getBackBuffer() {
        return this.g.getRenderer();
    }

    public boolean flip() {
        this.f.display();
        return true;
    }

    public void cleanup() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {}
        try {
            Thread.sleep(200L);
            if (this.d != null) {
                this.d.dispose();
            }
            return;
        }
        catch (Exception exception) {
            System.err.println("ERROR: Shutting down graphics context " + exception);
            System.exit(-1);
            return;
        }
    }

    public Dimension getSize() {
        return this.e;
    }

    public Component getComponent() {
        return this.f;
    }

    public Frame getFrame() {
        return this.d;
    }

    public String getGraphicsDescription() {
        return "JOGL FullScreen Mode [" + this.getSize().width + "x" + this.getSize().height + "]" + (this.isVSync() ? " with VSync" : "");
    }

    public void setWindowTitle(String string) {
        this.d.setTitle(string);
    }

    public String getWindowTitle() {
        return this.d.getTitle();
    }

    public void setWindowIcon(Image image) {
        try {
            this.d.setIconImage(image);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public Image getWindowIcon() {
        return this.d.getIconImage();
    }

    public boolean isVSync() {
        if (this.g != null) {
            return this.g.isVSync();
        }
        return false;
    }

    public JOGLRenderer getRenderer() {
        return this.g;
    }

    private DisplayMode p(Dimension dimension) {
        DisplayMode[] displayModeArray = DEVICE.getDisplayModes();
        ArrayList<DisplayMode> arrayList = new ArrayList<DisplayMode>();
        int n = 0;
        while (n < displayModeArray.length) {
            if (displayModeArray[n].getWidth() == dimension.width && displayModeArray[n].getHeight() == dimension.height) {
                arrayList.add(displayModeArray[n]);
            }
            ++n;
        }
        if (arrayList.size() == 0) {
            return null;
        }
        DisplayMode[] displayModeArray2 = arrayList.toArray(new DisplayMode[0]);
        Arrays.sort(displayModeArray2, this);
        return displayModeArray2[0];
    }

    public int compare(Object object, Object object2) {
        DisplayMode displayMode = (DisplayMode)object;
        DisplayMode displayMode2 = (DisplayMode)object2;
        int n = displayMode.getRefreshRate() > 75 ? 5000 * displayMode.getRefreshRate() : 0;
        int n2 = displayMode2.getRefreshRate() > 75 ? 5000 * displayMode2.getRefreshRate() : 0;
        return (displayMode2.getBitDepth() - displayMode.getBitDepth()) * 1000 + (displayMode2.getRefreshRate() - displayMode.getRefreshRate()) - (n2 - n);
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

