/*
 * Decompiled with CFR 0.152.
 */
package ext.gtge.forum.main.util;

import com.golden.gamedev.engine.BaseAudioRenderer;
import ibxm.FastTracker2;
import ibxm.IBXM;
import ibxm.Module;
import ibxm.ProTracker;
import ibxm.ScreamTracker3;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.SourceDataLine;

public class ModPlayer
extends BaseAudioRenderer {
    private static final int SAMPLING_RATE = 48000;
    private int song_duration;
    private int frames;
    private byte[] xm_header;
    private byte[] s3m_header;
    private byte[] mod_header;
    private byte[] output_buffer;
    private IBXM ibxm = new IBXM(48000);
    private SourceDataLine output_line;
    private boolean running;
    private Thread currentMusicThread = null;

    public void playSound(final URL audioFile) {
        if (this.currentMusicThread != null) {
            try {
                this.currentMusicThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
        }
        this.currentMusicThread = new Thread(){

            public void run() {
                ModPlayer.this.running = true;
                try {
                    InputStream input_stream = audioFile.openStream();
                    DataInputStream data_input_stream = new DataInputStream(input_stream);
                    Module module = null;
                    ModPlayer.access$102(ModPlayer.this, new byte[60]);
                    data_input_stream.readFully(ModPlayer.this.xm_header);
                    if (FastTracker2.is_xm((byte[])ModPlayer.this.xm_header)) {
                        module = FastTracker2.load_xm((byte[])ModPlayer.this.xm_header, (DataInput)data_input_stream);
                    } else {
                        ModPlayer.access$202(ModPlayer.this, new byte[96]);
                        System.arraycopy(ModPlayer.this.xm_header, 0, ModPlayer.this.s3m_header, 0, 60);
                        data_input_stream.readFully(ModPlayer.this.s3m_header, 60, 36);
                        if (ScreamTracker3.is_s3m((byte[])ModPlayer.this.s3m_header)) {
                            module = ScreamTracker3.load_s3m((byte[])ModPlayer.this.s3m_header, (DataInput)data_input_stream);
                        } else {
                            ModPlayer.access$302(ModPlayer.this, new byte[1084]);
                            System.arraycopy(ModPlayer.this.s3m_header, 0, ModPlayer.this.mod_header, 0, 96);
                            data_input_stream.readFully(ModPlayer.this.mod_header, 96, 988);
                            module = ProTracker.load_mod((byte[])ModPlayer.this.mod_header, (DataInput)data_input_stream);
                        }
                    }
                    data_input_stream.close();
                    ModPlayer.this.ibxm.set_module(module);
                    ModPlayer.this.song_duration = ModPlayer.this.ibxm.calculate_song_duration();
                    AudioFormat output_format = new AudioFormat(48000.0f, 16, 2, true, false);
                    ModPlayer.this.output_line = AudioSystem.getSourceDataLine(output_format);
                    ModPlayer.access$702(ModPlayer.this, new byte[4096]);
                    ModPlayer.this.output_line.open();
                    ModPlayer.this.output_line.start();
                    while (ModPlayer.this.song_duration > 0 && ModPlayer.this.running) {
                        ModPlayer.this.frames = 1024;
                        if (ModPlayer.this.frames > ModPlayer.this.song_duration) {
                            ModPlayer.this.frames = ModPlayer.this.song_duration;
                        }
                        ModPlayer.this.ibxm.get_audio(ModPlayer.this.output_buffer, ModPlayer.this.frames);
                        ModPlayer.this.output_line.write(ModPlayer.this.output_buffer, 0, ModPlayer.this.frames * 4);
                        ModPlayer.this.song_duration -= ModPlayer.this.frames;
                    }
                    ModPlayer.this.output_line.drain();
                    ModPlayer.this.output_line.close();
                }
                catch (Exception e) {
                    System.err.println("Problem playing audio: " + e);
                    return;
                }
            }
        };
        this.currentMusicThread.setDaemon(true);
        this.currentMusicThread.start();
    }

    protected void replaySound(URL audiofile) {
        this.playSound(audiofile);
    }

    protected void stopSound() {
        this.running = false;
    }

    public boolean isAvailable() {
        if (this.currentMusicThread != null) {
            return this.currentMusicThread.isAlive();
        }
        return false;
    }

    static /* synthetic */ byte[] access$102(ModPlayer x0, byte[] x1) {
        x0.xm_header = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$202(ModPlayer x0, byte[] x1) {
        x0.s3m_header = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$302(ModPlayer x0, byte[] x1) {
        x0.mod_header = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$702(ModPlayer x0, byte[] x1) {
        x0.output_buffer = x1;
        return x1;
    }
}

