/*
 * Decompiled with CFR 0.152.
 */
package moagg.artwork.object;

import com.golden.gamedev.GameObject;
import com.golden.gamedev.util.ImageUtil;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import moagg.artwork.object.AbstractImageFactory;
import moagg.types.Orientation;
import moagg.util.ArgumentChecker;
import org.apache.log4j.Logger;

public class MagnetImageFactory
extends AbstractImageFactory {
    private static Logger log = Logger.getLogger(MagnetImageFactory.class);
    private static final String PATH = "/gfx/object/decoration/magnet/";
    private static final int FRAMES = 4;
    private static MagnetImageFactory instance = new MagnetImageFactory();
    private BufferedImage[][] left = new BufferedImage[Orientation.values().length][4];
    private BufferedImage[][] center = new BufferedImage[Orientation.values().length][4];
    private BufferedImage[][] right = new BufferedImage[Orientation.values().length][4];

    public static MagnetImageFactory getInstance() {
        return instance;
    }

    public void init(GameObject loader) {
        int i;
        BufferedImage img;
        int frame;
        log.trace("Loading images.");
        for (frame = 0; frame < 4; ++frame) {
            img = loader.getImage("/gfx/object/decoration/magnet/left" + (frame + 1) + ".png");
            for (i = 0; i < this.left.length; ++i) {
                this.left[i][frame] = ImageUtil.rotate((BufferedImage)img, (int)(i * 90));
            }
        }
        for (frame = 0; frame < 4; ++frame) {
            img = loader.getImage("/gfx/object/decoration/magnet/center" + (frame + 1) + ".png");
            for (i = 0; i < this.center.length; ++i) {
                this.center[i][frame] = ImageUtil.rotate((BufferedImage)img, (int)(i * 90));
            }
        }
        for (frame = 0; frame < 4; ++frame) {
            img = loader.getImage("/gfx/object/decoration/magnet/right" + (frame + 1) + ".png");
            for (i = 0; i < this.right.length; ++i) {
                this.right[i][frame] = ImageUtil.rotate((BufferedImage)img, (int)(i * 90));
            }
        }
        log.trace("Finished.");
    }

    public BufferedImage[] getImages(Orientation orientation, int size) {
        ArgumentChecker.checkIntRange(size, 2, Integer.MAX_VALUE);
        log.trace("Getting images for a " + (Object)((Object)orientation) + "/" + size + " magnet.");
        int w = 0;
        int h = 0;
        switch (orientation) {
            case TOP: 
            case BOTTOM: {
                w = size;
                h = 1;
                break;
            }
            case LEFT: 
            case RIGHT: {
                w = 1;
                h = size;
            }
        }
        BufferedImage[] images = new BufferedImage[4];
        for (int frame = 0; frame < 4; ++frame) {
            images[frame] = ImageUtil.createImage((int)(16 * w), (int)(16 * h));
            Graphics2D g = images[frame].createGraphics();
            g.clearRect(0, 0, images[frame].getWidth(), images[frame].getHeight());
            int x = 0;
            int y = 0;
            switch (orientation) {
                case TOP: 
                case RIGHT: {
                    g.drawImage(this.right[orientation.ordinal()][frame], null, 16 * x, 16 * y);
                    break;
                }
                case BOTTOM: 
                case LEFT: {
                    g.drawImage(this.left[orientation.ordinal()][frame], null, 16 * x, 16 * y);
                }
            }
            switch (orientation) {
                case TOP: 
                case BOTTOM: {
                    for (x = 1; x < size - 1; ++x) {
                        g.drawImage(this.center[orientation.ordinal()][frame], null, 16 * x, 16 * y);
                    }
                    break;
                }
                case LEFT: 
                case RIGHT: {
                    for (y = 1; y < size - 1; ++y) {
                        g.drawImage(this.center[orientation.ordinal()][frame], null, 16 * x, 16 * y);
                    }
                    break;
                }
            }
            switch (orientation) {
                case TOP: 
                case RIGHT: {
                    g.drawImage(this.left[orientation.ordinal()][frame], null, 16 * x, 16 * y);
                    break;
                }
                case BOTTOM: 
                case LEFT: {
                    g.drawImage(this.right[orientation.ordinal()][frame], null, 16 * x, 16 * y);
                }
            }
            g.dispose();
        }
        return images;
    }
}

