/*
 * Decompiled with CFR 0.152.
 */
package moagg.artwork.object;

import com.golden.gamedev.GameObject;
import com.golden.gamedev.util.ImageUtil;
import java.awt.image.BufferedImage;
import java.net.URL;
import moagg.artwork.object.AbstractControllableImageFactory;
import moagg.types.math.Rectangle;
import moagg.util.ArgumentChecker;
import org.apache.log4j.Logger;

public class ShipImageFactory
extends AbstractControllableImageFactory {
    private static Logger log = Logger.getLogger(ShipImageFactory.class);
    private static final String PATH = "/gfx/object/ship/";
    private static final String[] SHIPS = new String[]{"default", "arrow", "galaxy", "akira", "defiant", "danube", "intrepid", "prometheus", "norway", "steamrunner", "birdofprey", "ktinga", "vorcha", "alienlander"};
    private static ShipImageFactory instance = new ShipImageFactory();
    private BufferedImage[][] ships = new BufferedImage[SHIPS.length][60];
    private Rectangle[] landingZones = new Rectangle[SHIPS.length];

    public static ShipImageFactory getInstance() {
        return instance;
    }

    public void init(GameObject loader) {
        log.trace("Loading images.");
        for (int i = 0; i < SHIPS.length; ++i) {
            BufferedImage ship = ImageUtil.getImage((URL)loader.bsIO.getURL(PATH + SHIPS[i] + ".png"), (int)3);
            for (int j = 0; j < 60; ++j) {
                this.ships[i][j] = ImageUtil.rotate((BufferedImage)ship, (int)(180 - 6 * j));
            }
            this.landingZones[i] = this.calculateLandingZone(ship);
            log.trace("Calculated landing zone for ship " + SHIPS[i] + ": " + this.landingZones[i]);
        }
        log.trace("Finished.");
    }

    public int getAvailableShips() {
        return SHIPS.length;
    }

    public BufferedImage[] getImages(int shipType) {
        ArgumentChecker.checkIntRange(shipType, 0, SHIPS.length);
        log.trace("Getting images for a " + SHIPS[shipType] + " ship.");
        return this.ships[shipType];
    }

    public Rectangle getLandingZone(int shipType) {
        return this.landingZones[shipType];
    }
}

