/*
 * Decompiled with CFR 0.152.
 */
package moagg.artwork.sound;

import com.golden.gamedev.GameObject;
import ext.gtge.forum.main.util.ModPlayer;
import java.net.URL;
import java.util.Random;
import moagg.artwork.sound.AbstractSoundClips;
import moagg.prefs.system.SystemPrefs;
import org.apache.log4j.Logger;

public class MusicClips
extends AbstractSoundClips {
    private static Logger log = Logger.getLogger(MusicClips.class);
    private static final String PATH = "/music/";
    private static final String[] TRACKS = new String[]{"title.mod", "track01.mod", "track02.mod", "track03.mod"};
    private static MusicClips instance = new MusicClips();
    private SystemPrefs systemPrefs = SystemPrefs.getInstance();
    private Random random = new Random();
    private ModPlayer player = null;
    private URL[] tracks = null;

    public static MusicClips getInstance() {
        return instance;
    }

    public void init(GameObject loader) {
        this.tracks = new URL[TRACKS.length];
        for (int i = 0; i < TRACKS.length; ++i) {
            this.tracks[i] = loader.bsIO.getURL(PATH + TRACKS[i]);
        }
        this.player = new ModPlayer();
        this.player.setLoop(false);
    }

    public void stop() {
        this.player.stop();
    }

    public void playTitle() {
        this.play(0);
    }

    public void play() {
        this.play(this.random.nextInt(TRACKS.length));
    }

    protected void play(int id) {
        if (this.systemPrefs.isMusic()) {
            log.trace("Playing " + this.tracks[id]);
            this.player.play(this.tracks[id]);
        }
    }

    public void update(long elapsedTime) {
        if (this.player == null) {
            return;
        }
        if (!this.systemPrefs.isMusic()) {
            return;
        }
        if (!this.player.isAvailable()) {
            this.play();
        }
    }
}

