/*
 * Decompiled with CFR 0.152.
 */
package moagg.game;

import com.golden.gamedev.GameEngine;
import com.golden.gamedev.GameObject;
import com.golden.gamedev.object.GameFont;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.text.SimpleDateFormat;
import moagg.artwork.font.FontFactory;
import moagg.game.Strings;
import moagg.prefs.score.Score;
import moagg.prefs.score.ScoreEntries;
import moagg.prefs.score.ScoreEntry;

public class HighScoreGameObject
extends GameObject {
    private static final String KEY_SCORE_HEADER = "menu.mission.top5.score";
    private static final String KEY_DATE_HEADER = "menu.mission.top5.date";
    private static final String KEY_NAME_HEADER = "menu.mission.top5.name";
    private static final Color MESSAGE_WINDOW_COLOR = new Color(64, 64, 96, 192);
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private BufferedImage background;
    private ScoreEntries entries;
    private ScoreEntry entry;
    private GameFont font = FontFactory.getInstance().getNarrowFont();

    public HighScoreGameObject(GameEngine parent, BufferedImage background, ScoreEntries entries, ScoreEntry entry) {
        super(parent);
        this.background = background;
        this.entries = entries;
        this.entry = entry;
    }

    public void initResources() {
    }

    public void render(Graphics2D g) {
        g.drawImage(this.background, null, null);
        this.renderHighScores(g);
    }

    protected void renderHighScores(Graphics2D g) {
        int w = 576;
        int h = 136;
        int x = (this.getWidth() - w) / 2;
        int y = this.getHeight() / 3;
        int margin = 16;
        int xScore = 210;
        int xDate = 240;
        int xName = 410;
        g.setColor(MESSAGE_WINDOW_COLOR);
        g.fillRect(x, y, w, h);
        this.font.drawString(g, Strings.getString(KEY_SCORE_HEADER), (x += margin) + xScore - this.font.getWidth(Strings.getString(KEY_SCORE_HEADER)), y += margin);
        this.font.drawString(g, Strings.getString(KEY_DATE_HEADER), x + xDate, y);
        this.font.drawString(g, Strings.getString(KEY_NAME_HEADER), x + xName, y);
        int rank = 1;
        y += this.font.getHeight() + 4;
        for (ScoreEntry entry : this.entries) {
            Score score = entry.getScore();
            String scoreString = score.getWrecks() + " / " + score.getPoints() + " / " + score.getElapsedTimeAsString();
            if (entry.equals(this.entry)) {
                g.setColor(Color.GRAY);
                g.fillRect(x - 4, y, w - 2 * margin + 8, this.font.getHeight());
            }
            this.font.drawString(g, String.valueOf(rank++) + ".", x, y);
            this.font.drawString(g, scoreString, x + xScore - this.font.getWidth(scoreString), y);
            this.font.drawString(g, this.sdf.format(entry.getDate()), x + xDate, y);
            this.font.drawString(g, entry.getName(), x + xName, y);
            y += this.font.getHeight();
        }
    }

    public void update(long elapsedTime) {
        if (this.bsInput.getKeyPressed() != Integer.MIN_VALUE) {
            this.finish();
        }
    }
}

