/*
 * Decompiled with CFR 0.152.
 */
package moagg.game;

import com.golden.gamedev.GameEngine;
import com.golden.gamedev.GameObject;
import com.golden.gamedev.object.Background;
import com.golden.gamedev.object.CollisionManager;
import com.golden.gamedev.object.GameFont;
import com.golden.gamedev.object.PlayField;
import com.golden.gamedev.object.Sprite;
import com.golden.gamedev.object.SpriteGroup;
import com.golden.gamedev.object.Timer;
import com.golden.gamedev.object.background.ImageBackground;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import moagg.artwork.font.FontFactory;
import moagg.artwork.object.ShipImageFactory;
import moagg.artwork.sound.MusicClips;
import moagg.game.AbstractMoaggCollisionGroup;
import moagg.game.AbstractMoaggMapCollisionGroup;
import moagg.game.SaveScreenShotThread;
import moagg.game.Strings;
import moagg.game.control.GameControl;
import moagg.game.control.GameControlImpl;
import moagg.game.control.collision.ParticleCollisionHandler;
import moagg.game.control.collision.ProjectileCollisionHandler;
import moagg.game.control.collision.ShipCollisionHandler;
import moagg.game.level.applet.ArmorApplet;
import moagg.game.level.applet.FPSApplet;
import moagg.game.level.applet.FuelApplet;
import moagg.game.level.applet.HeapApplet;
import moagg.game.level.applet.Panel;
import moagg.game.level.applet.ScoreApplet;
import moagg.game.menu.InGameSettingsMenu;
import moagg.level.LevelReader;
import moagg.model.ControllableImpl;
import moagg.model.DestroyableImpl;
import moagg.model.level.Level;
import moagg.model.level.Map;
import moagg.model.object.MoaggGameObject;
import moagg.model.object.ShootableObject;
import moagg.model.object.sprite.Crate;
import moagg.model.object.sprite.GhostShip;
import moagg.model.object.sprite.Particle;
import moagg.model.object.sprite.Platform;
import moagg.model.object.sprite.Ship;
import moagg.model.weapon.SingleFireStrategy;
import moagg.model.weapon.Weapon;
import moagg.model.weapon.ship.Blaster;
import moagg.prefs.control.ControlPrefs;
import moagg.prefs.ghost.Ghost;
import moagg.prefs.player.PlayerPrefs;
import moagg.prefs.score.Score;
import moagg.types.Rotation;
import moagg.types.math.Rectangle;
import moagg.types.math.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class LevelGameObject
extends GameObject {
    private static Logger log = Logger.getLogger(LevelGameObject.class);
    private MusicClips musicClips = MusicClips.getInstance();
    private PlayerPrefs playerPrefs = PlayerPrefs.getInstance();
    private ControlPrefs controlPrefs = ControlPrefs.getInstance();
    private Level level;
    private Background background;
    private PlayField playField;
    private SpriteGroup particles;
    private SpriteGroup projectiles;
    private SpriteGroup objects;
    private SpriteGroup ghosts;
    private SpriteGroup players;
    private Ship player = null;
    private Ship ghost = null;
    private Panel panel = null;
    private Score score = new Score();
    private Score bestScore = null;
    private Ghost ghostPlayback = null;
    private Ghost ghostRecord = null;
    private GameControlImpl gameControl;
    private boolean continueWithNextLevel = false;
    private GameFont messageFont;
    private Strategy strategy = new GameStrategy();
    private static int nextScreenShotIndex = 1;

    public LevelGameObject(GameEngine parent, String mission, String missionLevel) {
        super(parent);
        log.trace("LevelGameObject reading level " + mission + "/" + missionLevel + ".");
        this.level = LevelReader.getInstance().readLevel(mission, missionLevel, this);
        log.trace("LevelGameObject finished reading level.");
    }

    public Level getLevel() {
        return this.level;
    }

    public void setPlayer(Ship player) {
        this.player = player;
    }

    public Ship getPlayer() {
        return this.player;
    }

    public Ship getGhost() {
        return this.ghost;
    }

    public void setGhostPlayback(Ghost ghostPlayback) {
        this.ghostPlayback = ghostPlayback;
        if (ghostPlayback != null) {
            this.initGhost(ghostPlayback.getShipType());
        }
    }

    public Ghost getGhostPlayback() {
        return this.ghostPlayback;
    }

    protected void initGhost(int shipType) {
        this.ghost = new GhostShip();
        this.ghost.setImages(ShipImageFactory.getInstance().getImages(shipType));
        this.ghost.setLandingZone(ShipImageFactory.getInstance().getLandingZone(shipType));
        this.ghost.setImmutable(true);
        this.initPlayer2(this.ghost);
        this.ghosts.add((Sprite)this.ghost);
    }

    public void setGhostRecord(Ghost recordGhost) {
        this.ghostRecord = recordGhost;
    }

    public Ghost getGhostRecord() {
        return this.ghostRecord;
    }

    public void initForPreview() {
        log.trace("LevelGameObject initializing for preview.");
        this.playField = new PlayField();
        this.particles = new SpriteGroup("Particles");
        this.playField.addGroup(this.particles);
        this.projectiles = new SpriteGroup("Projectiles");
        this.playField.addGroup(this.projectiles);
        this.objects = new SpriteGroup("Objects");
        this.ghosts = new SpriteGroup("Ghosts");
        this.players = new SpriteGroup("Players");
        for (MoaggGameObject object : this.level.getPlayGround().getObjects()) {
            this.objects.add((Sprite)object);
            this.playField.add((Sprite)object);
        }
        this.player = this.initPlayer(this.player);
        this.initBackground();
        this.ghosts.setBackground(this.background);
        this.players.add((Sprite)this.player);
        this.players.setBackground(this.background);
        this.objects.setBackground(this.background);
        this.playField.setBackground(this.background);
        this.playField.getBackground().setToCenter((Sprite)this.player);
        log.trace("LevelGameObject finished initializing for preview.");
    }

    protected void initBackground() {
        this.background = new ImageBackground(this.level.getPlayGround().getMap().getImage());
        int x = 0;
        int y = 0;
        int w = this.parent.getWidth();
        int h = this.parent.getHeight() - 64;
        if (this.background.getWidth() < this.parent.getWidth()) {
            x = (w - this.background.getWidth()) / 2;
            w = this.background.getWidth();
        }
        if (this.background.getHeight() < this.parent.getHeight()) {
            y = (h - this.background.getHeight()) / 2;
        }
        this.background.setClip(x, y, w, h);
    }

    protected Ship initPlayer(Ship player) {
        if (player == null) {
            int shipType = this.playerPrefs.getShipType();
            player = new Ship();
            player.setImages(ShipImageFactory.getInstance().getImages(shipType));
            player.setLandingZone(ShipImageFactory.getInstance().getLandingZone(shipType));
            player.setImmutable(true);
            this.resetPlayer(player);
            this.initPlayer2(player);
        } else {
            this.initPlayer2(player);
        }
        return player;
    }

    protected void resetPlayer(Ship player) {
        player.setWeapon(new Blaster(new SingleFireStrategy()));
    }

    protected void initPlayer2(Ship player) {
        ControllableImpl playerControllable = new ControllableImpl();
        playerControllable.setFuelCapacity(120000L);
        playerControllable.setFuel((long)this.level.getFuelPercentage() * playerControllable.getFuelCapacity() / 100L);
        playerControllable.setFuelPerMilliSecond(1L);
        playerControllable.setMass(1000L);
        playerControllable.setThrust(false);
        playerControllable.setThrustForce(0.25);
        playerControllable.setRotation(Rotation.NONE);
        playerControllable.setRotationSpeed(0.2);
        player.setControllable(playerControllable);
        player.setAngle(180.0);
        DestroyableImpl playerDestroyable = new DestroyableImpl();
        playerDestroyable.setHealth(3);
        player.setDestroyable(playerDestroyable);
        player.getCrates().clear();
        if (this.level.getStartPlatform() != null) {
            player.setLandedPlatform(this.level.getStartPlatform());
            Rectangle landingZone = this.level.getStartPlatform().getLandingZone();
            player.setX(landingZone.getX() + landingZone.getW() / 2 - player.getWidth() / 2);
            player.setY(landingZone.getY() - player.getLandingZone().getY());
        } else {
            player.setLandedPlatform(null);
            player.setX(this.level.getStartPosition().getX() - player.getWidth() / 2);
            player.setY(this.level.getStartPosition().getY() - player.getHeight() / 2);
        }
        player.setSpeed(new Vector());
        player.setActive(true);
    }

    public GameControl getGameControl() {
        return this.gameControl;
    }

    public SpriteGroup getParticlesSpriteGroup() {
        return this.particles;
    }

    public SpriteGroup getProjectilesSpriteGroup() {
        return this.projectiles;
    }

    public SpriteGroup getObjectsSpriteGroup() {
        return this.objects;
    }

    public SpriteGroup getGhostsSpriteGroup() {
        return this.ghosts;
    }

    public SpriteGroup getPlayersSpriteGroup() {
        return this.players;
    }

    public void setBestScore(Score bestScore) {
        this.bestScore = bestScore;
    }

    public void initResources() {
        log.trace("LevelGameObject initializing for playing.");
        this.initCollisionGroups();
        this.initPanel();
        this.playField.update(0L);
        this.players.update(0L);
        this.messageFont = FontFactory.getInstance().getMenuFont();
        this.bsTimer.refresh();
        this.gameControl = new GameControlImpl(this);
        log.trace("LevelGameObject finished initializing for playing.");
    }

    protected void initCollisionGroups() {
        Map map = this.level.getPlayGround().getMap();
        SpriteGroup backGroundGroup = new SpriteGroup("Background");
        backGroundGroup.add(new Sprite());
        this.playField.addCollisionGroup(backGroundGroup, this.players, (CollisionManager)new PlaygroundPlayerCollisionGroup(map));
        this.playField.addCollisionGroup(backGroundGroup, this.projectiles, (CollisionManager)new PlaygroundProjectileCollisionGroup(map));
        this.playField.addCollisionGroup(backGroundGroup, this.particles, (CollisionManager)new PlaygroundParticleCollisionGroup(map));
        this.playField.addCollisionGroup(this.objects, this.players, (CollisionManager)new ObjectPlayerCollisionGroup());
        this.playField.addCollisionGroup(this.projectiles, this.players, (CollisionManager)new ObjectPlayerCollisionGroup());
        this.playField.addCollisionGroup(this.projectiles, this.objects, (CollisionManager)new ProjectileObjectCollisionGroup());
        this.playField.addCollisionGroup(this.projectiles, this.projectiles, (CollisionManager)new ProjectileProjectileCollisionGroup());
    }

    protected void initPanel() {
        this.panel = new Panel(this);
        ScoreApplet scoreApplet = new ScoreApplet();
        scoreApplet.setScore(this.score);
        scoreApplet.setBestScore(this.bestScore);
        this.panel.addAppletToRight(scoreApplet);
        FuelApplet fuelApplet = new FuelApplet();
        fuelApplet.setControllable(this.player);
        this.panel.addAppletToRight(fuelApplet);
        ArmorApplet armorApplet = new ArmorApplet();
        armorApplet.setDestroyable(this.player);
        this.panel.addAppletToRight(armorApplet);
        if (this.parent.isDistribute()) {
            FPSApplet fpsApplet = new FPSApplet(this);
            this.panel.addAppletToLeft(fpsApplet);
        } else {
            this.panel.addAppletToLeft(new HeapApplet());
        }
    }

    public void render(Graphics2D g) {
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.playField.render(g);
        this.ghosts.render(g);
        this.players.render(g);
        this.panel.render(g);
        this.strategy.render(g);
    }

    public void renderPreview(Graphics2D g) {
        this.playField.render(g);
        this.players.render(g);
    }

    public void update(long elapsedTime) {
        this.musicClips.update(elapsedTime);
        if (this.gameControl.isFinished() && this.strategy instanceof GameStrategy) {
            this.continueWithNextLevel();
            return;
        }
        this.strategy.update(elapsedTime);
    }

    protected void updateKeyboard() {
        boolean right;
        boolean left;
        this.player.setThrust(this.keyDown(this.controlPrefs.getThrust()));
        Weapon weapon = this.player.getWeapon();
        if (weapon != null) {
            weapon.setShoot(this.keyDown(this.controlPrefs.getShoot()));
        }
        if ((left = this.keyDown(this.controlPrefs.getLeft())) ^ (right = this.keyDown(this.controlPrefs.getRight()))) {
            if (left) {
                this.player.setRotation(Rotation.LEFT);
            }
            if (right) {
                this.player.setRotation(Rotation.RIGHT);
            }
        } else if (this.keyDown(this.controlPrefs.getAlign())) {
            this.player.setRotation(Rotation.ALIGN);
        } else if (!left && !right) {
            this.player.setRotation(Rotation.NONE);
        }
    }

    public void finish() {
        super.finish();
        this.gameControl.cleanup();
    }

    public void continueWithNextLevel() {
        this.continueWithNextLevel = true;
        this.finish();
    }

    public boolean isContinueWithNextLevel() {
        return this.continueWithNextLevel;
    }

    public Score getScore() {
        return this.score;
    }

    private class ProjectileProjectileCollisionGroup
    extends AbstractMoaggCollisionGroup {
        private ProjectileProjectileCollisionGroup() {
        }

        public void collided(Sprite sprite1, Sprite sprite2) {
            ProjectileCollisionHandler handler = new ProjectileCollisionHandler(LevelGameObject.this.gameControl);
            handler.onCollided((ShootableObject)sprite1, (ShootableObject)sprite2);
        }
    }

    private class ProjectileObjectCollisionGroup
    extends AbstractMoaggCollisionGroup {
        private ProjectileObjectCollisionGroup() {
        }

        public void collided(Sprite sprite1, Sprite sprite2) {
            ProjectileCollisionHandler handler = new ProjectileCollisionHandler(LevelGameObject.this.gameControl);
            handler.onCollided((ShootableObject)sprite1, (MoaggGameObject)sprite2);
        }
    }

    private class ObjectPlayerCollisionGroup
    extends AbstractMoaggCollisionGroup {
        private ObjectPlayerCollisionGroup() {
        }

        public void collided(Sprite sprite1, Sprite sprite2) {
            ShipCollisionHandler handler = new ShipCollisionHandler(LevelGameObject.this.gameControl);
            handler.onCollided((Ship)sprite2, (MoaggGameObject)sprite1);
        }
    }

    private class PlaygroundParticleCollisionGroup
    extends AbstractMoaggMapCollisionGroup {
        public PlaygroundParticleCollisionGroup(Map map) {
            super(map);
        }

        public void collided(Sprite sprite1, Sprite sprite2) {
            ParticleCollisionHandler handler = new ParticleCollisionHandler(LevelGameObject.this.gameControl);
            handler.onCollidedWithPlayfield((Particle)sprite2);
        }
    }

    private class PlaygroundProjectileCollisionGroup
    extends AbstractMoaggMapCollisionGroup {
        public PlaygroundProjectileCollisionGroup(Map map) {
            super(map);
        }

        public void collided(Sprite sprite1, Sprite sprite2) {
            ProjectileCollisionHandler handler = new ProjectileCollisionHandler(LevelGameObject.this.gameControl);
            handler.onCollidedWithPlayfield((ShootableObject)sprite2);
        }
    }

    private class PlaygroundPlayerCollisionGroup
    extends AbstractMoaggMapCollisionGroup {
        public PlaygroundPlayerCollisionGroup(Map map) {
            super(map);
        }

        public void collided(Sprite sprite1, Sprite sprite2) {
            ShipCollisionHandler handler = new ShipCollisionHandler(LevelGameObject.this.gameControl);
            handler.onCollidedWithPlayfield((Ship)sprite2);
        }
    }

    private class UnloadCrateStrategy
    extends AbstractGameStrategy
    implements Strategy {
        private Timer timer;
        private Crate crate;

        public UnloadCrateStrategy() {
            this.timer = new Timer(400);
            this.crate = null;
            this.initCrateToUnload();
        }

        protected void initCrateToUnload() {
            this.crate = LevelGameObject.this.gameControl.getCrateToUnload();
            LevelGameObject.this.player.dropCrate(this.crate);
            Platform platform = LevelGameObject.this.player.getLandedPlatform();
            double x = LevelGameObject.this.player.getX() + (double)(LevelGameObject.this.player.getWidth() / 2);
            int xOffset = LevelGameObject.this.player.getLandingZone().getW() / 2 - this.crate.getWidth() / 4;
            Rectangle platformLandingZone = platform.getLandingZone();
            if (x - (double)platformLandingZone.getX() > (double)(platformLandingZone.getX() + platformLandingZone.getW()) - x) {
                xOffset = -xOffset;
            }
            this.crate.setX(x + (double)xOffset - (double)(this.crate.getWidth() / 2));
            this.crate.setY(LevelGameObject.this.player.getY() + (double)LevelGameObject.this.player.getLandingZone().getY() - (double)this.crate.getHeight() + 1.0);
            this.crate.setHorizontalSpeed(platform.getHorizontalSpeed());
            this.crate.setVerticalSpeed(platform.getVerticalSpeed());
            this.crate.show();
        }

        public void update(long elapsedTime) {
            this.updateObjects(elapsedTime);
            LevelGameObject.this.gameControl.update(elapsedTime);
            this.checkScreenShot();
            this.checkInGameMenu();
            this.checkPopUpText();
            this.checkExplosionDelay();
            if (this.timer.action(elapsedTime)) {
                this.timer.refresh();
                if (this.crate == null) {
                    this.initCrateToUnload();
                } else {
                    this.crate.setRescued(true);
                    this.crate.setActive(false);
                    this.crate = null;
                    if (!LevelGameObject.this.gameControl.hasCratesToUnload()) {
                        LevelGameObject.this.strategy = new GameStrategy();
                    }
                }
            }
        }

        public void render(Graphics2D g) {
            if (this.crate != null) {
                this.crate.render(g);
            }
        }
    }

    private class ExplosionDelayStrategy
    extends AbstractGameStrategy
    implements Strategy {
        private Timer timer;

        public ExplosionDelayStrategy() {
            this.timer = new Timer(1500);
            LevelGameObject.this.score.incWrecks();
        }

        public void update(long elapsedTime) {
            this.updateObjects(elapsedTime);
            LevelGameObject.this.gameControl.update(elapsedTime);
            this.checkScreenShot();
            this.checkInGameMenu();
            this.checkPopUpText();
            if (this.timer.action(elapsedTime)) {
                LevelGameObject.this.strategy = new GameStrategy();
                LevelGameObject.this.resetPlayer(LevelGameObject.this.player);
                if (!LevelGameObject.this.isContinueWithNextLevel()) {
                    LevelGameObject.this.initPlayer2(LevelGameObject.this.player);
                }
            }
        }

        public void render(Graphics2D g) {
        }
    }

    private class ScreenShotStrategy
    extends PopUpStrategy {
        private final String SCREENSHOT_PREFIX = "screenshot";
        private SaveScreenShotThread saveScreenShotThread;

        public ScreenShotStrategy(BufferedImage image) {
            super(Strings.getString("game.level.screenshot"));
            this.SCREENSHOT_PREFIX = "screenshot";
            this.saveScreenShotThread = new SaveScreenShotThread(image, this.getNextScreenShotFile());
            this.saveScreenShotThread.start();
        }

        protected File getNextScreenShotFile() {
            String fileName;
            File file;
            while ((file = new File(fileName = "screenshot-" + StringUtils.leftPad(String.valueOf(nextScreenShotIndex++), 2, '0') + ".png")).exists()) {
            }
            return file;
        }

        public void update(long elapsedTime) {
            try {
                this.saveScreenShotThread.join();
                this.saveScreenShotThread = null;
            }
            catch (InterruptedException e) {
                log.warn("Error joining thread saving screenshot.", e);
            }
            LevelGameObject.this.strategy = new GameStrategy();
        }
    }

    private class PopUpStrategy
    implements Strategy {
        private final Color MESSAGE_WINDOW_COLOR = new Color(64, 64, 96, 192);
        private String[] text;

        public PopUpStrategy(String text) {
            this.text = text.split("\\n");
        }

        public void update(long elapsedTime) {
            if (LevelGameObject.this.bsInput.getKeyPressed() != Integer.MIN_VALUE) {
                LevelGameObject.this.gameControl.clearPopUpText();
                LevelGameObject.this.strategy = new GameStrategy();
            }
        }

        public void render(Graphics2D g) {
            int boxMargin = LevelGameObject.this.getWidth() / 6;
            int textMargin = 16;
            int y = boxMargin + textMargin;
            for (String line : this.text) {
                y = LevelGameObject.this.messageFont.drawText(g, line, 1, boxMargin + textMargin, y, LevelGameObject.this.getWidth() - 2 * boxMargin - 2 * textMargin, 0, 0);
            }
            g.setColor(this.MESSAGE_WINDOW_COLOR);
            g.fillRect(boxMargin, boxMargin, LevelGameObject.this.getWidth() - 2 * boxMargin, y - boxMargin + textMargin);
            y = boxMargin + textMargin;
            for (String line : this.text) {
                y = LevelGameObject.this.messageFont.drawText(g, line, 1, boxMargin + textMargin, y, LevelGameObject.this.getWidth() - 2 * boxMargin - 2 * textMargin, 0, 0);
            }
        }
    }

    private class GameStrategy
    extends AbstractGameStrategy
    implements Strategy {
        private GameStrategy() {
        }

        public void update(long elapsedTime) {
            this.updateObjects(elapsedTime);
            LevelGameObject.this.updateKeyboard();
            LevelGameObject.this.gameControl.update(elapsedTime);
            this.checkScreenShot();
            this.checkInGameMenu();
            this.checkPopUpText();
            this.checkUnloadCrates();
            this.checkExplosionDelay();
        }

        public void render(Graphics2D g) {
        }
    }

    private abstract class AbstractGameStrategy {
        private AbstractGameStrategy() {
        }

        public void updateObjects(long elapsedTime) {
            LevelGameObject.this.ghosts.update(elapsedTime);
            LevelGameObject.this.players.update(elapsedTime);
            LevelGameObject.this.playField.update(elapsedTime);
            LevelGameObject.this.playField.getBackground().setToCenter((Sprite)LevelGameObject.this.player);
            LevelGameObject.this.panel.update(elapsedTime);
        }

        protected void checkScreenShot() {
            if (LevelGameObject.this.keyPressed(LevelGameObject.this.controlPrefs.getScreenShot())) {
                LevelGameObject.this.strategy = new ScreenShotStrategy(LevelGameObject.this.takeScreenShot());
            }
        }

        protected void checkInGameMenu() {
            if (LevelGameObject.this.keyPressed(27)) {
                new InGameSettingsMenu(LevelGameObject.this.parent, LevelGameObject.this).start();
            }
        }

        protected void checkPopUpText() {
            if (LevelGameObject.this.gameControl.getPopUpText() != null) {
                LevelGameObject.this.strategy = new PopUpStrategy(LevelGameObject.this.gameControl.getPopUpText());
            }
        }

        protected void checkUnloadCrates() {
            if (LevelGameObject.this.gameControl.hasCratesToUnload()) {
                LevelGameObject.this.strategy = new UnloadCrateStrategy();
            }
        }

        protected void checkExplosionDelay() {
            if (!LevelGameObject.this.player.isActive()) {
                LevelGameObject.this.strategy = new ExplosionDelayStrategy();
            }
        }
    }

    private static interface Strategy {
        public void update(long var1);

        public void render(Graphics2D var1);
    }
}

