/*
 * Decompiled with CFR 0.152.
 */
package moagg.game;

import com.golden.gamedev.Game;
import com.golden.gamedev.GameEngine;
import com.golden.gamedev.GameLoader;
import com.golden.gamedev.GameObject;
import com.golden.gamedev.engine.timer.GageTimer;
import com.golden.gamedev.funbox.ErrorNotificationDialog;
import moagg.game.ReleaseProperties;
import moagg.game.SelectDifficultyScreen;
import moagg.game.SelectLanguageScreen;
import moagg.game.SplashScreen;
import moagg.game.SystemProperties;
import moagg.prefs.player.PlayerPrefs;
import moagg.prefs.system.SystemPrefs;
import moagg.types.prefs.Difficulty;
import moagg.types.prefs.Language;
import moagg.types.prefs.TimerType;
import org.apache.log4j.Logger;

public class MoaggGameEngine
extends GameEngine {
    public static Logger log = Logger.getLogger(MoaggGameEngine.class);
    private static SystemPrefs systemPrefs = SystemPrefs.getInstance();
    private static PlayerPrefs playerPrefs = PlayerPrefs.getInstance();

    public MoaggGameEngine() {
        this.distribute = ReleaseProperties.getInstance().isDistribute();
    }

    protected void initEngine() {
        this.initTimer();
        super.initEngine();
        this.bsIO.setMode(3);
        this.bsInput.setMouseVisible(false);
    }

    protected void initTimer() {
        TimerType timerType = null;
        String timer = SystemProperties.getInstance().getTimer();
        if (timer != null) {
            timerType = TimerType.fromString(timer);
            log.info("Usage of " + (Object)((Object)timerType) + " timer forced via system properties.");
        } else {
            timerType = systemPrefs.getTimer();
        }
        switch (timerType) {
            case SYSTEM: {
                break;
            }
            case GAGE: {
                this.bsTimer = new GageTimer();
            }
        }
    }

    public void initResources() {
        this.nextGameID = 0;
    }

    public GameObject getGame(int gameId) {
        Language language = systemPrefs.getLanguage();
        if (language == null) {
            return new SelectLanguageScreen(this);
        }
        systemPrefs.getLanguage().setDefaultLocale();
        Difficulty difficulty = playerPrefs.getDifficulty();
        if (difficulty == null) {
            return new SelectDifficultyScreen(this);
        }
        return new SplashScreen(this);
    }

    public void notifyError(Throwable error) {
        new ErrorNotificationDialog(error, this.bsGraphics, ReleaseProperties.getInstance().getDescription(), ReleaseProperties.getInstance().getAuthorEmail());
    }

    public static void main(String[] args) {
        GameLoader game = new GameLoader();
        game.setup((Game)new MoaggGameEngine(), systemPrefs.getScreenResolution().createDimension(), systemPrefs.isFullScreen());
        game.start();
    }
}

