/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.control.handler;

import com.golden.gamedev.object.Timer;
import java.util.Iterator;
import moagg.game.control.GameControlImpl;
import moagg.game.control.handler.GameControlHandler;
import moagg.model.object.sprite.Ship;
import moagg.prefs.ghost.Ghost;
import moagg.prefs.ghost.GhostFrame;

public class GhostPlaybackHandler
implements GameControlHandler {
    private boolean firstUpdate = true;
    private Timer timer = null;
    private Iterator<GhostFrame> iter = null;

    public void update(GameControlImpl gameControl, long elapsedTime) {
        if (this.firstUpdate) {
            Ghost data = gameControl.getGhostPlayback();
            this.timer = new Timer(data.getFrameDelay());
            this.iter = data.iterator();
            this.firstUpdate = false;
        }
        if (this.timer.action(elapsedTime)) {
            Ship ghost = gameControl.getGhost();
            if (this.iter.hasNext()) {
                GhostFrame frame = this.iter.next();
                if (frame.isActive()) {
                    ghost.setActive(true);
                    ghost.setHealth(1);
                } else {
                    ghost.setHealth(0);
                }
                ghost.setX(frame.getX());
                ghost.setY(frame.getY());
                ghost.setAngle(frame.getAngle());
                ghost.setThrust(frame.isThrust());
                ghost.setHorizontalSpeed(frame.getVX());
                ghost.setVerticalSpeed(frame.getVY());
            } else {
                ghost.setHorizontalSpeed(0.0);
                ghost.setVerticalSpeed(0.0);
            }
        }
    }
}

