/*
 * Decompiled with CFR 0.152.
 */
package moagg.game.control.handler;

import com.golden.gamedev.object.Sprite;
import moagg.game.control.GameControlImpl;
import moagg.game.control.handler.GameControlHandler;
import moagg.model.object.sprite.Missile;
import moagg.model.object.sprite.Ship;
import moagg.types.Rotation;
import moagg.types.math.Vector;
import moagg.util.math.AngleUtil;

public class MissileControlHandler
implements GameControlHandler {
    public void update(GameControlImpl gameControl, long elapsedTime) {
        for (Sprite sprite : gameControl.getProjectilesSpriteGroup().getSprites()) {
            if (!(sprite instanceof Missile)) continue;
            this.updateMissile((Missile)sprite, gameControl, elapsedTime);
        }
    }

    protected void updateMissile(Missile missile, GameControlImpl gameControl, long elapsedTime) {
        double relativeTargetAngle;
        if (!missile.isActive()) {
            return;
        }
        Ship player = gameControl.getPlayer();
        if (player == null || missile.getFuel() == 0L) {
            missile.setRotation(Rotation.NONE);
            return;
        }
        double targetAngle = AngleUtil.getAngle(missile.getPositionRectangle(), player.getPositionRectangle());
        Vector g = gameControl.getGravityFor(missile);
        for (relativeTargetAngle = missile.getTargetAngle(targetAngle, g) - missile.getAngle(); relativeTargetAngle >= 180.0; relativeTargetAngle -= 360.0) {
        }
        while (relativeTargetAngle < -180.0) {
            relativeTargetAngle += 360.0;
        }
        missile.setRotation(relativeTargetAngle > 0.0 ? Rotation.LEFT : (relativeTargetAngle < 0.0 ? Rotation.RIGHT : Rotation.NONE));
    }
}

